/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.ImageLoader;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.EntityDecl;
import com.argo21.jxp.dtd.EntityDeclNode;
import com.argo21.jxp.vdtd.DeclNodeData;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;

public class EntityDeclNodeData
extends DeclNodeData {
    protected String refpath = null;
    protected String publicId = null;
    protected String systemId = null;
    protected String notationName = null;
    protected int type = 0;
    protected boolean pedecl = false;
    protected DTDDocument exdtd = null;

    public EntityDeclNodeData(String entityName, String entityValue, String refpath) {
        super(6, entityName, entityValue);
        this.type = 0;
        this.refpath = refpath;
    }

    public EntityDeclNodeData(EntityDecl decl, String refpath) {
        super(6, decl.getNodeName(), decl.getEntityValue());
        this.type = decl.getType();
        this.pedecl = decl.getPeDecl();
        this.publicId = decl.getPublicId();
        this.systemId = decl.getSystemId();
        this.notationName = decl.getNotationName();
        this.refpath = refpath;
    }

    @Override
    protected Object clone() {
        EntityDeclNodeData data = new EntityDeclNodeData(this.nodename, (String)this.nodevalue, this.refpath);
        data.type = this.type;
        data.pedecl = this.pedecl;
        data.publicId = this.publicId;
        data.systemId = this.systemId;
        data.notationName = this.notationName;
        return data;
    }

    public String getEntityName() {
        return this.nodename;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getNotationName() {
        return this.notationName;
    }

    public int getType() {
        return this.type;
    }

    public boolean getPeDecl() {
        return this.pedecl;
    }

    public String getEntityValue() {
        return (String)this.nodevalue;
    }

    public DeclNode getDeclMode(DTDDocument dtd) {
        int type = this.getType();
        if (type == 0) {
            return new EntityDeclNode((DTDDecl)dtd, this.nodename, this.getPeDecl(), (String)this.nodevalue);
        }
        if (type == 1) {
            return new EntityDeclNode(dtd, this.nodename, this.getPeDecl(), null, this.getSystemId(), this.getNotationName());
        }
        return new EntityDeclNode(dtd, this.nodename, this.getPeDecl(), this.getPublicId(), this.getSystemId(), this.getNotationName());
    }

    public void setEntityName(String entityname) {
        this.nodename = entityname;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        this.exdtd = null;
        this.systemId = systemId;
    }

    public void setNotationName(String notationName) {
        this.notationName = notationName;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setPeDecl(boolean pedecl) {
        this.pedecl = pedecl;
    }

    public void setEntityValue(String entityValue) {
        this.nodevalue = entityValue;
    }

    @Override
    public ImageIcon getImageIcon() {
        return ImageLoader.load("entity.gif", "ENTITY");
    }

    public DTDDocument loadRefrenceDeclNode() {
        if (this.exdtd != null) {
            return this.exdtd;
        }
        if (this.systemId == null) {
            return null;
        }
        int k = this.systemId.indexOf(":");
        String address = this.refpath == null || k > 0 ? this.systemId : this.refpath + this.systemId;
        this.exdtd = new DTDDocument();
        try {
            this.exdtd.load(address);
        }
        catch (IOException e) {
            this.exdtd = null;
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exdtd.resolveParameterRefrance();
        return this.exdtd;
    }

    public void addAllDeclNodes(int type, Vector vector) {
        if (!this.pedecl || this.type == 0) {
            return;
        }
        if (this.loadRefrenceDeclNode() == null) {
            return;
        }
        DeclNodeList nodes = this.exdtd.getAllDeclNode();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = nodes.item(i);
            if (node.getNodeType() != type) continue;
            vector.addElement(node.getNodeName());
        }
    }

    public void addAllElements(Vector vector) {
        if (!this.pedecl || this.type == 0) {
            return;
        }
        if (this.loadRefrenceDeclNode() == null) {
            return;
        }
        Enumeration em = this.exdtd.getAllElementDecls();
        while (em.hasMoreElements()) {
            DeclNode node = (DeclNode)em.nextElement();
            vector.addElement(node.getNodeName());
        }
    }

    public void addAllValueEntitys(Vector vector) {
        if (!this.pedecl || this.type == 0) {
            return;
        }
        if (this.loadRefrenceDeclNode() == null) {
            return;
        }
        Enumeration em = this.exdtd.getAllEntityDecls();
        while (em.hasMoreElements()) {
            EntityDecl node = (EntityDecl)em.nextElement();
            if (!node.getPeDecl() || node.getType() != 0) continue;
            vector.addElement(node.getNodeName());
        }
    }

    public void addAllPerefEntitys(Vector vector) {
        if (!this.pedecl || this.type == 0) {
            return;
        }
        if (this.loadRefrenceDeclNode() == null) {
            return;
        }
        Enumeration em = this.exdtd.getAllEntityDecls();
        while (em.hasMoreElements()) {
            EntityDecl node = (EntityDecl)em.nextElement();
            if (!node.getPeDecl() || node.getType() == 0) continue;
            vector.addElement(node.getNodeName());
        }
    }

    public String getPerefEntityValue(String entityName) {
        if (!this.pedecl || this.type == 0) {
            return null;
        }
        if (this.loadRefrenceDeclNode() == null) {
            return null;
        }
        EntityDecl data = this.exdtd.getEntityDecl(entityName);
        if (data == null) {
            return null;
        }
        if (data.getPeDecl() && data.getType() == 0) {
            String value = data.getEntityValue();
            value = this.repleaceEntity(value);
            return value;
        }
        return null;
    }

    String repleaceEntity(String entityValue) {
        int pos1 = entityValue.indexOf("%");
        if (pos1 < 0) {
            return entityValue;
        }
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (pos1 >= 0) {
            sb.append(entityValue.substring(pos, pos1));
            pos = pos1 + 1;
            pos1 = entityValue.indexOf(";", pos);
            if (pos1 > pos) {
                String entity = entityValue.substring(pos, pos1);
                String value = this.getPerefEntityValue(entity);
                if (value != null) {
                    value = this.repleaceEntity(value);
                }
                if (value != null) {
                    sb.append(value);
                } else {
                    sb.append('%');
                    sb.append(entity);
                    sb.append(';');
                }
                pos = pos1 + 1;
            } else {
                if (pos1 != pos) {
                    sb.append(entityValue.substring(pos));
                    break;
                }
                ++pos;
            }
            pos1 = entityValue.indexOf("%", pos);
        }
        sb.append(entityValue.substring(pos));
        return sb.toString();
    }
}

