/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.EntityDecl;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorFrame;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.EntityDeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

class EntityDeclPanel
extends ContentsEditPanel {
    static String NON = EntityDeclPanel.getMessage("UNDEF_MARK");
    TextFieldEx nameField;
    JRadioButton[] typeOption = new JRadioButton[3];
    JCheckBox peField;
    TextFieldEx publicField;
    TextFieldEx valueField;
    JButton searchButton;
    JButton openButton;
    ComboTextFieldEx notationField;
    JLabel publicLabel;
    JLabel valueLabel;
    JLabel notationLabel;
    JPanel valuePanel;
    ResultPanel result;

    EntityDeclPanel() {
    }

    @Override
    public void init(DTDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(EntityDeclPanel.getMessage("TL_ENTTITY")));
        JLabel label = new JLabel(EntityDeclPanel.getMessage("LAB_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object source, String value) {
                EntityDeclPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder(EntityDeclPanel.getMessage("TL_ENTITY_TYPE")));
        tp.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.peField = new JCheckBox(EntityDeclPanel.getMessage("LAB_PARAM"));
        tp.add((Component)this.peField, c);
        ++c.gridy;
        this.peField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDeclPanel.this.peChanged();
            }
        });
        Font defaultFont = this.getDefaultFont();
        this.peField.setFont(defaultFont);
        this.typeOption[0] = new JRadioButton(EntityDeclPanel.getMessage("LAB_VALUE_REF"));
        tp.add((Component)this.typeOption[0], c);
        ++c.gridy;
        this.typeOption[1] = new JRadioButton(EntityDeclPanel.getMessage("LAB_SYSTEM"));
        tp.add((Component)this.typeOption[1], c);
        ++c.gridy;
        this.typeOption[2] = new JRadioButton(EntityDeclPanel.getMessage("LAB_PUBLIC"));
        tp.add((Component)this.typeOption[2], c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDeclPanel.this.typeChanged(e);
            }
        };
        for (int i = 0; i < 3; ++i) {
            group.add(this.typeOption[i]);
            this.typeOption[i].setFont(defaultFont);
            this.typeOption[i].addActionListener(al);
        }
        this.add((Component)tp, gc);
        ++gc.gridy;
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        this.valuePanel.setOpaque(true);
        this.valuePanel.setBorder(BorderFactory.createTitledBorder(EntityDeclPanel.getMessage("TL_CONTENTS")));
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.publicLabel = new JLabel(EntityDeclPanel.getMessage("LAB_PUBLIC"));
        this.valuePanel.add((Component)this.publicLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.publicField = new TextFieldEx(16){

            @Override
            public boolean valueChanged(Object source, String value) {
                EntityDeclPanel.this.publicChanged(value.trim());
                return true;
            }
        };
        this.valuePanel.add((Component)this.publicField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.valueLabel = new JLabel(EntityDeclPanel.getMessage("LAB_REF_VALUE"));
        this.valuePanel.add((Component)this.valueLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.valueField = new TextFieldEx(16){

            @Override
            public boolean valueChanged(Object source, String value) {
                EntityDeclPanel.this.refChanged(value.trim());
                return true;
            }
        };
        this.valuePanel.add((Component)this.valueField, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.searchButton = new JButton(ImageLoader.load("finddtd.gif", "find"));
        this.searchButton.setMargin(new Insets(0, 0, 0, 0));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDeclPanel.this.findFileName();
            }
        });
        this.valuePanel.add((Component)this.searchButton, c);
        ++c.gridx;
        this.openButton = new JButton(ImageLoader.load("opendtd.gif", "open"));
        this.openButton.setMargin(new Insets(0, 0, 0, 0));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDeclPanel.this.openEditor();
            }
        });
        this.valuePanel.add((Component)this.openButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.notationLabel = new JLabel(EntityDeclPanel.getMessage("LAB_NOTATION"));
        this.valuePanel.add((Component)this.notationLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.notationField = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                EntityDeclPanel.this.notationChanged(value.trim());
                return true;
            }
        };
        this.valuePanel.add((Component)this.notationField, c);
        this.add((Component)this.valuePanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new ResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void nameChanged(String value) {
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, EntityDeclPanel.getMessage("INVALID_NAME", value));
                this.nameField.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelect(6, value)) {
                JOptionPane.showMessageDialog(this.parentPanel, EntityDeclPanel.getMessage("DOUBLE_NAME", value));
                this.nameField.setText(s);
                return;
            }
            this.nameChangedTo(value);
            this.viewResult();
        }
    }

    void typeChanged(ActionEvent e) {
        JRadioButton opt = (JRadioButton)e.getSource();
        if (opt.isSelected()) {
            if (opt == this.typeOption[0]) {
                this.typeChanged(0);
            } else if (opt == this.typeOption[1]) {
                this.typeChanged(1);
            } else {
                this.typeChanged(2);
            }
        }
        this.contentsChanged();
    }

    void typeChanged(int type) {
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        if (type == 0) {
            this.publicLabel.setVisible(false);
            this.publicField.setVisible(false);
            this.valueLabel.setText(EntityDeclPanel.getMessage("LAB_REF_VALUE"));
            this.openButton.setVisible(false);
            this.searchButton.setVisible(false);
            this.valueField.setText(data.getEntityValue());
            data.setType(0);
        } else if (type == 1) {
            this.publicLabel.setVisible(false);
            this.publicField.setVisible(false);
            this.valueLabel.setText(EntityDeclPanel.getMessage("LAB_REF_URL"));
            this.openButton.setVisible(true);
            this.searchButton.setVisible(true);
            this.valueField.setText(data.getSystemId());
            data.setType(1);
        } else {
            this.publicLabel.setVisible(true);
            this.publicField.setVisible(true);
            this.valueLabel.setText(EntityDeclPanel.getMessage("LAB_REF_URL"));
            this.openButton.setVisible(true);
            this.searchButton.setVisible(true);
            this.valueField.setText(data.getSystemId());
            data.setType(2);
        }
        this.valuePanel.revalidate();
        this.viewResult();
    }

    void peChanged() {
        boolean b = this.peField.isSelected();
        this.notationLabel.setVisible(!b);
        this.notationField.setVisible(!b);
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        data.setPeDecl(b);
        if (!b) {
            Vector vet = this.parentPanel.getAllNotationsBefore(this.node);
            vet.insertElementAt(NON, 0);
            this.notationField.setEnabledEvent(false);
            this.notationField.setList(vet);
            String notation = data.getNotationName();
            if (notation != null && notation.equals("")) {
                notation = null;
            }
            if (notation == null) {
                this.notationField.setSelectedIndex(0);
            } else {
                this.notationField.setText(notation);
            }
            this.notationField.setEnabledEvent(true);
        }
        this.valuePanel.revalidate();
        this.contentsChanged();
        this.viewResult();
    }

    void notationChanged(String value) {
        if (value.equals("") || value.equals(NON)) {
            value = null;
        }
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        data.setNotationName(value);
        this.contentsChanged();
        this.viewResult();
    }

    void refChanged(String value) {
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        if (data.getType() == 0) {
            data.setEntityValue(value);
        } else {
            try {
                data.setSystemId(value);
            }
            catch (Exception e) {
                String s = EntityDeclPanel.getMessage("INVALID_URL", value) + "\n" + e.getMessage();
                JOptionPane.showMessageDialog(this.parentPanel, s);
                return;
            }
        }
        this.contentsChanged();
        this.viewResult();
    }

    void publicChanged(String value) {
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        if (!this.isPublicId(value)) {
            JOptionPane.showMessageDialog(this.parentPanel, EntityDeclPanel.getMessage("INVALID_PUBLICID"));
            return;
        }
        data.setPublicId(value);
        this.contentsChanged();
        this.viewResult();
    }

    void viewResult() {
        String rs;
        int k;
        EntityDecl declnode = DTDEditorPanel.createEntityDecl(null, this.node);
        if (declnode == null) {
            this.result.setText("");
        }
        if ((k = (rs = declnode.toString()).indexOf("% ")) >= 0) {
            String s = rs.substring(0, k + 2);
            String s1 = rs.substring(k + 2);
            if ((k = s1.indexOf("%")) >= 0) {
                s1 = this.parentPanel.repleaceEntity(s1);
                rs = rs + "\n------------------\n" + s + s1;
            }
        }
        this.result.setText(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        EntityDeclNodeData data = (EntityDeclNodeData)node.getUserObject();
        this.node = node;
        this.nameField.setText(data.getNodeName());
        this.peField.setSelected(data.getPeDecl());
        this.publicField.setText(data.getPublicId());
        this.peChanged();
        int type = data.getType();
        if (type == 0) {
            this.typeOption[0].setSelected(true);
        } else if (type == 1) {
            this.typeOption[1].setSelected(true);
        } else {
            this.typeOption[2].setSelected(true);
        }
        this.typeOption[type].setSelected(true);
        this.typeChanged(type);
        this.viewResult();
    }

    boolean isPublicId(String s) {
        if (s.length() < 7) {
            return false;
        }
        if (s.charAt(0) != '+' && s.charAt(0) != '-') {
            return false;
        }
        if (s.charAt(1) != '/' || s.charAt(2) != '/') {
            return false;
        }
        int k = s.indexOf("//", 3);
        if (k < 0) {
            return false;
        }
        return (k = s.indexOf("//", k + 2)) > 0;
    }

    void findFileName() {
        String s = this.valueField.getText();
        s = s == null ? "" : s.trim();
        DTDEditorFrame f = (DTDEditorFrame)SwingUtilities.getRoot(this);
        String newfile = f.searchFileName(s);
        if (newfile != null) {
            this.valueField.setText(newfile);
            this.refChanged(newfile);
        }
    }

    void openEditor() {
        String s = this.valueField.getText();
        if (s == null) {
            return;
        }
        DTDEditorFrame f = (DTDEditorFrame)SwingUtilities.getRoot(this);
        Point point = f.getLocation();
        String text = f.getAbsoluteFileName(s);
        URL url = null;
        try {
            if (text.indexOf(":/") > 0) {
                url = new URL(text);
            } else {
                File file = new File(text);
                url = file.toURL();
            }
            NewDTDEditorFrame frame = new NewDTDEditorFrame();
            frame.setLocation(point.x + 40, point.y + 40);
            frame.show();
            frame.loadDTD(url.toString(), false);
            frame.statusChanged();
            return;
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(f, EntityDeclPanel.getMessage("INVALID_URL", text) + "\n" + e1.getMessage());
            return;
        }
    }

    void SystemIdRefrash() {
        EntityDeclNodeData data = (EntityDeclNodeData)this.node.getUserObject();
        data.setSystemId(data.getSystemId());
    }

    class NewDTDEditorFrame
    extends DTDEditorFrame {
        NewDTDEditorFrame() {
            super(true);
            this.start();
        }

        @Override
        public boolean closedWindow() {
            this.dispose();
            return false;
        }

        @Override
        public boolean saveFile() {
            boolean b = super.saveFile();
            if (b) {
                EntityDeclPanel.this.SystemIdRefrash();
            }
            return b;
        }
    }
}

