/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vdtd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefault;
import com.argo21.jxp.vdtd.AttDefDeclNodeData;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.NSDeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

class NSDeclPanel
extends ContentsEditPanel {
    TextFieldEx elemField;
    TextFieldEx prefixField;
    TextFieldEx namespaceField;
    ResultPanel result;

    NSDeclPanel() {
    }

    @Override
    public void init(DTDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        JPanel tp = new JPanel();
        this.add((Component)tp, gc);
        ++gc.gridy;
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(NSDeclPanel.getMessage("TL_NAMESPACE")));
        JLabel label = new JLabel(NSDeclPanel.getMessage("LAB_TAG_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.elemField = new TextFieldEx();
        this.elemField.setEditable(false);
        tp.add((Component)this.elemField, c);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        label = new JLabel(NSDeclPanel.getMessage("LAB_PREFIX"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.prefixField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    NSDeclPanel.this.prefixChanged(value.trim());
                }
                return true;
            }
        };
        tp.add((Component)this.prefixField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(NSDeclPanel.getMessage("LAB_NAMESPACE"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.namespaceField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                if (value != null) {
                    NSDeclPanel.this.namespaceChanged(value.trim());
                }
                return true;
            }
        };
        tp.add((Component)this.namespaceField, c);
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new ResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void prefixChanged(String value) {
        AttDefDeclNodeData data = (AttDefDeclNodeData)this.node.getUserObject();
        String s = "";
        String nodename = data.getNodeName();
        int k = nodename.indexOf(58);
        if (k >= 0) {
            s = nodename.substring(k + 1);
        }
        if (!s.equals(value)) {
            if (value.length() != 0 && !XmlNames.isUnqualifiedName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, NSDeclPanel.getMessage("INVALID_NAME", value));
                this.prefixField.setText(s);
                return;
            }
            if (value.length() != 0) {
                this.nameChangedTo("xmlns:" + value);
            } else {
                this.nameChangedTo("xmlns");
            }
            if (s.length() > 0) {
                if (value.length() != 0) {
                    this.parentPanel.nameSpaceChanged(s + ":", value + ":");
                } else {
                    this.parentPanel.nameSpaceChanged(s + ":", "");
                }
            }
            this.elemField.setText(data.getElementName());
            this.viewResult();
        }
    }

    void namespaceChanged(String value) {
        AttDefDeclNodeData data = (AttDefDeclNodeData)this.node.getUserObject();
        AttDefault def = data.getAttDefault();
        data.setAttDefault(1, value);
        this.nodeChanged();
        this.viewResult();
    }

    void viewResult() {
        AttDef attdef1 = DTDEditorPanel.createAttdef(null, this.node);
        String rs = attdef1 == null ? "" : attdef1.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof NSDeclNodeData) {
            NSDeclNodeData attdef = (NSDeclNodeData)data;
            String elename = attdef.getElementName();
            this.elemField.setText(elename);
            String s = attdef.getNodeName();
            if (s.equals("xmlns")) {
                this.prefixField.setText("");
            } else if (s.startsWith("xmlns:")) {
                this.prefixField.setText(s.substring(6));
            }
            AttDefault attvalue = attdef.getAttDefault();
            s = attvalue.getValue();
            if (s != null) {
                this.namespaceField.setText(s);
            } else {
                this.namespaceField.setText("http://namespace");
            }
            this.viewResult();
        }
    }
}

