/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.jxp.vxsd.AnyAttributeNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.AnyAttribute;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

class AnyAttributePanel
extends XsdContentsEditPanel {
    protected ComboTextFieldEx namespaceCombo;
    protected ComboTextFieldEx processContentsCombo;
    private XSDResultPanel result;
    protected static final String[] nsValues = new String[]{"##any", "##other", "##targetNamespace", "##local", AnyAttributePanel.getMessage("LAB_NONE")};
    protected static final String[] pcValues = new String[]{"strict", "lax", "skip", AnyAttributePanel.getMessage("LAB_NONE")};

    AnyAttributePanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            // empty if block
        }
        this.add((Component)this.getAnyPanel(), gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    protected JPanel getAnyPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setOpaque(true);
        panel.setBorder(BorderFactory.createTitledBorder(AnyAttributePanel.getMessage("TL_ANY_ATTRIBUTE")));
        this.namespaceCombo = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    AnyAttributePanel.this.namespaceChanged(value.trim());
                }
                return true;
            }
        };
        this.addComonentToPanel(panel, c, "LAB_NAMESPACE", this.namespaceCombo);
        this.processContentsCombo = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    AnyAttributePanel.this.processContentsChanged(value.trim());
                }
                return true;
            }
        };
        this.addComonentToPanel(panel, c, "LAB_PROCESS_CONTENTS", this.processContentsCombo);
        return panel;
    }

    private void addComonentToPanel(JPanel panel, GridBagConstraints c, String labelId, ComboTextFieldEx combo) {
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        panel.add((Component)new JLabel(AnyAttributePanel.getMessage(labelId)), c);
        ++c.gridx;
        c.weightx = 2.0;
        c.gridwidth = 0;
        panel.add((Component)combo, c);
    }

    void namespaceChanged(String value) {
        AnyAttributeNodeData data = (AnyAttributeNodeData)this.node.getUserObject();
        data.setNamespace(this.getSelectedValue(this.namespaceCombo, data));
        this.revalidate();
        this.nodeChanged();
        this.viewResult();
    }

    void processContentsChanged(String value) {
        AnyAttributeNodeData data = (AnyAttributeNodeData)this.node.getUserObject();
        data.setProcessContents(this.getSelectedValue(this.processContentsCombo, data));
        this.revalidate();
        this.nodeChanged();
        this.viewResult();
    }

    private String getSelectedValue(ComboTextFieldEx combo, AnyAttributeNodeData data) {
        String selected = combo.getText();
        if (selected.equals(AnyAttributePanel.getMessage("LAB_NONE"))) {
            selected = null;
        }
        return selected;
    }

    void viewResult() {
        AnyAttribute deriDecl = XSDEditorPanel.createAnyAttribute(null, this.node);
        String rs = deriDecl == null ? "" : deriDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof AnyAttributeNodeData) {
            this.setDataToAnyCombos((AnyAttributeNodeData)data);
            this.viewResult();
        }
    }

    protected void setDataToAnyCombos(AnyAttributeNodeData data) {
        this.initCombo(this.namespaceCombo, nsValues);
        this.initCombo(this.processContentsCombo, pcValues);
        this.namespaceCombo.setEnabledEvent(false);
        this.processContentsCombo.setEnabledEvent(false);
        if (data != null) {
            this.namespaceCombo.setText(this.getDispValue(data.getNamespace()));
            this.processContentsCombo.setText(this.getDispValue(data.getProcessContents()));
        }
        this.namespaceCombo.setEnabledEvent(true);
        this.processContentsCombo.setEnabledEvent(true);
    }

    protected void initCombo(ComboTextFieldEx combo, String[] values) {
        this.revalidate();
        combo.setEnabledEvent(false);
        combo.setList(values);
        combo.setEnabledEvent(true);
    }

    protected String getDispValue(String val) {
        if (val == null || val.equals("")) {
            val = AnyAttributePanel.getMessage("LAB_NONE");
        }
        return val;
    }
}

