/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.vxsd.AttributeGroupNodeData;
import com.argo21.jxp.vxsd.SchemaDeclNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.AttributeGroup;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class AttributeGroupPanel
extends XsdContentsEditPanel {
    private static String[] GROUPINFO_NAME = new String[]{AttributeGroupPanel.getMessage("LAB_ELEM_GLOBALGROUP"), AttributeGroupPanel.getMessage("LAB_ELEM_REF_GROUP")};
    private static String[] GROUP_TYPE_NAME = new String[]{""};
    private JRadioButton[] GlobalGroupBtn = new JRadioButton[2];
    private ComboTextFieldEx ggText;
    private XSDResultPanel result;

    AttributeGroupPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel GroupInfoPanel = new JPanel();
        GroupInfoPanel.setLayout(new GridBagLayout());
        GroupInfoPanel.setOpaque(true);
        GroupInfoPanel.setBorder(BorderFactory.createTitledBorder(AttributeGroupPanel.getMessage("TL_ELEM_GROUPINFO")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        GroupInfoPanel.add((Component)new JLabel(AttributeGroupPanel.getMessage("LAB_ATTRGRP")), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridwidth = 0;
        ButtonGroup rbg0 = new ButtonGroup();
        this.GlobalGroupBtn[0] = new JRadioButton(GROUPINFO_NAME[0]);
        GroupInfoPanel.add((Component)this.GlobalGroupBtn[0], c);
        ++c.gridy;
        this.GlobalGroupBtn[1] = new JRadioButton(GROUPINFO_NAME[1]);
        GroupInfoPanel.add((Component)this.GlobalGroupBtn[1], c);
        for (int i = 0; i < 2; ++i) {
            this.GlobalGroupBtn[i].setFont(this.getDefaultFont());
            rbg0.add(this.GlobalGroupBtn[i]);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        GroupInfoPanel.add((Component)new JLabel(AttributeGroupPanel.getMessage("LAB_NAME")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel cmbboxp = new JPanel();
        cmbboxp.setLayout(new GridLayout(1, 2));
        this.ggText = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    AttributeGroupPanel.this.ggTextChanged(value.trim());
                }
                return true;
            }
        };
        this.ggText.setEnabledEvent(false);
        this.ggText.setList(GROUP_TYPE_NAME);
        this.ggText.setEnabledEvent(true);
        cmbboxp.add((Component)this.ggText, c);
        GroupInfoPanel.add((Component)cmbboxp, c);
        this.add((Component)GroupInfoPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void viewResult() {
        AttributeGroup declnode = XSDEditorPanel.createAttributeGroup(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    void ggTextChanged(String value) {
        AttributeGroupNodeData data = (AttributeGroupNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (this.GlobalGroupBtn[1].isSelected()) {
            XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
            XsdTypeRef grpref = null;
            grpref = xsd.findTypeReference(this.ggText.getText(), 57, 1, true);
            if (grpref == null || !grpref.isTypeNode()) {
                JOptionPane.showMessageDialog(this.parentPanel, AttributeGroupPanel.getMessage("INVALID_REF", this.ggText.getText()));
                s = ((XSDDocument)this.parentPanel.xsd).getTyperefNameAdditionPrefix(data.getNameSpapceRefNode(), data.getNameRefNode());
                this.ggText.setText(s);
                return;
            }
            data.setRef(grpref);
            this.nameChangedTo(XSDDocument.getValueOnly(value));
            this.updateXsd();
            this.viewResult();
        } else if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, AttributeGroupPanel.getMessage("INVALID_NAME", value));
                this.ggText.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelectSameParent(57, value)) {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), AttributeGroupPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                this.ggText.setText(s);
                return;
            }
            this.nameChangedTo(XSDDocument.getValueOnly(value));
            this.updateXsd();
            this.viewResult();
        }
    }

    void reviewGroupPanel() {
        boolean showAttr = true;
        this.revalidate();
        Vector vet = new Vector();
        ((XSDDocument)this.parentPanel.xsd).getExternalGlobalAttributeGroup(vet);
        this.ggText.setEnabledEvent(false);
        this.ggText.setList(vet);
        AttributeGroupNodeData data = (AttributeGroupNodeData)this.node.getUserObject();
        String name2 = data.getRef() == null ? data.getNodeName() : (!data.getRef().isTypeNode() ? data.getNodeName() : ((XSDDocument)this.parentPanel.xsd).getTyperefNameAdditionPrefix(data.getNameSpapceRefNode(), data.getNameRefNode()));
        this.ggText.setText(name2);
        this.ggText.setEnabledEvent(true);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof AttributeGroupNodeData) {
            AttributeGroupNodeData agdata = (AttributeGroupNodeData)data;
            DefaultMutableTreeNode node1 = null;
            try {
                node1 = (DefaultMutableTreeNode)node.getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node1 != null) {
                Object data1 = node1.getUserObject();
                if (!(data1 instanceof SchemaDeclNodeData)) {
                    this.GlobalGroupBtn[0].setEnabled(false);
                    this.GlobalGroupBtn[1].setEnabled(false);
                    this.GlobalGroupBtn[1].setSelected(true);
                } else {
                    this.GlobalGroupBtn[0].setEnabled(false);
                    this.GlobalGroupBtn[1].setEnabled(false);
                    this.GlobalGroupBtn[0].setSelected(true);
                }
            }
        }
        this.ggText.setEnabled(true);
        this.reviewGroupPanel();
        if (this.parentPanel.checkAlreadyUseDecl(node)) {
            this.ggText.setEnabled(false);
        }
        this.viewResult();
    }
}

