/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.vxsd.ComplexTypeNodeData;
import com.argo21.jxp.vxsd.ContentModelNodeData;
import com.argo21.jxp.vxsd.DerivationNodeData;
import com.argo21.jxp.vxsd.MgsDeclNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdElementDeclNodeData;
import com.argo21.jxp.xsd.ComplexType;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class ComplexTypePanel
extends XsdContentsEditPanel {
    private static String[] ELE_TYPE_NAMES = new String[]{ComplexTypePanel.getMessage("LAB_ELE_GLOBAL"), ComplexTypePanel.getMessage("LAB_ELE_LOCAL"), ComplexTypePanel.getMessage("LAB_ELE_REF")};
    private JPanel namePanel;
    private JLabel nameLabel;
    private JLabel eleLabel;
    private JRadioButton[] eleOption = new JRadioButton[3];
    private ComboTextFieldEx complexField;
    private JRadioButton[] modelOption = new JRadioButton[2];
    private JPanel valuePanel;
    private JRadioButton[] abstractOption = new JRadioButton[2];
    private JRadioButton[] mixOption = new JRadioButton[2];
    private ComboTextFieldEx finalField;
    private ComboTextFieldEx blockField;
    private JPanel derivationPanel;
    private JLabel derivationLabel1;
    private JLabel derivationLabel2;
    private JRadioButton[] derivationOption1 = new JRadioButton[3];
    private JRadioButton[] derivationOption2 = new JRadioButton[2];
    private XSDResultPanel result;

    ComplexTypePanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            // empty if block
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new GridBagLayout());
        this.namePanel.setOpaque(true);
        this.namePanel.setBorder(BorderFactory.createTitledBorder(ComplexTypePanel.getMessage("TL_COMPLEX")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.eleLabel = new JLabel(ComplexTypePanel.getMessage("LAB_COMPLEXTYPE"));
        this.namePanel.add((Component)this.eleLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridwidth = 0;
        ButtonGroup modelGroup = new ButtonGroup();
        this.modelOption[0] = new JRadioButton(ComplexTypePanel.getMessage("LAB_COMPLEX"));
        this.namePanel.add((Component)this.modelOption[0], c);
        ++c.gridy;
        this.modelOption[1] = new JRadioButton(ComplexTypePanel.getMessage("LAB_COMPLEX_DERI"));
        this.namePanel.add((Component)this.modelOption[1], c);
        ActionListener a2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexTypePanel.this.modelChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.modelOption[i].addActionListener(a2);
            modelGroup.add(this.modelOption[i]);
            this.modelOption[i].setFont(defaultFont);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.nameLabel = new JLabel(ComplexTypePanel.getMessage("LAB_NAME"));
        this.namePanel.add((Component)this.nameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel rd = new JPanel();
        rd.setLayout(new GridLayout(1, 2));
        this.complexField = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    ComplexTypePanel.this.complexNameChanged(value.trim());
                }
                return true;
            }
        };
        rd.add((Component)this.complexField, c);
        this.namePanel.add((Component)rd, c);
        this.add((Component)this.namePanel, gc);
        ++gc.gridy;
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        this.valuePanel.setBorder(BorderFactory.createTitledBorder(ComplexTypePanel.getMessage("TL_OTHER_ATTR")));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.valuePanel.add((Component)new JLabel(ComplexTypePanel.getMessage("LAB_ABSTRACT")), c);
        ++c.gridx;
        c.weightx = 1.0;
        ButtonGroup abstractGroup = new ButtonGroup();
        this.abstractOption[0] = new JRadioButton("true");
        this.valuePanel.add((Component)this.abstractOption[0], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.abstractOption[1] = new JRadioButton("false");
        this.valuePanel.add((Component)this.abstractOption[1], c);
        ActionListener a6 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexTypePanel.this.abstractChanged(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.abstractOption[i].addActionListener(a6);
            abstractGroup.add(this.abstractOption[i]);
            this.abstractOption[i].setFont(defaultFont);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.valuePanel.add((Component)new JLabel(ComplexTypePanel.getMessage("LAB_MIXED")), c);
        ++c.gridx;
        c.weightx = 1.0;
        ButtonGroup mixGroup = new ButtonGroup();
        this.mixOption[0] = new JRadioButton("true");
        this.valuePanel.add((Component)this.mixOption[0], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.mixOption[1] = new JRadioButton("false");
        this.valuePanel.add((Component)this.mixOption[1], c);
        ActionListener a8 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexTypePanel.this.mixedChanged(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.mixOption[i].addActionListener(a8);
            mixGroup.add(this.mixOption[i]);
            this.mixOption[i].setFont(defaultFont);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.valuePanel.add((Component)new JLabel(ComplexTypePanel.getMessage("LAB_FINAL")), c);
        ++c.gridx;
        c.gridwidth = 0;
        String[] finals = new String[]{"#all", "extension", "restriction", "\u6307\u5b9a\u306a\u3057"};
        this.finalField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                ComplexTypePanel.this.finalChanged(value.trim());
                return true;
            }
        };
        this.finalField.setEnabledEvent(false);
        this.finalField.setList(finals);
        this.finalField.setEnabledEvent(true);
        this.valuePanel.add((Component)this.finalField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.valuePanel.add((Component)new JLabel(ComplexTypePanel.getMessage("LAB_BLOCK")), c);
        ++c.gridx;
        c.gridwidth = 0;
        String[] blocks = new String[]{"#all", "extension", "restriction", "substitution", "\u6307\u5b9a\u306a\u3057"};
        this.blockField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                ComplexTypePanel.this.blockChanged(value.trim());
                return true;
            }
        };
        this.blockField.setEnabledEvent(false);
        this.blockField.setList(blocks);
        this.blockField.setEnabledEvent(true);
        this.valuePanel.add((Component)this.blockField, c);
        this.add((Component)this.valuePanel, gc);
        ++gc.gridy;
        this.derivationPanel = new JPanel();
        this.derivationPanel.setLayout(new GridBagLayout());
        this.derivationPanel.setBorder(BorderFactory.createTitledBorder(ComplexTypePanel.getMessage("DECL_COMPLEX") + ComplexTypePanel.getMessage("LAB_DERIVATION")));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.derivationLabel1 = new JLabel(ComplexTypePanel.getMessage("LAB_DERIVATION"));
        this.derivationPanel.add((Component)this.derivationLabel1, c);
        ButtonGroup derivationGroup1 = new ButtonGroup();
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption1[0] = new JRadioButton("complexContent");
        this.derivationPanel.add((Component)this.derivationOption1[0], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption1[1] = new JRadioButton("simpleContent");
        this.derivationPanel.add((Component)this.derivationOption1[1], c);
        ActionListener a10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexTypePanel.this.derivationChanged1(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.derivationOption1[i].addActionListener(a10);
            derivationGroup1.add(this.derivationOption1[i]);
            this.derivationOption1[i].setFont(defaultFont);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.derivationLabel2 = new JLabel(ComplexTypePanel.getMessage("LAB_REST_EXTN"));
        this.derivationPanel.add((Component)this.derivationLabel2, c);
        ButtonGroup derivationGroup2 = new ButtonGroup();
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption2[0] = new JRadioButton("restriction");
        this.derivationPanel.add((Component)this.derivationOption2[0], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption2[1] = new JRadioButton("extension");
        this.derivationPanel.add((Component)this.derivationOption2[1], c);
        ActionListener a11 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComplexTypePanel.this.derivationChanged2(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.derivationOption2[i].addActionListener(a11);
            derivationGroup2.add(this.derivationOption2[i]);
            this.derivationOption2[i].setFont(defaultFont);
        }
        this.add((Component)this.derivationPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    private void reviewNamePanel(boolean mustdo) {
        boolean showAttr = true;
        this.namePanel.revalidate();
        this.valuePanel.setVisible(showAttr);
        this.revalidate();
        Vector vet = new Vector();
        ((XSDDocument)this.parentPanel.xsd).getExternalGlobalComplexType(vet);
        this.complexField.setEnabledEvent(false);
        this.complexField.setList(vet);
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        if (data != null) {
            String name2 = data.getNodeName();
            this.complexField.setText(name2);
        }
        this.complexField.setEnabledEvent(true);
    }

    void modelChanged(JRadioButton modelOpt) {
        if (!modelOpt.isSelected()) {
            return;
        }
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        Object complexTreeNode = null;
        DefaultMutableTreeNode mgsTreeNode = null;
        DefaultMutableTreeNode eleTreeNode = null;
        DefaultMutableTreeNode modelTreeNode = null;
        DefaultMutableTreeNode deriTreeNode = null;
        Object complexNode = null;
        MgsDeclNodeData mgsNode = null;
        XsdElementDeclNodeData eleNode = null;
        ContentModelNodeData modelNode = null;
        DerivationNodeData deriNode = null;
        boolean type = false;
        if (modelOpt == this.modelOption[0]) {
            this.setEnabledDerivation(false);
            this.removeChildNode(this.node);
            mgsNode = new MgsDeclNodeData("sequence");
            mgsTreeNode = new DefaultMutableTreeNode(mgsNode);
            if (mgsTreeNode != null) {
                this.node.add(mgsTreeNode);
                eleNode = new XsdElementDeclNodeData(this.parentPanel.getNewDefaultNodeName(50));
                String defaultTypeName = ((XSDDocument)this.parentPanel.xsd).getSchemaPrefix(true) + "string";
                XsdTypeRef deftype = ((XSDDocument)this.parentPanel.xsd).findTypeReference(defaultTypeName, 50, 0, true);
                if (deftype != null) {
                    eleNode.setTypeAttr(deftype);
                }
                if ((eleTreeNode = new DefaultMutableTreeNode(eleNode)) != null) {
                    mgsTreeNode.add(eleTreeNode);
                }
            }
        } else if (modelOpt == this.modelOption[1]) {
            this.setEnabledDerivation(true);
            this.removeChildNode(this.node);
            modelNode = new ContentModelNodeData(0, "complexContent");
            modelTreeNode = new DefaultMutableTreeNode(modelNode);
            if (modelTreeNode != null) {
                this.node.add(modelTreeNode);
                deriNode = new DerivationNodeData(0, "restriction");
                deriTreeNode = new DefaultMutableTreeNode(deriNode);
                if (deriTreeNode != null) {
                    modelTreeNode.add(deriTreeNode);
                }
            }
            this.derivationOption2[0].setSelected(true);
            this.derivationOption1[0].setSelected(true);
        }
        this.setEnabled();
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.reviewNamePanel(false);
        this.viewResult();
        this.parentPanel.resetEditStatus();
    }

    void complexNameChanged(String value) {
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (value == null || value.equals("")) {
            JOptionPane.showMessageDialog(this.parentPanel, ComplexTypePanel.getMessage("REQUIRED", value));
            this.complexField.setText(s);
        }
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, ComplexTypePanel.getMessage("INVALID_NAME", value));
                this.complexField.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelectSameParent(52, value)) {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), ComplexTypePanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                this.complexField.setText(s);
                return;
            }
            this.nameChangedTo(XSDDocument.getValueOnly(value));
            this.updateXsd();
            this.viewResult();
        }
    }

    void removeChildNode(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        DefaultMutableTreeNode node1 = null;
        for (int i = 0; i < n; ++i) {
            try {
                node1 = (DefaultMutableTreeNode)node.getFirstChild();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = this.parentPanel.removeDeclNode(node1, false);
        }
    }

    void derivationChanged1(ActionEvent e) {
        JRadioButton derivationOpt = (JRadioButton)e.getSource();
        if (!derivationOpt.isSelected()) {
            return;
        }
        DefaultMutableTreeNode contentModelNode = null;
        DefaultMutableTreeNode deriTreeNode = null;
        ContentModelNodeData contentModel = null;
        DerivationNodeData derivationNode = null;
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        if (derivationOpt == this.derivationOption1[0]) {
            this.removeChildNode(this.node);
            contentModel = new ContentModelNodeData(0, "complexContent");
            contentModelNode = new DefaultMutableTreeNode(contentModel);
            if (contentModelNode != null) {
                this.node.add(contentModelNode);
            }
        } else if (derivationOpt == this.derivationOption1[1]) {
            this.removeChildNode(this.node);
            contentModel = new ContentModelNodeData(1, "simpleContent");
            contentModelNode = new DefaultMutableTreeNode(contentModel);
            if (contentModelNode != null) {
                this.node.add(contentModelNode);
            }
        }
        if ((derivationOpt == this.derivationOption1[0] || derivationOpt == this.derivationOption1[1]) && contentModelNode != null) {
            if (this.derivationOption2[0].isSelected()) {
                derivationNode = new DerivationNodeData(0, "restriction");
                deriTreeNode = new DefaultMutableTreeNode(derivationNode);
                if (deriTreeNode != null) {
                    contentModelNode.add(deriTreeNode);
                }
            } else if (this.derivationOption2[1].isSelected() && (deriTreeNode = new DefaultMutableTreeNode(derivationNode = new DerivationNodeData(1, "extension"))) != null) {
                contentModelNode.add(deriTreeNode);
            }
        }
        this.setEnabled();
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.reviewNamePanel(true);
        this.viewResult();
    }

    void derivationChanged2(ActionEvent e) {
        Object data1;
        JRadioButton derivationOpt = (JRadioButton)e.getSource();
        if (!derivationOpt.isSelected()) {
            return;
        }
        Object complexModelNode = null;
        DefaultMutableTreeNode contentModelNode = null;
        DefaultMutableTreeNode deriTreeNode = null;
        Object contenModel = null;
        DerivationNodeData derivationNode = null;
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        try {
            contentModelNode = this.getValidFirstChild(this.node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (contentModelNode != null && (data1 = contentModelNode.getUserObject()) instanceof ContentModelNodeData) {
            if (derivationOpt == this.derivationOption2[0]) {
                this.removeChildNode(contentModelNode);
                derivationNode = new DerivationNodeData(0, "restriction");
                deriTreeNode = new DefaultMutableTreeNode(derivationNode);
                if (deriTreeNode != null) {
                    contentModelNode.add(deriTreeNode);
                }
            } else if (derivationOpt == this.derivationOption2[1]) {
                this.removeChildNode(contentModelNode);
                derivationNode = new DerivationNodeData(1, "extension");
                deriTreeNode = new DefaultMutableTreeNode(derivationNode);
                if (deriTreeNode != null) {
                    contentModelNode.add(deriTreeNode);
                }
            }
        }
        this.setEnabled();
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.reviewNamePanel(true);
        this.viewResult();
    }

    void abstractChanged(ActionEvent e) {
        JRadioButton abstractOpt = (JRadioButton)e.getSource();
        if (abstractOpt.isSelected()) {
            ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
            if (abstractOpt == this.abstractOption[0]) {
                data.setAbstract("true");
            } else if (abstractOpt == this.abstractOption[1]) {
                data.setAbstract("false");
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void mixedChanged(ActionEvent e) {
        JRadioButton mixOpt = (JRadioButton)e.getSource();
        if (mixOpt.isSelected()) {
            ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
            if (mixOpt == this.mixOption[0]) {
                data.setMixed("true");
            } else if (mixOpt == this.mixOption[1]) {
                data.setMixed("false");
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void finalChanged(String value) {
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        if (data != null) {
            if (value.equals("#all") || value.equals("extension") || value.equals("restriction")) {
                data.setFinal(value);
            } else {
                data.setFinal(null);
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void blockChanged(String value) {
        ComplexTypeNodeData data = (ComplexTypeNodeData)this.node.getUserObject();
        if (data != null) {
            if (value.equals("#all") || value.equals("extension") || value.equals("restriction") || value.equals("substitution")) {
                data.setBlock(value);
            } else {
                data.setBlock(null);
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void viewResult() {
        ComplexType complexDecl = XSDEditorPanel.createComplexType(null, this.node);
        String rs = complexDecl == null ? "" : complexDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof ComplexTypeNodeData) {
            String sAbstract;
            this.complexField.setEnabledEvent(false);
            ComplexTypeNodeData cm = (ComplexTypeNodeData)data;
            if (node.getParent().toString() == "schema") {
                this.complexField.setEnabled(true);
            } else {
                this.complexField.setEnabled(false);
            }
            DefaultMutableTreeNode node1 = null;
            DefaultMutableTreeNode node2 = null;
            this.modelOption[0].setSelected(true);
            try {
                node1 = this.getValidFirstChild(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node1 != null) {
                Object data1 = node1.getUserObject();
                if (data1 instanceof MgsDeclNodeData) {
                    this.modelOption[0].setSelected(true);
                } else if (data1 instanceof ContentModelNodeData) {
                    this.modelOption[1].setSelected(true);
                    ContentModelNodeData cmnode = (ContentModelNodeData)data1;
                    if (cmnode.getType() == 0) {
                        this.derivationOption1[0].setSelected(true);
                    } else if (cmnode.getType() == 1) {
                        this.derivationOption1[1].setSelected(true);
                    }
                    try {
                        node2 = this.getValidFirstChild(node1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (node2 != null && (data1 = node2.getUserObject()) instanceof DerivationNodeData) {
                        DerivationNodeData derinode = (DerivationNodeData)data1;
                        if (derinode.getType() == 0) {
                            this.derivationOption2[0].setSelected(true);
                        } else if (derinode.getType() == 1) {
                            this.derivationOption2[1].setSelected(true);
                        }
                    }
                }
            }
            String sFinal = cm.getFinal();
            this.finalField.setSelectedIndex(3);
            if (sFinal != null) {
                if (sFinal.equals("#all")) {
                    this.finalField.setSelectedIndex(0);
                } else if (sFinal.equals("extension")) {
                    this.finalField.setSelectedIndex(1);
                } else if (sFinal.equals("restriction")) {
                    this.finalField.setSelectedIndex(2);
                }
            }
            String block = cm.getBlock();
            this.blockField.setSelectedIndex(4);
            if (block != null) {
                if (block.equals("#all")) {
                    this.blockField.setSelectedIndex(0);
                } else if (block.equals("extension")) {
                    this.blockField.setSelectedIndex(1);
                } else if (block.equals("restriction")) {
                    this.blockField.setSelectedIndex(2);
                } else if (block.equals("substitution")) {
                    this.blockField.setSelectedIndex(3);
                }
            }
            if ((sAbstract = cm.getAbstract()) != null && sAbstract.equals("true")) {
                this.abstractOption[0].setSelected(true);
            } else {
                this.abstractOption[1].setSelected(true);
            }
            String mix = cm.getMixed();
            if (mix != null && mix.equals("true")) {
                this.mixOption[0].setSelected(true);
            } else {
                this.mixOption[1].setSelected(true);
            }
            this.setEnabled();
            this.reviewNamePanel(true);
            if (this.parentPanel.checkAlreadyUseDecl(node)) {
                this.complexField.setEnabled(false);
                this.modelOption[0].setEnabled(false);
                this.modelOption[1].setEnabled(false);
                this.setEnabledDerivation(false);
            }
            this.complexField.setEnabledEvent(true);
            this.viewResult();
        }
    }

    void setEnabledModel(boolean enabled) {
        this.modelOption[0].setEnabled(enabled);
        this.modelOption[1].setEnabled(enabled);
    }

    void setEnabledDerivation(boolean enabled) {
        this.derivationOption1[0].setEnabled(enabled);
        this.derivationOption1[1].setEnabled(enabled);
        this.derivationOption2[0].setEnabled(enabled);
        this.derivationOption2[1].setEnabled(enabled);
    }

    void setEnabledAbstract(boolean enabled) {
        this.abstractOption[0].setEnabled(enabled);
        this.abstractOption[1].setEnabled(enabled);
    }

    void setEnabledMixed(boolean enabled) {
        this.mixOption[0].setEnabled(enabled);
        this.mixOption[1].setEnabled(enabled);
    }

    void setEnabledFinalBlock(boolean enabled) {
        this.finalField.setEnabled(enabled);
        this.blockField.setEnabled(enabled);
    }

    void setEnabled() {
        if (this.modelOption[1].isSelected()) {
            this.setEnabledDerivation(true);
        } else {
            this.setEnabledDerivation(false);
        }
        if (this.complexField.isEnabled()) {
            this.setEnabledModel(true);
            this.setEnabledAbstract(true);
            this.setEnabledMixed(true);
            this.setEnabledFinalBlock(true);
        } else {
            this.setEnabledModel(true);
            this.setEnabledAbstract(false);
            this.setEnabledMixed(true);
            this.setEnabledFinalBlock(false);
        }
    }
}

