/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.jxp.vxsd.ContentModelNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.ContentModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class ContentModelPanel
extends XsdContentsEditPanel {
    private static String[] MODELINFO_NAME = new String[]{ContentModelPanel.getMessage("LAB_COMPLEXCONT"), ContentModelPanel.getMessage("LAB_SIMPLECONT")};
    private JRadioButton[] ModelInfoBtn = new JRadioButton[2];
    private JRadioButton[] mixedbtn = new JRadioButton[2];
    private XSDResultPanel result;

    ContentModelPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        JPanel ModelInfoPanel = new JPanel();
        ModelInfoPanel.setLayout(new GridBagLayout());
        ModelInfoPanel.setOpaque(true);
        ModelInfoPanel.setBorder(BorderFactory.createTitledBorder(ContentModelPanel.getMessage("TL_MODELINFO")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        ButtonGroup modelinfogroup = new ButtonGroup();
        this.ModelInfoBtn[0] = new JRadioButton(MODELINFO_NAME[0]);
        ModelInfoPanel.add((Component)this.ModelInfoBtn[0], c);
        ++c.gridy;
        this.ModelInfoBtn[1] = new JRadioButton(MODELINFO_NAME[1]);
        ModelInfoPanel.add((Component)this.ModelInfoBtn[1], c);
        for (int i = 0; i < 2; ++i) {
            modelinfogroup.add(this.ModelInfoBtn[i]);
            this.ModelInfoBtn[i].setFont(defaultFont);
        }
        this.add((Component)ModelInfoPanel, gc);
        ++gc.gridy;
        JPanel ComplexElemPanel = new JPanel();
        ComplexElemPanel.setLayout(new GridBagLayout());
        ComplexElemPanel.setBorder(BorderFactory.createTitledBorder(ContentModelPanel.getMessage("TL_COMPLEXELEM")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        ComplexElemPanel.add((Component)new JLabel("mixed  :  "), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.gridwidth = 0;
        JPanel rb1 = new JPanel();
        rb1.setLayout(new GridLayout(1, 2));
        ButtonGroup mixedGroup = new ButtonGroup();
        this.mixedbtn[0] = new JRadioButton("true");
        rb1.add((Component)this.mixedbtn[0], c);
        this.mixedbtn[1] = new JRadioButton("false");
        rb1.add((Component)this.mixedbtn[1], c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentModelPanel.this.mixchanged(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.mixedbtn[i].addActionListener(al);
            mixedGroup.add(this.mixedbtn[i]);
            this.mixedbtn[i].setFont(defaultFont);
        }
        ComplexElemPanel.add((Component)rb1, c);
        this.add((Component)ComplexElemPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void mixchanged(ActionEvent e) {
        JRadioButton rb = (JRadioButton)e.getSource();
        if (rb.isSelected()) {
            ContentModelNodeData data = (ContentModelNodeData)this.node.getUserObject();
            if (rb == this.mixedbtn[0]) {
                data.setMixed("true");
            } else if (rb == this.mixedbtn[1]) {
                data.setMixed("false");
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void viewResult() {
        ContentModel cm = XSDEditorPanel.createContentModel(null, this.node);
        String rs = cm == null ? "" : cm.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof ContentModelNodeData) {
            ContentModelNodeData cmdata = (ContentModelNodeData)data;
            if (cmdata.getType() == 0) {
                this.ModelInfoBtn[0].setSelected(true);
                this.MixedbtnEnabler(true);
                if (cmdata.getMixed() == null || cmdata.getMixed().equals("false")) {
                    this.mixedbtn[1].setSelected(true);
                } else if (cmdata.getMixed().equals("true")) {
                    this.mixedbtn[0].setSelected(true);
                }
            } else if (cmdata.getType() == 1) {
                this.ModelInfoBtn[1].setSelected(true);
                this.MixedbtnEnabler(false);
            }
            this.ModelInfoBtn[0].setEnabled(false);
            this.ModelInfoBtn[1].setEnabled(false);
            this.viewResult();
        }
    }

    void MixedbtnEnabler(boolean tf) {
        this.mixedbtn[0].setEnabled(tf);
        this.mixedbtn[1].setEnabled(tf);
    }
}

