/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.jxp.vxsd.ContentModelNodeData;
import com.argo21.jxp.vxsd.DerivationNodeData;
import com.argo21.jxp.vxsd.SimpleTypeNodeData;
import com.argo21.jxp.vxsd.XDeclNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.Derivation;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class DerivationPanel
extends XsdContentsEditPanel {
    private JPanel deriPanel;
    private JRadioButton[] modeOption = new JRadioButton[2];
    private JPanel basePanel;
    private ComboTextFieldEx baseField;
    private XSDResultPanel result;

    DerivationPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            // empty if block
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.deriPanel = new JPanel();
        this.deriPanel.setLayout(new GridBagLayout());
        this.deriPanel.setOpaque(true);
        this.deriPanel.setBorder(BorderFactory.createTitledBorder(DerivationPanel.getMessage("TL_DERIVATIONINFO")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.deriPanel.add((Component)new JLabel(DerivationPanel.getMessage("LAB_DERIVATION")), c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 0;
        ButtonGroup modelGroup = new ButtonGroup();
        this.modeOption[0] = new JRadioButton(DerivationPanel.getMessage("LAB_RESTRICTION"));
        this.deriPanel.add((Component)this.modeOption[0], c);
        ++c.gridy;
        this.modeOption[1] = new JRadioButton(DerivationPanel.getMessage("LAB_EXTENSION"));
        this.deriPanel.add((Component)this.modeOption[1], c);
        ActionListener a2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DerivationPanel.this.modeChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.modeOption[i].addActionListener(a2);
            modelGroup.add(this.modeOption[i]);
            this.modeOption[i].setFont(defaultFont);
        }
        this.add((Component)this.deriPanel, gc);
        ++gc.gridy;
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridBagLayout());
        this.basePanel.setOpaque(true);
        this.basePanel.setBorder(BorderFactory.createTitledBorder(DerivationPanel.getMessage("TL_BASEDATATYPE")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.basePanel.add((Component)new JLabel(DerivationPanel.getMessage("LAB_BASETYPE")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel rd = new JPanel();
        rd.setLayout(new GridLayout(1, 2));
        this.baseField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    DerivationPanel.this.baseNameChanged(value.trim());
                }
                return true;
            }
        };
        rd.add((Component)this.baseField, c);
        this.basePanel.add((Component)rd, c);
        this.add((Component)this.basePanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void reviewNamePanel() {
        boolean showAttr = true;
        this.deriPanel.setVisible(showAttr);
        this.basePanel.setVisible(showAttr);
        this.deriPanel.revalidate();
        this.revalidate();
        Vector<String> vet = new Vector<String>();
        DefaultMutableTreeNode node1 = null;
        try {
            node1 = (DefaultMutableTreeNode)this.node.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node1 != null) {
            Object data1 = node1.getUserObject();
            if (data1 instanceof ContentModelNodeData) {
                ContentModelNodeData cmdata = (ContentModelNodeData)data1;
                if (cmdata.getType() == 0) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalComplexType(vet);
                } else if (cmdata.getType() == 1) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
                }
            } else if (data1 instanceof SimpleTypeNodeData) {
                ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
            }
        }
        vet.addElement(DerivationPanel.getMessage("LAB_NONE"));
        this.baseField.setEnabledEvent(false);
        this.baseField.setList(vet);
        DerivationNodeData data = (DerivationNodeData)this.node.getUserObject();
        if (data != null) {
            XsdTypeRef typeref = data.getBase();
            if (typeref != null) {
                if (typeref.isTypeNode()) {
                    String name2 = ((XSDDocument)this.parentPanel.xsd).getTyperefNameAdditionPrefix(typeref.getXsdDecl().getNameSpace(), typeref.getNodeString());
                    this.baseField.setText(name2);
                }
            } else {
                this.baseField.setText(DerivationPanel.getMessage("LAB_NONE"));
            }
        }
        this.baseField.setEnabledEvent(true);
    }

    void modeChanged(JRadioButton modeOpt) {
        if (!modeOpt.isSelected()) {
            return;
        }
        DerivationNodeData data = (DerivationNodeData)this.node.getUserObject();
        Object complexTreeNode = null;
        Object complexNode = null;
        boolean type = false;
        if (modeOpt == this.modeOption[0]) {
            this.removeChildNode(this.node);
            data.setType(0);
        } else if (modeOpt == this.modeOption[1]) {
            this.removeChildNode(this.node);
            data.setType(1);
        }
        this.enabledBaseField(data);
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.reviewNamePanel();
        this.viewResult();
    }

    void baseNameChanged(String value) {
        DerivationNodeData data = (DerivationNodeData)this.node.getUserObject();
        int type = this.baseField.getSelectedIndex();
        String baseString = this.baseField.getText();
        if (baseString.equals(DerivationPanel.getMessage("LAB_NONE"))) {
            data.setBase(null);
        } else {
            XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
            XsdTypeRef baseType = data.getBase();
            if (baseType != null) {
                xsd.findTypeReference(baseType, baseString, 62, 2, true);
            } else {
                baseType = xsd.findTypeReference(baseString, 62, 2, true);
            }
            data.setBase(baseType);
        }
        this.revalidate();
        this.nodeChanged();
        this.viewResult();
    }

    void removeChildNode(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        DefaultMutableTreeNode node1 = null;
        for (int i = 0; i < n; ++i) {
            try {
                node1 = (DefaultMutableTreeNode)node.getFirstChild();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = this.parentPanel.removeDeclNode(node1, false);
        }
    }

    void viewResult() {
        Derivation deriDecl = XSDEditorPanel.createDerivation(null, this.node);
        String rs = deriDecl == null ? "" : deriDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof DerivationNodeData) {
            this.baseField.setEnabledEvent(false);
            DerivationNodeData dv = (DerivationNodeData)data;
            if (dv.getType() == 0) {
                this.modeOption[0].setSelected(true);
            }
            if (dv.getType() == 1) {
                this.modeOption[1].setSelected(true);
            }
            this.reviewNamePanel();
            this.enabledBaseField(dv);
            this.enabledRadioBtn();
            this.baseField.setEnabledEvent(true);
            this.viewResult();
        }
    }

    void enabledBaseField(DerivationNodeData dv) {
        if (dv.getType() == 0 && this.parentPanel.getChildNodeInvalid(this.node, 53)) {
            this.baseField.setEnabled(false);
        }
    }

    private void enabledRadioBtn() {
        XDeclNodeData parent = (XDeclNodeData)((DefaultMutableTreeNode)this.node.getParent()).getUserObject();
        if (parent.getNodeType() == 53) {
            this.modeOption[1].setEnabled(false);
        }
    }
}

