/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.IdentityConstraintNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.IdentityConstraint;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class IdentityConstraintPanel
extends XsdContentsEditPanel {
    private static String[] IDENTITY_INFO_NAMES = new String[]{IdentityConstraintPanel.getMessage("LAB_UNIQUE"), IdentityConstraintPanel.getMessage("LAB_KEY"), IdentityConstraintPanel.getMessage("LAB_KEYREF")};
    private JPanel typePanel;
    private JRadioButton[] identityBtn = new JRadioButton[3];
    private JPanel textPanel;
    private TextFieldEx nameField;
    private TextFieldEx refkeyField;
    private XSDResultPanel result;

    IdentityConstraintPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.typePanel = new JPanel();
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setOpaque(true);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(IdentityConstraintPanel.getMessage("TL_IDENTITY")));
        c.gridx = 0;
        c.gridy = 0;
        this.typePanel.add((Component)new JLabel(IdentityConstraintPanel.getMessage("LAB_IDENTITY_KIND")), c);
        c.gridx = 1;
        c.gridy = 0;
        ButtonGroup btngroup = new ButtonGroup();
        this.setupRadioBtn(c);
        for (int i = 0; i < this.identityBtn.length; ++i) {
            this.identityBtn[i].setFont(this.getDefaultFont());
            btngroup.add(this.identityBtn[i]);
        }
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridBagLayout());
        this.textPanel.setBorder(BorderFactory.createTitledBorder(""));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.textPanel.add((Component)new JLabel(IdentityConstraintPanel.getMessage("LAB_ID_NAME")), c);
        this.nameField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                IdentityConstraintPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        ++c.gridx;
        c.weightx = 5.0;
        c.gridwidth = 0;
        this.textPanel.add((Component)this.nameField, c);
        --c.gridx;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.textPanel.add((Component)new JLabel(IdentityConstraintPanel.getMessage("LAB_KEYREF_NAME")), c);
        this.refkeyField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                IdentityConstraintPanel.this.refkeyChanged(value.trim());
                return true;
            }
        };
        ++c.gridx;
        c.weightx = 5.0;
        c.gridwidth = 0;
        this.textPanel.add((Component)this.refkeyField, c);
        this.add((Component)this.textPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    private void setupRadioBtn(GridBagConstraints c) {
        c.weightx = 1.0;
        for (int i = 0; i < this.identityBtn.length; ++i) {
            this.identityBtn[i] = new JRadioButton(IDENTITY_INFO_NAMES[i]);
            final int type = i;
            this.identityBtn[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IdentityConstraintPanel.this.identityChanged((JRadioButton)e.getSource(), type);
                }
            });
            this.typePanel.add((Component)this.identityBtn[i], c);
            ++c.gridy;
        }
    }

    void viewResult() {
        IdentityConstraint declnode = XSDEditorPanel.createIdentity(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    private void identityChanged(JRadioButton rbtn, int type) {
        if (!rbtn.isSelected()) {
            return;
        }
        IdentityConstraintNodeData data = (IdentityConstraintNodeData)this.node.getUserObject();
        data.setType(type);
        if (type == 2) {
            this.refkeyField.setEnabled(true);
            this.refkeyField.setText(data.getRefer());
        } else {
            this.refkeyField.setEnabled(false);
            this.refkeyField.setText(null);
        }
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.viewResult();
    }

    boolean nameChanged(String value) {
        IdentityConstraintNodeData data = (IdentityConstraintNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (data != null) {
            if (value.equals("")) {
                JOptionPane.showMessageDialog(this.parentPanel, IdentityConstraintPanel.getMessage("REQUIRED"));
                this.nameField.setText(s);
                return false;
            }
            data.setNodeName(value);
        }
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    boolean refkeyChanged(String value) {
        IdentityConstraintNodeData data = (IdentityConstraintNodeData)this.node.getUserObject();
        String s = data.getRefer();
        if (data != null) {
            if (value.equals("") && !data.getRefer().equals("")) {
                JOptionPane.showMessageDialog(this.parentPanel, IdentityConstraintPanel.getMessage("REQUIRED"));
                this.refkeyField.setText(s);
                return false;
            }
            data.setRefer(value);
        }
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof IdentityConstraintNodeData) {
            String refKey = null;
            IdentityConstraintNodeData icdata = (IdentityConstraintNodeData)data;
            if (icdata.getType() == 0) {
                this.identityBtn[0].setSelected(true);
                this.refkeyField.setEnabled(false);
            } else if (icdata.getType() == 1) {
                this.identityBtn[1].setSelected(true);
                this.refkeyField.setEnabled(false);
            } else if (icdata.getType() == 2) {
                this.identityBtn[2].setSelected(true);
                this.refkeyField.setEnabled(true);
                refKey = icdata.getRefer();
            } else {
                this.identityBtn[0].setSelected(true);
                this.refkeyField.setEnabled(false);
                icdata.setType(0);
            }
            this.nameField.setText(icdata.getNodeName());
            this.refkeyField.setText(refKey);
        }
        this.revalidate();
        this.viewResult();
    }
}

