/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.AnyAttributePanel;
import com.argo21.jxp.vxsd.MgsDeclNodeData;
import com.argo21.jxp.vxsd.ModelGroupNodeData;
import com.argo21.jxp.vxsd.XDeclNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.xsd.MgsDecl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;

class MgsDeclPanel
extends AnyAttributePanel {
    private static String[] PARTICLE_INFO_NAMES = new String[]{MgsDeclPanel.getMessage("LAB_SEQ"), MgsDeclPanel.getMessage("LAB_CHOICE"), MgsDeclPanel.getMessage("LAB_ELEM_ANY"), MgsDeclPanel.getMessage("LAB_ALL")};
    private JPanel typePanel;
    private JRadioButton[] ParticleBtn = new JRadioButton[4];
    private JPanel textPanel;
    private TextFieldEx minField;
    private TextFieldEx maxField;
    private JCheckBox NoLimitBtn;
    private TextFieldEx nsField;
    private XSDResultPanel result;

    MgsDeclPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.typePanel = new JPanel();
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setOpaque(true);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(MgsDeclPanel.getMessage("TL_PARTICLE")));
        ButtonGroup pargroup = new ButtonGroup();
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridy = 0;
        this.ParticleBtn[0] = new JRadioButton(PARTICLE_INFO_NAMES[0]);
        this.typePanel.add((Component)this.ParticleBtn[0], c);
        ++c.gridy;
        c.weightx = 1.0;
        this.ParticleBtn[1] = new JRadioButton(PARTICLE_INFO_NAMES[1]);
        this.typePanel.add((Component)this.ParticleBtn[1], c);
        ++c.gridy;
        c.weightx = 0.0;
        this.ParticleBtn[2] = new JRadioButton(PARTICLE_INFO_NAMES[2]);
        this.typePanel.add((Component)this.ParticleBtn[2], c);
        ++c.gridy;
        c.weightx = 0.0;
        this.ParticleBtn[3] = new JRadioButton(PARTICLE_INFO_NAMES[3]);
        this.typePanel.add((Component)this.ParticleBtn[3], c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MgsDeclPanel.this.ParticleChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 4; ++i) {
            this.ParticleBtn[i].setFont(this.getDefaultFont());
            pargroup.add(this.ParticleBtn[i]);
            this.ParticleBtn[i].addActionListener(al);
        }
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridBagLayout());
        this.textPanel.setBorder(BorderFactory.createTitledBorder(MgsDeclPanel.getMessage("TL_APPEAR")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.textPanel.add((Component)new JLabel(MgsDeclPanel.getMessage("LAB_MINAPEEAR")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel arpnl = new JPanel();
        arpnl.setLayout(new GridLayout(1, 4));
        this.minField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                MgsDeclPanel.this.minChanged(value.trim());
                return true;
            }
        };
        arpnl.add((Component)this.minField, c);
        arpnl.add((Component)new JLabel(MgsDeclPanel.getMessage("LAB_MAXAPEEAR")), c);
        this.maxField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                MgsDeclPanel.this.maxChanged(value.trim());
                return true;
            }
        };
        arpnl.add((Component)this.maxField, c);
        this.NoLimitBtn = new JCheckBox(MgsDeclPanel.getMessage("LAB_UNBOUNDED"));
        this.NoLimitBtn.setFont(this.getDefaultFont());
        this.NoLimitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = MgsDeclPanel.this.NoLimitBtn.isSelected() ? "unbounded" : "1";
                MgsDeclPanel.this.limitBtnEnabler(value);
            }
        });
        arpnl.add((Component)this.NoLimitBtn, c);
        this.textPanel.add((Component)arpnl, c);
        this.add((Component)this.textPanel, gc);
        ++gc.gridy;
        JPanel anyPanel = this.getAnyPanel();
        ((TitledBorder)anyPanel.getBorder()).setTitle(msgCatalog.getMessage("TL_MGS_ANY"));
        this.add((Component)anyPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    @Override
    void viewResult() {
        MgsDecl declnode = XSDEditorPanel.createMgsDecl(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    public void ParticleChanged(JRadioButton rbtn) {
        if (!rbtn.isSelected()) {
            return;
        }
        MgsDeclNodeData data = (MgsDeclNodeData)this.node.getUserObject();
        boolean isAny = false;
        if (this.maxField.isEnabled()) {
            this.NoLimitBtn.setEnabled(true);
        }
        if (rbtn == this.ParticleBtn[0]) {
            data.setModel(0);
        } else if (rbtn == this.ParticleBtn[1]) {
            data.setModel(1);
        } else if (rbtn == this.ParticleBtn[3]) {
            data.setModel(3);
            data.setMinOcc(null);
            this.minField.setText("");
            data.setMaxOcc(null);
            this.maxField.setText("");
            this.NoLimitBtn.setSelected(false);
            this.NoLimitBtn.setEnabled(false);
        } else if (rbtn == this.ParticleBtn[2]) {
            data.setModel(2);
            isAny = true;
            this.setDataToAnyCombos(data);
        }
        this.namespaceCombo.setEnabled(isAny);
        this.processContentsCombo.setEnabled(isAny);
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.viewResult();
    }

    boolean minChanged(String value) {
        MgsDeclNodeData data = (MgsDeclNodeData)this.node.getUserObject();
        String s = data.getMinOcc();
        if (data != null) {
            if (value.equals("")) {
                data.setMinOcc(null);
            } else {
                int mindata = -1;
                try {
                    mindata = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (mindata == -1) {
                    JOptionPane.showMessageDialog(this.parentPanel, MgsDeclPanel.getMessage("INVALID_SIZE"));
                    this.minField.setText(s);
                    return false;
                }
                if (this.ParticleBtn[3].isSelected() && mindata != 1) {
                    JOptionPane.showMessageDialog(this.parentPanel, MgsDeclPanel.getMessage("INVALID_LIMIT"));
                    this.minField.setText(s);
                    return false;
                }
                data.setMinOcc(Integer.toString(mindata));
                this.minField.setText(Integer.toString(mindata));
            }
        }
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    boolean maxChanged(String value) {
        MgsDeclNodeData data = (MgsDeclNodeData)this.node.getUserObject();
        String s = data.getMaxOcc();
        if (data != null) {
            if (value.equals("")) {
                data.setMaxOcc(null);
            } else if (!value.equals("unbounded")) {
                int maxdata = -1;
                try {
                    maxdata = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (maxdata == -1) {
                    JOptionPane.showMessageDialog(this.parentPanel, MgsDeclPanel.getMessage("INVALID_SIZE"));
                    this.maxField.setText(s);
                    return false;
                }
                if (this.ParticleBtn[3].isSelected() && maxdata != 1 && maxdata != 0) {
                    JOptionPane.showMessageDialog(this.parentPanel, MgsDeclPanel.getMessage("INVALID_LIMIT_ZERO"));
                    this.maxField.setText(s);
                    return false;
                }
                data.setMaxOcc(Integer.toString(maxdata));
                this.maxField.setText(Integer.toString(maxdata));
            } else {
                data.setMaxOcc(value);
            }
        }
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    void limitBtnEnabler(String value) {
        MgsDeclNodeData data = (MgsDeclNodeData)this.node.getUserObject();
        if (data != null) {
            data.setMaxOcc(value);
            this.maxField.setText(value);
        }
        this.nodeChanged();
        this.viewResult();
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof MgsDeclNodeData) {
            MgsDeclNodeData mgsdata = (MgsDeclNodeData)data;
            this.setParticleBtn(mgsdata);
            DefaultMutableTreeNode node1 = null;
            try {
                node1 = (DefaultMutableTreeNode)node.getParent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node1 != null) {
                Object data1 = node1.getUserObject();
                if (!(data1 instanceof ModelGroupNodeData)) {
                    String mint = mgsdata.getMinOcc();
                    String maxt = mgsdata.getMaxOcc();
                    if (mint != null && mint != "") {
                        this.minField.setText(mint);
                    }
                    if (maxt != null && maxt != "") {
                        this.maxField.setText(maxt);
                        if (maxt.equals("unbounded")) {
                            this.NoLimitBtn.setSelected(true);
                        }
                    }
                } else {
                    this.minField.setEnabled(false);
                    this.maxField.setEnabled(false);
                    this.NoLimitBtn.setEnabled(false);
                }
            }
            if (this.ParticleBtn[3].isSelected()) {
                this.NoLimitBtn.setEnabled(false);
            }
            this.setupAnyPanel(mgsdata);
        }
        this.revalidate();
        this.viewResult();
    }

    private void setParticleBtn(MgsDeclNodeData data) {
        int parentNode;
        this.ParticleBtn[data.getModel()].setSelected(true);
        DefaultMutableTreeNode selNode = this.parentPanel.getSelectedTreeNode();
        if (this.parentPanel.getChildNodeInvalid(selNode, 54) || this.parentPanel.getChildNodeInvalid(selNode, 56)) {
            this.ParticleBtn[3].setEnabled(false);
            this.ParticleBtn[2].setEnabled(false);
        }
        if (this.parentPanel.getChildNodeInvalid(selNode, 50)) {
            this.ParticleBtn[2].setEnabled(false);
        }
        if ((parentNode = ((XDeclNodeData)((DefaultMutableTreeNode)selNode.getParent()).getUserObject()).getNodeType()) == 54) {
            this.ParticleBtn[3].setEnabled(false);
        } else if (parentNode == 52 || parentNode == 56 || parentNode == 62) {
            this.ParticleBtn[2].setEnabled(false);
        }
    }

    private void setupAnyPanel(MgsDeclNodeData mgsdata) {
        boolean isAny = this.ParticleBtn[2].isSelected();
        if (isAny) {
            this.setDataToAnyCombos(mgsdata);
        }
        this.namespaceCombo.setEnabled(isAny);
        this.processContentsCombo.setEnabled(isAny);
    }
}

