/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.SelectorFieldNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.SelectorField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class SelectorFieldPanel
extends XsdContentsEditPanel {
    private static String[] SELECTOR_FIELD_INFO_NAMES = new String[]{SelectorFieldPanel.getMessage("LAB_SELECTOR"), SelectorFieldPanel.getMessage("LAB_FIELD")};
    private JPanel typePanel;
    private JRadioButton[] selectorFieldBtn = new JRadioButton[2];
    private JPanel textPanel;
    private TextFieldEx xpathField;
    private XSDResultPanel result;

    SelectorFieldPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.typePanel = new JPanel();
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setOpaque(true);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(SelectorFieldPanel.getMessage("TL_SERECTOR_FIELD")));
        ButtonGroup pargroup = new ButtonGroup();
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridy = 0;
        this.selectorFieldBtn[0] = new JRadioButton(SELECTOR_FIELD_INFO_NAMES[0]);
        this.typePanel.add((Component)this.selectorFieldBtn[0], c);
        ++c.gridy;
        c.weightx = 1.0;
        this.selectorFieldBtn[1] = new JRadioButton(SELECTOR_FIELD_INFO_NAMES[1]);
        this.typePanel.add((Component)this.selectorFieldBtn[1], c);
        for (int i = 0; i < this.selectorFieldBtn.length; ++i) {
            this.selectorFieldBtn[i].setFont(this.getDefaultFont());
            pargroup.add(this.selectorFieldBtn[i]);
        }
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridBagLayout());
        this.textPanel.setBorder(BorderFactory.createTitledBorder(SelectorFieldPanel.getMessage("TL_XPATH")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.textPanel.add((Component)new JLabel(SelectorFieldPanel.getMessage("LAB_XPATH")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel arpnl = new JPanel();
        arpnl.setLayout(new GridLayout(1, 4));
        this.xpathField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                SelectorFieldPanel.this.xpathChanged(value.trim());
                return true;
            }
        };
        arpnl.add((Component)this.xpathField, c);
        this.textPanel.add((Component)arpnl, c);
        this.add((Component)this.textPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void viewResult() {
        SelectorField declnode = XSDEditorPanel.createSelectorField(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    boolean xpathChanged(String value) {
        SelectorFieldNodeData data = (SelectorFieldNodeData)this.node.getUserObject();
        String s = data.getXpath();
        if (data != null) {
            if (value == null || value.equals("")) {
                JOptionPane.showMessageDialog(this.parentPanel, SelectorFieldPanel.getMessage("REQUIRED"));
                this.xpathField.setText(s);
                return false;
            }
            data.setXpath(value);
        }
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof SelectorFieldNodeData) {
            SelectorFieldNodeData sfndata = (SelectorFieldNodeData)data;
            if (sfndata.getType() == 0) {
                this.selectorFieldBtn[0].setSelected(true);
                this.selectorFieldBtn[1].setEnabled(false);
            } else if (sfndata.getType() == 1) {
                this.selectorFieldBtn[1].setSelected(true);
                this.selectorFieldBtn[0].setEnabled(false);
            } else {
                this.selectorFieldBtn[1].setSelected(true);
                this.selectorFieldBtn[0].setEnabled(false);
                sfndata.setType(1);
            }
            this.xpathField.setText(sfndata.getXpath());
        }
        this.revalidate();
        this.viewResult();
    }
}

