/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.vxsd.DerivationNodeData;
import com.argo21.jxp.vxsd.SimpleTypeNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdListNodeData;
import com.argo21.jxp.vxsd.XsdUnionNodeData;
import com.argo21.jxp.xsd.SimpleType;
import com.argo21.jxp.xsd.XSDDocument;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class SimpleTypePanel
extends XsdContentsEditPanel {
    private JPanel namePanel;
    private JLabel nameLabel;
    private JLabel eleLabel;
    private ComboTextFieldEx simpleField;
    private ComboTextFieldEx finalField;
    private JPanel derivationPanel;
    private JLabel derivationLabel1;
    private JLabel derivationLabel2;
    private JRadioButton[] derivationOption1 = new JRadioButton[3];
    private XSDResultPanel result;

    SimpleTypePanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            // empty if block
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new GridBagLayout());
        this.namePanel.setOpaque(true);
        this.namePanel.setBorder(BorderFactory.createTitledBorder(SimpleTypePanel.getMessage("TL_SIMPLE")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.nameLabel = new JLabel(SimpleTypePanel.getMessage("LAB_NAME"));
        this.namePanel.add((Component)this.nameLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel rd = new JPanel();
        rd.setLayout(new GridLayout(1, 2));
        this.simpleField = new ComboTextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    SimpleTypePanel.this.simpleNameChanged(value.trim());
                }
                return true;
            }
        };
        rd.add((Component)this.simpleField, c);
        this.namePanel.add((Component)rd, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.namePanel.add((Component)new JLabel(SimpleTypePanel.getMessage("LAB_FINAL")), c);
        ++c.gridx;
        c.gridwidth = 0;
        String[] finals = new String[]{"#all", "restriction", "list", "union", SimpleTypePanel.getMessage("LAB_NOTHING")};
        this.finalField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                SimpleTypePanel.this.finalChanged(value.trim());
                return true;
            }
        };
        this.finalField.setEnabledEvent(false);
        this.finalField.setList(finals);
        this.finalField.setEnabledEvent(true);
        this.namePanel.add((Component)this.finalField, c);
        this.add((Component)this.namePanel, gc);
        ++gc.gridy;
        this.derivationPanel = new JPanel();
        this.derivationPanel.setLayout(new GridBagLayout());
        this.derivationPanel.setBorder(BorderFactory.createTitledBorder(SimpleTypePanel.getMessage("TL_SIMPLETYPE")));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.derivationLabel1 = new JLabel(SimpleTypePanel.getMessage("LAB_DERIVATION"));
        this.derivationPanel.add((Component)this.derivationLabel1, c);
        ButtonGroup derivationGroup1 = new ButtonGroup();
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption1[0] = new JRadioButton("restriction");
        this.derivationPanel.add((Component)this.derivationOption1[0], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption1[1] = new JRadioButton("list");
        this.derivationPanel.add((Component)this.derivationOption1[1], c);
        ++c.gridx;
        c.weightx = 1.0;
        this.derivationOption1[2] = new JRadioButton("union");
        this.derivationPanel.add((Component)this.derivationOption1[2], c);
        ActionListener a10 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTypePanel.this.derivationChanged1(e);
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.derivationOption1[i].addActionListener(a10);
            derivationGroup1.add(this.derivationOption1[i]);
            this.derivationOption1[i].setFont(defaultFont);
        }
        this.add((Component)this.derivationPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void reviewNamePanel(boolean mustdo) {
        boolean showAttr = true;
        this.namePanel.revalidate();
        this.revalidate();
        Vector vet = new Vector();
        ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
        this.simpleField.setEnabledEvent(false);
        this.simpleField.setList(vet);
        SimpleTypeNodeData data = (SimpleTypeNodeData)this.node.getUserObject();
        if (data != null) {
            String name2 = data.getNodeName();
            this.simpleField.setText(name2);
        }
        this.simpleField.setEnabledEvent(true);
    }

    void simpleNameChanged(String value) {
        SimpleTypeNodeData data = (SimpleTypeNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (value == null || value.equals("")) {
            JOptionPane.showMessageDialog(this.parentPanel, SimpleTypePanel.getMessage("REQUIRED", value));
            this.simpleField.setText(s);
        }
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, SimpleTypePanel.getMessage("INVALID_NAME", value));
                this.simpleField.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelectSameParent(53, value)) {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), SimpleTypePanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                this.simpleField.setText(s);
                return;
            }
            this.nameChangedTo(XSDDocument.getValueOnly(value));
            this.updateXsd();
            this.viewResult();
        }
    }

    void removeChildNode(DefaultMutableTreeNode node) {
        int n = node.getChildCount();
        DefaultMutableTreeNode node1 = null;
        for (int i = 0; i < n; ++i) {
            try {
                node1 = (DefaultMutableTreeNode)node.getFirstChild();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = this.parentPanel.removeDeclNode(node1, false);
        }
    }

    void derivationChanged1(ActionEvent e) {
        JRadioButton derivationOpt = (JRadioButton)e.getSource();
        if (!derivationOpt.isSelected()) {
            return;
        }
        DefaultMutableTreeNode listTreeNode = null;
        DefaultMutableTreeNode deriTreeNode = null;
        DefaultMutableTreeNode unionTreeNode = null;
        DerivationNodeData derivationNode = null;
        XsdListNodeData listNode = null;
        XsdUnionNodeData unionNode = null;
        SimpleTypeNodeData data = (SimpleTypeNodeData)this.node.getUserObject();
        if (derivationOpt == this.derivationOption1[0]) {
            data.setType(0);
            this.removeChildNode(this.node);
            derivationNode = new DerivationNodeData(0, "restriction");
            deriTreeNode = new DefaultMutableTreeNode(derivationNode);
            if (deriTreeNode != null) {
                this.node.add(deriTreeNode);
            }
        } else if (derivationOpt == this.derivationOption1[1]) {
            data.setType(1);
            this.removeChildNode(this.node);
            listNode = new XsdListNodeData("list");
            listTreeNode = new DefaultMutableTreeNode(listNode);
            if (listTreeNode != null) {
                this.node.add(listTreeNode);
            }
        } else if (derivationOpt == this.derivationOption1[2]) {
            data.setType(2);
            this.removeChildNode(this.node);
            unionNode = new XsdUnionNodeData("union");
            unionTreeNode = new DefaultMutableTreeNode(unionNode);
            if (unionTreeNode != null) {
                this.node.add(unionTreeNode);
            }
        }
        this.setEnabled();
        this.nodeChanged();
        this.nodeStructureChanged();
        this.updateXsd();
        this.reviewNamePanel(true);
        this.viewResult();
    }

    void finalChanged(String value) {
        SimpleTypeNodeData data = (SimpleTypeNodeData)this.node.getUserObject();
        if (data != null) {
            if (value.equals("#all") || value.equals("restriction") || value.equals("list") || value.equals("union")) {
                data.setFinal(value);
            } else {
                data.setFinal(null);
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void viewResult() {
        SimpleType simpleDecl = XSDEditorPanel.createSimpleType(null, this.node);
        String rs = simpleDecl == null ? "" : simpleDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof SimpleTypeNodeData) {
            this.simpleField.setEnabledEvent(false);
            SimpleTypeNodeData cm = (SimpleTypeNodeData)data;
            if (node.getParent().toString() == "schema") {
                this.simpleField.setEnabled(true);
            } else {
                this.simpleField.setEnabled(false);
            }
            DefaultMutableTreeNode node1 = null;
            try {
                node1 = this.getValidFirstChild(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node1 != null) {
                Object data1 = node1.getUserObject();
                if (data1 instanceof DerivationNodeData) {
                    DerivationNodeData drnode = (DerivationNodeData)data1;
                    if (drnode.getType() == 0) {
                        this.derivationOption1[0].setSelected(true);
                    }
                } else if (data1 instanceof XsdListNodeData) {
                    this.derivationOption1[1].setSelected(true);
                } else if (data1 instanceof XsdUnionNodeData) {
                    this.derivationOption1[2].setSelected(true);
                }
            }
            String sFinal = cm.getFinal();
            this.finalField.setSelectedIndex(4);
            if (sFinal != null) {
                if (sFinal.equals("#all")) {
                    this.finalField.setSelectedIndex(0);
                } else if (sFinal.equals("restriction")) {
                    this.finalField.setSelectedIndex(1);
                } else if (sFinal.equals("list")) {
                    this.finalField.setSelectedIndex(2);
                } else if (sFinal.equals("union")) {
                    this.finalField.setSelectedIndex(3);
                } else {
                    this.finalField.setSelectedIndex(4);
                }
            }
            this.setEnabled();
            this.reviewNamePanel(true);
            if (this.parentPanel.checkAlreadyUseDecl(node)) {
                this.simpleField.setEnabled(false);
                this.setEnabledDerivation(false);
            }
            this.simpleField.setEnabledEvent(true);
            this.viewResult();
        }
    }

    void setEnabledDerivation(boolean enabled) {
        this.derivationOption1[0].setEnabled(enabled);
        this.derivationOption1[1].setEnabled(enabled);
        this.derivationOption1[2].setEnabled(enabled);
    }

    void setEnabledFinal(boolean enabled) {
        this.finalField.setEnabled(enabled);
    }

    void setEnabled() {
        this.setEnabledDerivation(true);
        if (this.simpleField.isEnabled()) {
            this.setEnabledFinal(true);
        } else {
            this.setEnabledFinal(false);
        }
    }

    boolean isName(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n < 1) {
            return false;
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }
}

