/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.util.Properties;
import com.argo21.jxp.vxsd.XSDDeclNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class XSDDeclPanel
extends XsdContentsEditPanel {
    protected TextFieldEx nameField;
    protected ComboTextFieldEx versionField;
    protected ComboTextFieldEx encodingField;
    protected XSDResultPanel result;
    protected JPanel propertyPanel;
    private static String NON = XSDDeclPanel.getMessage("UNDEF_MARK");
    private static String[] VERSIONS = new String[]{NON, "1.0"};
    private static String[] ENCODINGS;

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(XSDDeclPanel.getMessage("TL_XSD")));
        JLabel label = new JLabel(XSDDeclPanel.getMessage("LAB_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object source, String value) {
                XSDDeclPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        this.propertyPanel = new JPanel();
        this.propertyPanel.setLayout(new GridBagLayout());
        this.propertyPanel.setOpaque(true);
        this.propertyPanel.setBorder(BorderFactory.createTitledBorder(XSDDeclPanel.getMessage("TL_PROPERTY")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        label = new JLabel(XSDDeclPanel.getMessage("LAB_VERSION"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.versionField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                XSDDeclPanel.this.propertyChanged("version", value);
                return true;
            }
        };
        this.versionField.setEnabledEvent(false);
        this.versionField.setList(VERSIONS);
        this.versionField.setEnabledEvent(true);
        this.propertyPanel.add((Component)this.versionField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(XSDDeclPanel.getMessage("LAB_ENCODING"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.encodingField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                XSDDeclPanel.this.propertyChanged("encoding", value);
                return true;
            }
        };
        this.encodingField.setEnabledEvent(false);
        this.encodingField.setList(ENCODINGS);
        this.encodingField.setEnabledEvent(true);
        this.propertyPanel.add((Component)this.encodingField, c);
        this.add((Component)this.propertyPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    protected void nameChanged(String value) {
        XSDDeclNodeData data = (XSDDeclNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (!s.equals(value)) {
            if (!XSDDeclPanel.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, XSDDeclPanel.getMessage("INVALID_NAME", value));
                this.nameField.setText(s);
                return;
            }
            data.setNodeName(value);
            Properties ps = data.getProperties();
            ps.repleace("name", value);
            JTree tree = this.parentPanel.getStructTree();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            this.nodeStructureChanged();
            tree.setSelectionRow(0);
            this.contentsChanged();
        }
    }

    protected void propertyChanged(String field, String value) {
        XSDDeclNodeData data = (XSDDeclNodeData)this.node.getUserObject();
        Properties ps = data.getProperties();
        if (value != null && value.length() == 0) {
            value = null;
        } else if (NON.equals(value)) {
            value = null;
        }
        ps.repleace(field, value);
        this.result.setText(this.stringProperties(ps));
        this.contentsChanged();
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        Object obj = node.getUserObject();
        XSDDeclNodeData data = (XSDDeclNodeData)obj;
        this.node = node;
        this.nameField.setText(data.getNodeName());
        Properties ps = data.getProperties();
        if (ps == null) {
            return;
        }
        String value = ps.getValue("version", NON);
        this.versionField.setEnabledEvent(false);
        this.versionField.setText(value);
        this.versionField.setEnabledEvent(true);
        value = ps.getValue("encoding", NON);
        this.encodingField.setEnabledEvent(false);
        int selectedIndex = -1;
        int n = ENCODINGS.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equalsIgnoreCase(ENCODINGS[i])) continue;
            this.encodingField.setSelectedIndex(i);
            selectedIndex = i;
            break;
        }
        if (selectedIndex < 0) {
            this.encodingField.setSelectedItem(value);
        }
        this.encodingField.setEnabledEvent(true);
        this.result.setText(this.stringProperties(ps));
    }

    protected String stringProperties(Properties properties) {
        String s = properties.getValue("version");
        String s1 = properties.getValue("encoding");
        StringBuffer sb = new StringBuffer();
        if (s != null || s1 != null) {
            sb.append("<?xml ");
            if (s != null) {
                sb.append("version=\"");
                sb.append(s);
                sb.append("\"");
                if (s1 != null) {
                    sb.append(" ");
                }
            }
            if (s1 != null) {
                sb.append("encoding=\"");
                sb.append(s1);
                sb.append("\"");
            }
            sb.append("?>");
        }
        return sb.toString();
    }

    public static boolean isName(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n < 1) {
            return false;
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    static {
        String[] codes = MIME2Java.getAllStandardEncoding();
        ENCODINGS = new String[codes.length + 1];
        XSDDeclPanel.ENCODINGS[0] = NON;
        System.arraycopy(codes, 0, ENCODINGS, 1, codes.length);
    }
}

