/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdAppinfoDocNodeData;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.XsdAppinfoDoc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdAppinfoDocPanel
extends XsdContentsEditPanel {
    private static String[] APPDOC_INFO_NAMES = new String[]{XsdAppinfoDocPanel.getMessage("LAB_APPINFO"), XsdAppinfoDocPanel.getMessage("LAB_DOCUMENT")};
    private JPanel typePanel;
    private JRadioButton[] appDocBtn = new JRadioButton[2];
    private JPanel textPanel;
    private TextFieldEx uriField;
    private TextFieldEx langField;
    private JPanel textAnoPanel;
    private JTextArea valueField;
    private XSDResultPanel result;

    XsdAppinfoDocPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        this.typePanel = new JPanel();
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setOpaque(true);
        this.typePanel.setBorder(BorderFactory.createTitledBorder(XsdAppinfoDocPanel.getMessage("TL_ANNOTATIONDATA")));
        ButtonGroup pargroup = new ButtonGroup();
        c.gridx = 1;
        c.weightx = 0.0;
        c.gridy = 0;
        this.appDocBtn[0] = new JRadioButton(APPDOC_INFO_NAMES[0]);
        this.typePanel.add((Component)this.appDocBtn[0], c);
        ++c.gridy;
        c.weightx = 1.0;
        this.appDocBtn[1] = new JRadioButton(APPDOC_INFO_NAMES[1]);
        this.typePanel.add((Component)this.appDocBtn[1], c);
        ActionListener a2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XsdAppinfoDocPanel.this.typeChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < this.appDocBtn.length; ++i) {
            this.appDocBtn[i].addActionListener(a2);
            pargroup.add(this.appDocBtn[i]);
            this.appDocBtn[i].setFont(this.getDefaultFont());
        }
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new GridBagLayout());
        this.textPanel.setBorder(BorderFactory.createTitledBorder(XsdAppinfoDocPanel.getMessage("TL_ANNOTATIONINFO")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.textPanel.add((Component)new JLabel(XsdAppinfoDocPanel.getMessage("LAB_DATAURI")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.uriField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                XsdAppinfoDocPanel.this.uriChanged(value.trim());
                return true;
            }
        };
        this.textPanel.add((Component)this.uriField, c);
        c.gridx = 0;
        ++c.gridy;
        this.textPanel.add((Component)new JLabel(XsdAppinfoDocPanel.getMessage("LAB_LANG")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.langField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                XsdAppinfoDocPanel.this.langChanged(value.trim());
                return true;
            }
        };
        this.textPanel.add((Component)this.langField, c);
        this.add((Component)this.textPanel, gc);
        ++gc.gridy;
        this.textAnoPanel = new JPanel(new BorderLayout());
        this.textAnoPanel.setBorder(BorderFactory.createTitledBorder(XsdAppinfoDocPanel.getMessage("TL_ANNOTATIONTEXT")));
        this.valueField = new JTextArea();
        EnterListener nl = new EnterListener(){

            @Override
            public void valueChanged(String value) {
                XsdAppinfoDocPanel.this.annoTextChanged(value.trim());
            }
        };
        this.valueField.addFocusListener(nl);
        this.valueField.addKeyListener(nl);
        JScrollPane sp = new JScrollPane(this.valueField);
        sp.setPreferredSize(new Dimension(100, 100));
        this.textAnoPanel.add((Component)sp, "Center");
        this.add((Component)this.textAnoPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void viewResult() {
        XsdAppinfoDoc declnode = XSDEditorPanel.createAppinfoDoc(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    void typeChanged(JRadioButton appDocOpt) {
        if (!appDocOpt.isSelected()) {
            return;
        }
        XsdAppinfoDocNodeData data = (XsdAppinfoDocNodeData)this.node.getUserObject();
        if (appDocOpt == this.appDocBtn[0]) {
            data.setType(0);
            data.setLang(null);
            this.langField.setText("");
            this.langField.setEnabled(false);
        } else {
            data.setType(1);
            this.langField.setEnabled(true);
        }
        this.nodeChanged();
        this.viewResult();
    }

    boolean uriChanged(String value) {
        XsdAppinfoDocNodeData data = (XsdAppinfoDocNodeData)this.node.getUserObject();
        String s = data.getSource();
        data.setSource(value);
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    boolean langChanged(String value) {
        XsdAppinfoDocNodeData data = (XsdAppinfoDocNodeData)this.node.getUserObject();
        String s = data.getLang();
        data.setLang(value);
        this.nodeChanged();
        this.viewResult();
        return true;
    }

    void annoTextChanged(String value) {
        XsdAppinfoDocNodeData data = (XsdAppinfoDocNodeData)this.node.getUserObject();
        data.setText(value);
        this.nodeChanged();
        this.viewResult();
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof XsdAppinfoDocNodeData) {
            XsdAppinfoDocNodeData appdata = (XsdAppinfoDocNodeData)data;
            if (appdata.getType() == 0) {
                this.appDocBtn[0].setSelected(true);
                this.langField.setEnabled(false);
            } else if (appdata.getType() == 1) {
                this.appDocBtn[1].setSelected(true);
                this.langField.setEnabled(true);
                this.langField.setText(appdata.getLang());
            } else {
                this.appDocBtn[0].setSelected(true);
                this.langField.setEnabled(false);
                appdata.setType(0);
            }
            this.uriField.setText(appdata.getSource());
            this.valueField.setText(appdata.getText());
            try {
                this.valueField.select(0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.revalidate();
        this.viewResult();
    }

    class EnterListener
    implements FocusListener,
    KeyListener {
        boolean ishandel = false;

        EnterListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!this.ishandel) {
                this.ishandel = true;
                JTextComponent textField = (JTextComponent)e.getSource();
                this.valueChanged(textField.getText());
            }
            this.ishandel = false;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!this.ishandel && e.getKeyCode() == 10) {
                this.ishandel = true;
                JTextComponent textField = (JTextComponent)e.getSource();
                this.valueChanged(textField.getText());
            }
            this.ishandel = false;
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        public void valueChanged(String value) {
        }
    }
}

