/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDFacetNodeData;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.XsdFacet;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdFacetPanel
extends XsdContentsEditPanel {
    private JPanel FacetPanel;
    private ComboTextFieldEx facetField;
    private String[] facets = new String[]{"length", "minLength", "maxLength", "pattern", "enumeration", "whiteSpace", "maxInclusive", "maxExclusive", "minInclusive", "minExclusive", "totalDigits", "fractionDigits"};
    private TextFieldEx valueField;
    private JRadioButton[] fixedbtn = new JRadioButton[2];
    private XSDResultPanel result;

    XsdFacetPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.FacetPanel = new JPanel();
        this.FacetPanel.setLayout(new GridBagLayout());
        this.FacetPanel.setOpaque(true);
        this.FacetPanel.setBorder(BorderFactory.createTitledBorder(XsdFacetPanel.getMessage("TL_FACET")));
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.FacetPanel.add((Component)new JLabel(XsdFacetPanel.getMessage("LAB_FACET")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel fp = new JPanel();
        fp.setLayout(new GridLayout(1, 2));
        this.facetField = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                XsdFacetPanel.this.facetChanged();
                return true;
            }
        };
        this.facetField.setEnabledEvent(false);
        this.facetField.setList(this.facets);
        this.facetField.setEnabledEvent(true);
        fp.add((Component)this.facetField, c);
        this.FacetPanel.add((Component)fp, c);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        this.FacetPanel.add((Component)new JLabel(XsdFacetPanel.getMessage("LAB_INPUT_VALUE2")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.valueField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                XsdFacetPanel.this.facetValueChanged(value.trim());
                return true;
            }
        };
        this.FacetPanel.add((Component)this.valueField, c);
        c.gridx = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridwidth = 1;
        this.FacetPanel.add((Component)new JLabel("fixed"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.gridwidth = 0;
        JPanel rb = new JPanel();
        rb.setLayout(new GridLayout(1, 2));
        ButtonGroup rbGroup = new ButtonGroup();
        this.fixedbtn[0] = new JRadioButton("true");
        rb.add((Component)this.fixedbtn[0], c);
        this.fixedbtn[1] = new JRadioButton("false");
        rb.add((Component)this.fixedbtn[1], c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XsdFacetPanel.this.rbChanged(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            this.fixedbtn[i].addActionListener(al);
            rbGroup.add(this.fixedbtn[i]);
            this.fixedbtn[i].setFont(defaultFont);
        }
        this.FacetPanel.add((Component)rb, c);
        this.add((Component)this.FacetPanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void facetChanged() {
        int type = this.facetField.getSelectedIndex();
        XSDFacetNodeData data = (XSDFacetNodeData)this.node.getUserObject();
        if (data != null) {
            this.fixedbtnEnabler(type, data);
            data.setType(type);
            this.nodeChanged();
            this.viewResult();
        }
    }

    void facetValueChanged(String value) {
        XSDFacetNodeData data = (XSDFacetNodeData)this.node.getUserObject();
        if (data != null) {
            data.setValue(value);
            this.viewResult();
        }
    }

    void rbChanged(ActionEvent e) {
        JRadioButton rb = (JRadioButton)e.getSource();
        if (rb.isSelected()) {
            XSDFacetNodeData data = (XSDFacetNodeData)this.node.getUserObject();
            if (rb == this.fixedbtn[0]) {
                data.setFixed("true");
            } else if (rb == this.fixedbtn[1]) {
                data.setFixed("false");
            }
            this.nodeChanged();
            this.viewResult();
        }
    }

    void viewResult() {
        XsdFacet declnode = XSDEditorPanel.createFacet(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object data = node.getUserObject();
        if (data instanceof XSDFacetNodeData) {
            XSDFacetNodeData fnode = (XSDFacetNodeData)data;
            this.facetField.setText(this.facets[fnode.getType()]);
            this.valueField.setText(fnode.getValue());
            this.fixedbtnEnabler(fnode.getType(), fnode);
            if (fnode.getFixed() != null && fnode.getFixed().equals("true")) {
                this.fixedbtn[0].setSelected(true);
            } else {
                this.fixedbtn[1].setSelected(true);
            }
        }
        this.revalidate();
        this.viewResult();
    }

    void fixedbtnEnabler(int type, XSDFacetNodeData data) {
        if (type == 4 || type == 3) {
            this.fixedbtn[0].setEnabled(false);
            this.fixedbtn[1].setEnabled(false);
            data.setFixed("false");
        } else {
            this.fixedbtn[0].setEnabled(true);
            this.fixedbtn[1].setEnabled(true);
        }
        this.viewResult();
    }
}

