/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdImportNodeData;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdImport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdImportPanel
extends XsdContentsEditPanel {
    private TextFieldEx nameField;
    private TextFieldEx nsField;
    private JPanel typePanel;
    private XSDResultPanel result;

    XsdImportPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(XsdImportPanel.getMessage("TL_IMPORT")));
        JLabel nslabel = new JLabel(XsdImportPanel.getMessage("LAB_NAMESPACE"));
        tp.add((Component)nslabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nsField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                XsdImportPanel.this.nsChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nsField, c);
        --c.gridx;
        c.weightx = 0.0;
        ++c.gridy;
        JLabel label = new JLabel(XsdImportPanel.getMessage("LAB_SCHEMALOCATION"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                XsdImportPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    boolean nameChanged(String value) {
        Object data = this.node.getUserObject();
        if (data instanceof XsdImportNodeData) {
            XsdImportNodeData ic = (XsdImportNodeData)data;
            String s = ic.getSchemaLocation();
            if (s == null) {
                ic.setSchemaLocation(value);
                this.nodeChanged();
                this.viewResult();
            } else if (!s.equals(value)) {
                File f;
                if (this.parentPanel.hasNameWithoutSelectSameParent(68, value)) {
                    JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdImportPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                    this.nameField.setText(s);
                    return false;
                }
                if (ic.getNamespace() == null || ic.getNamespace().equals("")) {
                    JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdImportPanel.getMessage("REQUIRED_DECL", XsdImportPanel.getMessage("TL_NAMESPACE")));
                    return false;
                }
                XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
                String parentPath = null;
                String fileName = this.parentPanel.getFrame().getTitle().substring(12);
                if (fileName.startsWith("file:/") && (f = new File(fileName.substring(6))).exists()) {
                    parentPath = f.getParent();
                }
                if (xsd.createExternalXSDDocument(ic.getNamespace(), value, parentPath)) {
                    this.parentPanel.checkExternalXsd(s, true);
                    ic.setSchemaLocation(value);
                    this.nodeChanged();
                    this.viewResult();
                } else {
                    JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdImportPanel.getMessage("INVALID_URL", new Object[]{value}));
                    this.nameField.setText(s);
                    return false;
                }
            }
        }
        return true;
    }

    boolean nsChanged(String value) {
        Object data = this.node.getUserObject();
        if (data instanceof XsdImportNodeData) {
            XsdImportNodeData ic = (XsdImportNodeData)data;
            String s = ic.getNamespace();
            if (s == null || s.equals("")) {
                ic.setNamespace(value);
                this.nodeChanged();
                this.viewResult();
            } else if (!s.equals(value)) {
                ic.setNamespace(value);
                this.nodeChanged();
                this.viewResult();
            }
            if (ic.getNamespace() == null || ic.getNamespace().equals("")) {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdImportPanel.getMessage("REQUIRED_DECL", XsdImportPanel.getMessage("TL_NAMESPACE")));
                this.nameField.setEnabled(false);
                return false;
            }
            this.nameField.setEnabled(true);
        }
        return true;
    }

    void viewResult() {
        XsdImport declnode = XSDEditorPanel.createImport(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        XsdImportNodeData imp = (XsdImportNodeData)node.getUserObject();
        this.nsField.setText(imp.getNamespace());
        this.nameField.setText(imp.getSchemaLocation());
        this.revalidate();
        this.nameField.setEnabled(true);
        if (imp.getNamespace() == null || imp.getNamespace().equals("")) {
            this.nameField.setEnabled(false);
        }
        if (this.parentPanel.checkAlreadyUseExternalXsd(node)) {
            this.nsField.setEnabled(false);
            this.nameField.setEnabled(false);
        }
        this.viewResult();
    }
}

