/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdIncludeNodeData;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdInclude;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdIncludePanel
extends XsdContentsEditPanel {
    private TextFieldEx nameField;
    private JPanel typePanel;
    private XSDResultPanel result;

    XsdIncludePanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(XsdIncludePanel.getMessage("TL_INCLUDE")));
        JLabel label = new JLabel(XsdIncludePanel.getMessage("LAB_SCHEMALOCATION"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object Source2, String value) {
                XsdIncludePanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    boolean nameChanged(String value) {
        XsdIncludeNodeData ic;
        String s;
        Object data = this.node.getUserObject();
        if (data instanceof XsdIncludeNodeData && !(s = (ic = (XsdIncludeNodeData)data).getSchemaLocation()).equals(value)) {
            File f;
            if (this.parentPanel.hasNameWithoutSelectSameParent(69, value)) {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdIncludePanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                this.nameField.setText(s);
                return false;
            }
            XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
            String parentPath = null;
            String fileName = this.parentPanel.getFrame().getTitle().substring(12);
            if (fileName.startsWith("file:/") && (f = new File(fileName.substring(6))).exists()) {
                parentPath = f.getParent();
            }
            if (xsd.createExternalXSDDocument(xsd.getNameSpace(), value, parentPath)) {
                this.parentPanel.checkExternalXsd(s, true);
                ic.setSchemaLocation(value);
                this.nodeChanged();
                this.viewResult();
            } else {
                JOptionPane.showMessageDialog(this.parentPanel.getFrame(), XsdIncludePanel.getMessage("INVALID_URL", new Object[]{value}));
                this.nameField.setText(s);
                return false;
            }
        }
        return true;
    }

    void viewResult() {
        XsdInclude declnode = XSDEditorPanel.createInclude(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        XsdIncludeNodeData inc = (XsdIncludeNodeData)node.getUserObject();
        this.nameField.setText(inc.getSchemaLocation());
        this.revalidate();
        if (this.parentPanel.checkAlreadyUseExternalXsd(node)) {
            this.nameField.setEnabled(false);
        }
        this.viewResult();
    }
}

