/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.jxp.vxsd.ContentModelNodeData;
import com.argo21.jxp.vxsd.SimpleTypeNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdListNodeData;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdList;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdListPanel
extends XsdContentsEditPanel {
    private JPanel basePanel;
    private ComboTextFieldEx itemCombo;
    private XSDResultPanel result;

    XsdListPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        if (parentPanel.getExtendEnabled()) {
            // empty if block
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new GridBagLayout());
        this.basePanel.setOpaque(true);
        this.basePanel.setBorder(BorderFactory.createTitledBorder(XsdListPanel.getMessage("TL_LIST")));
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.basePanel.add((Component)new JLabel(XsdListPanel.getMessage("LAB_ITEM_TYPE")), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 0;
        JPanel rd = new JPanel();
        rd.setLayout(new GridLayout(1, 2));
        this.itemCombo = new ComboTextFieldEx(false){

            @Override
            public boolean valueChanged(Object source, String value) {
                if (value != null) {
                    XsdListPanel.this.itemTypeChanged(value.trim());
                }
                return true;
            }
        };
        rd.add((Component)this.itemCombo, c);
        this.basePanel.add((Component)rd, c);
        this.add((Component)this.basePanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void initItemCombo() {
        this.basePanel.setVisible(true);
        this.revalidate();
        Vector<String> vet = new Vector<String>();
        DefaultMutableTreeNode node1 = null;
        try {
            node1 = (DefaultMutableTreeNode)this.node.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node1 != null) {
            Object data1 = node1.getUserObject();
            if (data1 instanceof ContentModelNodeData) {
                ContentModelNodeData cmdata = (ContentModelNodeData)data1;
                if (cmdata.getType() == 0) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalComplexType(vet);
                } else if (cmdata.getType() == 1) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
                }
            } else if (data1 instanceof SimpleTypeNodeData) {
                ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
            }
        }
        vet.addElement(XsdListPanel.getMessage("LAB_NONE"));
        this.itemCombo.setEnabledEvent(false);
        this.itemCombo.setList(vet);
        this.itemCombo.setEnabledEvent(true);
    }

    void itemTypeChanged(String value) {
        XsdListNodeData data = (XsdListNodeData)this.node.getUserObject();
        String selectedString = this.itemCombo.getText();
        if (selectedString.equals(XsdListPanel.getMessage("LAB_NONE"))) {
            data.setItemType(null);
        } else {
            XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
            XsdTypeRef baseType = data.getItemType();
            if (baseType == null) {
                baseType = xsd.findTypeReference(selectedString, 62, 2, true);
            } else {
                xsd.findTypeReference(baseType, selectedString, 62, 2, true);
            }
            data.setItemType(baseType);
        }
        this.revalidate();
        this.nodeChanged();
        this.viewResult();
    }

    void viewResult() {
        XsdList deriDecl = XSDEditorPanel.createList(null, this.node);
        String rs = deriDecl == null ? "" : deriDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object o = node.getUserObject();
        if (o instanceof XsdListNodeData) {
            XsdListNodeData data = (XsdListNodeData)o;
            this.initItemCombo();
            this.itemCombo.setEnabledEvent(false);
            if (data != null) {
                XsdTypeRef typeref = data.getItemType();
                if (typeref != null) {
                    if (typeref.isTypeNode()) {
                        String name2 = ((XSDDocument)this.parentPanel.xsd).getTyperefNameAdditionPrefix(typeref.getXsdDecl().getNameSpace(), typeref.getNodeString());
                        this.itemCombo.setText(name2);
                    }
                } else {
                    this.itemCombo.setText(XsdListPanel.getMessage("LAB_NONE"));
                }
            }
            this.itemCombo.setEnabledEvent(true);
            if (this.parentPanel.getChildNodeInvalid(node, 53)) {
                this.itemCombo.setEnabled(false);
            }
            this.viewResult();
        }
    }
}

