/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdNotationDeclNodeData;
import com.argo21.jxp.xsd.XsdNotationDecl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdNotationDeclPanel
extends XsdContentsEditPanel {
    private TextFieldEx nameField;
    private JRadioButton[] typeOption = new JRadioButton[2];
    private TextFieldEx publicField;
    private TextFieldEx systemField;
    private XSDResultPanel result;

    XsdNotationDeclPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(XsdNotationDeclPanel.getMessage("TL_NOTATION")));
        JLabel label = new JLabel(XsdNotationDeclPanel.getMessage("LAB_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object source, String value) {
                XsdNotationDeclPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder(XsdNotationDeclPanel.getMessage("TL_NOTATION_TYPE")));
        tp.setLayout(new GridBagLayout());
        ButtonGroup group = new ButtonGroup();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.typeOption[0] = new JRadioButton(XsdNotationDeclPanel.getMessage("LAB_SYSTEM"));
        tp.add((Component)this.typeOption[0], c);
        ++c.gridy;
        this.typeOption[1] = new JRadioButton(XsdNotationDeclPanel.getMessage("LAB_PUBLIC"));
        tp.add((Component)this.typeOption[1], c);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XsdNotationDeclPanel.this.typeChanged(e);
            }
        };
        for (int i = 0; i < 2; ++i) {
            group.add(this.typeOption[i]);
            this.typeOption[i].setFont(this.getDefaultFont());
            this.typeOption[i].addActionListener(al);
        }
        this.add((Component)tp, gc);
        ++gc.gridy;
        tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(XsdNotationDeclPanel.getMessage("TL_CONTENTS")));
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        label = new JLabel(XsdNotationDeclPanel.getMessage("LAB_PUBLIC"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.publicField = new TextFieldEx(16){

            @Override
            public boolean valueChanged(Object source, String value) {
                XsdNotationDeclPanel.this.publicChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.publicField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(XsdNotationDeclPanel.getMessage("LAB_REF_URL"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.systemField = new TextFieldEx(16){

            @Override
            public boolean valueChanged(Object source, String value) {
                XsdNotationDeclPanel.this.refChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.systemField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void nameChanged(String value) {
        XsdNotationDeclNodeData data = (XsdNotationDeclNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, XsdNotationDeclPanel.getMessage("INVALID_NAME", value));
                this.nameField.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelect(12, value)) {
                JOptionPane.showMessageDialog(this.parentPanel, XsdNotationDeclPanel.getMessage("DOUBLE_NAME", value));
                this.nameField.setText(s);
                return;
            }
            this.nameChangedTo(value);
            this.viewResult();
        }
    }

    void typeChanged(ActionEvent e) {
        JRadioButton opt = (JRadioButton)e.getSource();
        if (opt.isSelected()) {
            if (opt == this.typeOption[0]) {
                this.typeChanged(1);
            } else {
                this.typeChanged(2);
            }
            this.contentsChanged();
        }
    }

    void typeChanged(int type) {
        XsdNotationDeclNodeData data = (XsdNotationDeclNodeData)this.node.getUserObject();
        if (type == 1) {
            this.publicField.setEnabled(false);
            data.setType(1);
        } else {
            this.publicField.setEnabled(true);
            data.setType(2);
        }
        this.viewResult();
    }

    void refChanged(String value) {
        XsdNotationDeclNodeData data = (XsdNotationDeclNodeData)this.node.getUserObject();
        try {
            data.setSystemId(value);
            this.contentsChanged();
            this.viewResult();
        }
        catch (Exception e) {
            String s = XsdNotationDeclPanel.getMessage("INVALID_URL", value) + "\n" + e.getMessage();
            JOptionPane.showMessageDialog(this.parentPanel, s);
        }
    }

    void publicChanged(String value) {
        XsdNotationDeclNodeData data = (XsdNotationDeclNodeData)this.node.getUserObject();
        if (!this.isPublicId(value)) {
            JOptionPane.showMessageDialog(this.parentPanel, XsdNotationDeclPanel.getMessage("INVALID_PUBLICID"));
            return;
        }
        data.setPublicId(value);
        this.contentsChanged();
        this.viewResult();
    }

    void viewResult() {
        XsdNotationDecl declnode = XSDEditorPanel.createNotationDecl(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        XsdNotationDeclNodeData data = (XsdNotationDeclNodeData)node.getUserObject();
        this.node = node;
        this.nameField.setText(data.getNodeName());
        this.publicField.setText(data.getPublicId());
        this.systemField.setText(data.getSystemId());
        if (data.getType() == 1) {
            this.typeOption[0].setSelected(true);
        } else {
            this.typeOption[1].setSelected(true);
        }
        this.typeChanged(data.getType());
        this.viewResult();
    }

    boolean isPublicId(String s) {
        if (s.length() < 7) {
            return false;
        }
        if (s.charAt(0) != '+' && s.charAt(0) != '-') {
            return false;
        }
        if (s.charAt(1) != '/' || s.charAt(2) != '/') {
            return false;
        }
        int k = s.indexOf("//", 3);
        if (k < 0) {
            return false;
        }
        return (k = s.indexOf("//", k + 2)) > 0;
    }
}

