/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.vxsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.jxp.vxsd.ContentModelNodeData;
import com.argo21.jxp.vxsd.SimpleTypeNodeData;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XSDResultPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.vxsd.XsdUnionNodeData;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdTypeRef;
import com.argo21.jxp.xsd.XsdUnion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

class XsdUnionPanel
extends XsdContentsEditPanel {
    private JPanel typePanel;
    private JList memberList;
    private ComboTextFieldEx dataTypeCombo;
    private JButton delButton;
    private XSDResultPanel result;

    XsdUnionPanel() {
    }

    @Override
    public void init(XSDEditorPanel parentPanel) {
        this.parentPanel = parentPanel;
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        Font defaultFont = this.getDefaultFont();
        this.typePanel = new JPanel();
        this.typePanel.setLayout(new GridBagLayout());
        this.typePanel.setBorder(BorderFactory.createTitledBorder(XsdUnionPanel.getMessage("TL_UNION")));
        c.weightx = 1.0;
        this.typePanel.add((Component)new JLabel(XsdUnionPanel.getMessage("TL_DATATYPE")), c);
        ++c.gridx;
        c.weightx = 10.0;
        c.gridwidth = 0;
        this.dataTypeCombo = new ComboTextFieldEx(false);
        this.typePanel.add((Component)this.dataTypeCombo, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(0, 2, 0, 2);
        this.typePanel.add((Component)this.getAddDelBtnPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.gridheight = 2;
        c.insets = new Insets(2, 2, 2, 2);
        this.memberList = new JList(new DefaultListModel());
        this.memberList.setFont(new Font(this.memberList.getFont().getName(), 0, 11));
        this.memberList.setBackground(Color.white);
        this.memberList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                XsdUnionPanel.this.memberListChanged();
            }
        });
        JScrollPane memberListScroll = new JScrollPane(this.memberList);
        memberListScroll.setPreferredSize(new Dimension(100, 120));
        this.typePanel.add((Component)memberListScroll, c);
        this.add((Component)this.typePanel, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new XSDResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    private JPanel getAddDelBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 20, 0));
        JButton addButton = new JButton(ImageLoader.load("todown.gif", "Down"));
        addButton.setMargin(new Insets(0, 0, 0, 0));
        addButton.setBorder(null);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XsdUnionPanel.this.addMember();
            }
        });
        panel.add(addButton);
        this.delButton = new JButton(ImageLoader.load("toup.gif", "Up"));
        this.delButton.setMargin(new Insets(0, 0, 0, 0));
        this.delButton.setBorder(null);
        this.delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XsdUnionPanel.this.delMember();
            }
        });
        panel.add(this.delButton);
        return panel;
    }

    void addMember() {
        String addValue = this.dataTypeCombo.getText();
        DefaultListModel model = (DefaultListModel)this.memberList.getModel();
        model.addElement(addValue);
        this.memberListChanged();
        XsdUnionNodeData data = (XsdUnionNodeData)this.node.getUserObject();
        XSDDocument xsd = (XSDDocument)this.parentPanel.xsd;
        XsdTypeRef type = xsd.findTypeReference(addValue, 62, 2, true);
        Vector v = data.getMemberTypeVector();
        v.addElement(type);
        this.nodeChanged();
        this.viewResult();
    }

    void delMember() {
        int index = this.memberList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.memberList.getModel();
        String typeName = (String)model.getElementAt(index);
        model.remove(index);
        XsdUnionNodeData data = (XsdUnionNodeData)this.node.getUserObject();
        Vector v = data.getMemberTypeVector();
        v.remove(index);
        this.nodeChanged();
        this.viewResult();
    }

    void memberListChanged() {
        if (this.memberList.getModel().getSize() > 0) {
            this.delButton.setEnabled(true);
        } else {
            this.delButton.setEnabled(false);
        }
    }

    void viewResult() {
        XsdUnion scDecl = XSDEditorPanel.createUnion(null, this.node);
        String rs = scDecl == null ? "" : scDecl.toString();
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        Object o = node.getUserObject();
        if (o instanceof XsdUnionNodeData) {
            XsdUnionNodeData data = (XsdUnionNodeData)o;
            DefaultListModel model = (DefaultListModel)this.memberList.getModel();
            model.clear();
            if (data.getMemberTypeVector() == null) {
                data.setMemberTypeVector(new Vector());
            } else {
                for (XsdTypeRef typeref : data.getMemberTypeVector()) {
                    if (typeref == null || !typeref.isTypeNode()) continue;
                    String name2 = ((XSDDocument)this.parentPanel.xsd).getTyperefNameAdditionPrefix(typeref.getXsdDecl().getNameSpace(), typeref.getNodeString());
                    model.addElement(name2);
                }
            }
            this.initDataTypeCombo();
            this.viewResult();
        }
    }

    void initDataTypeCombo() {
        this.revalidate();
        Vector vet = new Vector();
        DefaultMutableTreeNode node1 = null;
        try {
            node1 = (DefaultMutableTreeNode)this.node.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node1 != null) {
            Object data1 = node1.getUserObject();
            if (data1 instanceof ContentModelNodeData) {
                ContentModelNodeData cmdata = (ContentModelNodeData)data1;
                if (cmdata.getType() == 0) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalComplexType(vet);
                } else if (cmdata.getType() == 1) {
                    ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                    ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
                }
            } else if (data1 instanceof SimpleTypeNodeData) {
                ((XSDDocument)this.parentPanel.xsd).getExternalBuiltinDataType(vet);
                ((XSDDocument)this.parentPanel.xsd).getExternalGlobalSimpleType(vet);
            }
        }
        this.dataTypeCombo.setList(vet);
    }
}

