/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDouble;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.xml.sax.SAXException;

public class AdditiveExpr
implements Expr {
    Expr l_expr;
    Expr r_expr;
    int op;

    AdditiveExpr(int op, Expr l_expr, Expr r_expr) {
        this.op = op;
        this.l_expr = l_expr;
        this.r_expr = r_expr;
    }

    @Override
    public int getType() {
        return this.op;
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        XData obj1 = this.l_expr.eval(context, surpport);
        double num1 = obj1.doubleValue();
        switch (this.op) {
            case 10: {
                XData obj2 = this.r_expr.eval(context, surpport);
                double num2 = obj2.doubleValue();
                return new XDouble(num1 + num2);
            }
            case 11: {
                XData obj2 = this.r_expr.eval(context, surpport);
                double num2 = obj2.doubleValue();
                return new XDouble(num1 - num2);
            }
            case 16: {
                return new XDouble(-num1);
            }
        }
        return new XDouble(0.0);
    }

    public String toString() {
        switch (this.op) {
            case 10: {
                return this.l_expr.toString() + " + " + this.r_expr.toString();
            }
            case 11: {
                return this.l_expr.toString() + " - " + this.r_expr.toString();
            }
            case 16: {
                return " - " + this.l_expr.toString();
            }
        }
        return "";
    }
}

