/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.AttDefault;
import com.argo21.jxp.dtd.AttType;
import com.argo21.jxp.dtd.Children;
import com.argo21.jxp.dtd.ContentParticle;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.dtd.ElementDeclNode;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathParser;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DTDXPathSurpport
extends DefaultXPathSurpport {
    private DTDDecl dtd;
    private Hashtable pendingDecls = new Hashtable();
    private int serialNumber = 1;

    public DTDXPathSurpport(DTDDecl dtd, Document doc) {
        super(doc);
        this.dtd = dtd;
    }

    @Override
    protected void supplementAttr(Node parent, String name2) throws SAXException {
        if (parent == this.doc) {
            return;
        }
        if (parent.getNodeType() != 1) {
            return;
        }
        Element element = (Element)parent;
        String tag = parent.getNodeName();
        AttDef attdef = this.dtd.getAttListDecl(tag, name2);
        if (attdef == null) {
            return;
        }
        AttType typedecl = attdef.getAttType();
        AttDefault defaultdecl = attdef.getAttDefault();
        String value = null;
        int valuetype = defaultdecl.getType();
        if (valuetype == 2 || valuetype == 3) {
            DataTypeDecl dt = attdef.getDataTypeDecl();
            if (dt != null) {
                value = dt.formatValue();
            }
        } else {
            value = defaultdecl.getValue();
        }
        if (value == null) {
            value = "";
        }
        element.setAttribute(name2, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void supplementElements(Node parent, String name2, int count2, int first) throws SAXException {
        if (this.doc == null) {
            this.doc = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        }
        if (parent == this.doc) {
            ElementDeclNode elem = (ElementDeclNode)this.dtd.getElementDecl(name2);
            if (elem == null) {
                String s = XPathParser.msgCatalog.getMessage("INVALID_ELEM", new Object[]{parent.getNodeName(), name2});
                XPathException e = new XPathException(s, "", "", 0, 0);
                e.msgID = "INVALID_ELEM";
                throw e;
            }
            Element node = this.doc.createElement(name2);
            parent.appendChild(node);
            this.addRelationNode(node);
            return;
        }
        if (parent.getNodeType() != 1) {
            String s = XPathParser.msgCatalog.getMessage("INVALID_ELEM", new Object[]{parent.getNodeName(), name2});
            XPathException e = new XPathException(s, "", "", 0, 0);
            e.msgID = "INVALID_ELEM";
            throw e;
        }
        ElementDecl elem = this.dtd.getElementDecl(name2);
        ElementDecl parentDecl = this.dtd.getElementDecl(parent.getNodeName());
        int type = parentDecl.getType();
        if (type == 1) {
            int i = 0;
            while (i < count2) {
                Element node = this.doc.createElement(name2);
                parent.appendChild(node);
                this.addRelationNode(node);
                ++i;
            }
            return;
        }
        if (type != 2) {
            if (type != 3) return;
            this.supplementByPendingDecl((Element)parent, name2, count2, first);
            return;
        }
        Vector v = parentDecl.getChildNames();
        if (!v.contains(name2)) {
            String s = XPathParser.msgCatalog.getMessage("INVALID_ELEM", new Object[]{parent.getNodeName(), name2});
            XPathException e = new XPathException(s, "", "", 0, 0);
            e.msgID = "INVALID_ELEM";
            throw e;
        }
        int i = 0;
        while (i < count2) {
            Element node = this.doc.createElement(name2);
            parent.appendChild(node);
            this.addRelationNode(node);
            ++i;
        }
    }

    protected void supplementByPendingDecl(Element parent, String name2, int count2, int first) throws SAXException {
        NodeList nl = parent.getChildNodes();
        int index = first;
        while (index < nl.getLength() && count2 != 0) {
            int occ;
            Node node = nl.item(index);
            if (node.getNodeType() != 8) {
                ++index;
                continue;
            }
            String ref = node.getNodeValue();
            Object obj = this.pendingDecls.get(ref);
            if (obj == null) {
                ++index;
                continue;
            }
            if (obj instanceof Children) {
                Children ch = (Children)obj;
                if (!ch.containsTag(name2)) {
                    ++index;
                    continue;
                }
                occ = ch.getOccurrence();
                Vector list = ch.getCPList();
                int n = list.size();
                if (n == 1 || ch.getType() == 1) {
                    if (occ == 0) {
                        ++index;
                        continue;
                    }
                    for (int i = 0; i < n; ++i) {
                        ContentParticle cp = (ContentParticle)list.elementAt(i);
                        Children ch1 = cp.getChildren();
                        if (ch1 != null) {
                            this.addRelationChildFromContents(parent, ch1, node);
                            continue;
                        }
                        String name1 = cp.getName();
                        Element elem = this.doc.createElement(name1);
                        parent.insertBefore(elem, node);
                        this.addRelationNode(elem);
                        if (!name2.equals(name1)) continue;
                        --count2;
                    }
                    if (occ != 63) continue;
                    parent.removeChild(node);
                    this.pendingDecls.remove(ref);
                    continue;
                }
                boolean found = false;
                for (int i = 0; i < n; ++i) {
                    ContentParticle cp = (ContentParticle)list.elementAt(i);
                    Children ch1 = cp.getChildren();
                    if (ch1 != null) {
                        if (!ch1.containsTag(name2)) continue;
                        this.addRelationChildFromContents(parent, ch1, node);
                        found = true;
                        break;
                    }
                    String name1 = cp.getName();
                    if (!name2.equals(name1)) continue;
                    Element elem = this.doc.createElement(name1);
                    this.addRelationNode(elem);
                    parent.insertBefore(elem, node);
                    --count2;
                    found = true;
                    break;
                }
                if (occ == 0 || occ == 63) {
                    parent.removeChild(node);
                    this.pendingDecls.remove(ref);
                }
                if (found) continue;
                ++index;
                continue;
            }
            ContentParticle cp = (ContentParticle)obj;
            if (!name2.equals(cp.getName())) {
                ++index;
                continue;
            }
            occ = cp.getOccurrence();
            if (occ == 42 || occ == 43) {
                for (int i = 0; i < count2; ++i) {
                    Element elem = this.doc.createElement(name2);
                    parent.insertBefore(elem, node);
                    this.addRelationNode(elem);
                }
                return;
            }
            Element elem = this.doc.createElement(name2);
            parent.replaceChild(elem, node);
            this.pendingDecls.remove(ref);
            this.addRelationNode(elem);
            --count2;
            ++index;
        }
    }

    private void addRelationNode(Element element) {
        Children children;
        ElementDecl elemdecl = this.dtd.getElementDecl(element.getNodeName());
        if (elemdecl == null) {
            return;
        }
        int type = elemdecl.getType();
        if (type == 2) {
            DataTypeDecl dt = elemdecl.getDataTypeDecl();
            String defValue = "";
            if (dt != null) {
                try {
                    defValue = dt.formatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            element.appendChild(this.doc.createTextNode(defValue));
        } else if (type == 3 && (children = elemdecl.getChildren()) != null) {
            this.addRelationChildFromContents(element, children, null);
        }
        DeclNodeList attlists = elemdecl.getAttListDecls();
        int n = attlists.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            AttDef attdef = (AttDef)attlists.item(i);
            AttDefault adf = attdef.getAttDefault();
            int valuetype = adf.getType();
            if (valuetype == 3) {
                value = adf.getValue();
                if (value == null) {
                    DataTypeDecl dt = attdef.getDataTypeDecl();
                    if (dt != null) {
                        try {
                            value = dt.formatValue();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (value == null) {
                        value = "";
                    }
                }
                element.setAttribute(attdef.getAttributeName(), value);
                continue;
            }
            if (valuetype != 1) continue;
            value = adf.getValue();
            if (value == null) {
                value = "";
            }
            element.setAttribute(attdef.getAttributeName(), value);
        }
    }

    private void pending(Element element, Object decl, Node ref) {
        String key = "{{" + this.serialNumber + "}}";
        Comment cm = this.doc.createComment(key);
        if (ref != null) {
            element.insertBefore(cm, ref);
        } else {
            element.appendChild(cm);
        }
        this.pendingDecls.put(key, decl);
        ++this.serialNumber;
    }

    private void addRelationChildFromContents(Element element, Children c, Node ref) {
        if (c.getCPList().size() > 1 && c.getType() == 0) {
            this.pending(element, c, ref);
            return;
        }
        int occ = c.getOccurrence();
        if (occ == 42 || occ == 63) {
            this.pending(element, c, ref);
            return;
        }
        Vector s1 = c.getCPList();
        for (int i = 0; i < s1.size(); ++i) {
            ContentParticle cp = (ContentParticle)s1.elementAt(i);
            Children c1 = cp.getChildren();
            if (c1 == null) {
                char occ1 = cp.getOccurrence();
                if (occ1 == '*' || occ1 == '?') {
                    this.pending(element, cp, ref);
                    continue;
                }
                String sname = cp.getName();
                Element node = this.doc.createElement(sname);
                element.appendChild(node);
                this.addRelationNode(node);
                if (occ1 != '+') continue;
                this.pending(element, cp, ref);
                continue;
            }
            this.addRelationChildFromContents(element, c1, ref);
        }
        if (occ == 43) {
            this.pending(element, c, ref);
        }
    }

    @Override
    public boolean check(String parent, String name2, int index) {
        ElementDecl elem = this.dtd.getElementDecl(parent);
        if (elem == null) {
            return false;
        }
        if (name2.startsWith("@")) {
            return elem.getAttListDecl(name2 = name2.substring(1)) != null;
        }
        int type = elem.getType();
        int num = this.getOccurrence(elem, name2);
        return num >= index;
    }

    @Override
    public DataTypeDecl getTypeDecl(String parent, String name2) {
        if (name2.startsWith("@")) {
            AttDef att = this.dtd.getAttListDecl(parent, name2 = name2.substring(1));
            DataTypeDecl decl = att.getDataTypeDecl();
            if (decl == null) {
                decl = DataTypeDecl.getDefaultDataTypeDecl();
            }
            return decl;
        }
        ElementDecl elem = this.dtd.getElementDecl(name2);
        if (elem == null) {
            return null;
        }
        if (elem.getType() == 2) {
            DataTypeDecl decl = elem.getDataTypeDecl();
            if (decl == null) {
                decl = DataTypeDecl.getDefaultDataTypeDecl();
            }
            return decl;
        }
        return null;
    }

    public void terminateDocument() {
        Element elem = this.doc.getDocumentElement();
        if (elem != null) {
            this.removePendingRef(elem);
        }
    }

    private void removePendingRef(Element elem) {
        NodeList nl = elem.getChildNodes();
        int n = nl.getLength();
        int k = 0;
        while (k < n) {
            Node item = nl.item(k);
            short type = item.getNodeType();
            if (type == 8) {
                String key = item.getNodeValue();
                if (this.pendingDecls.containsKey(key)) {
                    elem.removeChild(item);
                    --n;
                    continue;
                }
            } else if (type == 1) {
                this.removePendingRef((Element)item);
            }
            ++k;
        }
    }

    protected int getOccurrence(ElementDecl elemdecl, String tagname) {
        switch (elemdecl.getType()) {
            case 1: {
                return 10000000;
            }
            case 0: {
                return 0;
            }
            case 2: {
                Vector v = elemdecl.getChildNames();
                if (v.isEmpty()) {
                    return 0;
                }
                if (v.contains(tagname)) {
                    return 10000000;
                }
            }
            case 3: {
                Children c = elemdecl.getChildren();
                if (c == null) break;
                return this.getOccurrence(c, tagname);
            }
        }
        return 0;
    }

    protected int getOccurrence(Children c, String tagname) {
        int occurrence = c.getOccurrence();
        Vector s1 = c.getCPList();
        for (int i = 0; i < s1.size(); ++i) {
            ContentParticle cp = (ContentParticle)s1.elementAt(i);
            Children c1 = cp.getChildren();
            if (c1 == null) {
                if (!tagname.equals(cp.getName())) continue;
                char tagoccurrence = cp.getOccurrence();
                if (tagoccurrence == '+' || occurrence == 43) {
                    return 10000000;
                }
                if (tagoccurrence == '*' || occurrence == 42) {
                    return 10000000;
                }
                return 1;
            }
            int childOccurrence = this.getOccurrence(c1, tagname);
            if (childOccurrence == 0) continue;
            if (occurrence == 42 || occurrence == 43) {
                return 10000000;
            }
            return childOccurrence;
        }
        return 0;
    }
}

