/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.util.BizTranCache;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathSurpport;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultXPathSurpport
implements XPathSurpport {
    private static int order = 0;
    protected boolean extendable = true;
    protected int defaultNumber = 1;
    protected Document doc;
    protected VariableReference variableReference;

    public DefaultXPathSurpport() {
        this.doc = null;
    }

    public DefaultXPathSurpport(Document doc) {
        this.doc = doc;
    }

    public void reset() {
        if (this.doc != null) {
            Node node;
            while ((node = this.doc.getFirstChild()) != null) {
                this.doc.removeChild(node);
            }
        }
        order = 0;
        this.defaultNumber = 1;
    }

    @Override
    public boolean isVariable(String name2) {
        return this.variableReference == null ? false : this.variableReference.definedVariable(name2);
    }

    @Override
    public XData getVariableData(String name2) {
        return this.variableReference == null ? null : this.variableReference.getData(name2);
    }

    @Override
    public Document getDocument() {
        return this.doc;
    }

    @Override
    public void setDocument(Document doc) {
        this.doc = doc;
    }

    @Override
    public void getElementNodeList(Node parent, String name2, int first, int last2, NodeListImpl results, boolean isList) throws SAXException {
        String pName;
        String curName;
        Node cur;
        String curName2;
        Node cur2;
        String bakPath = first > 0 ? BizTranCache.getXPath().replaceAll("\\[\\d+\\]", "") : BizTranCache.getXPath().replaceAll("\\[\\d+\\]", "").concat("/").concat(name2);
        NodeList nl = parent.getChildNodes();
        int count2 = nl.getLength();
        int num = 0;
        int pos = 0;
        int j = BizTranCache.getLine(bakPath, first) - 1;
        boolean textNodeFlag = false;
        while (j > -1 && (cur2 = nl.item(j)) != null) {
            curName2 = null;
            curName2 = cur2.getLocalName() == null ? cur2.getNodeName() : cur2.getLocalName();
            if ("#text".equals(curName2)) {
                --j;
                textNodeFlag = true;
                continue;
            }
            if (!curName2.equals(name2)) break;
            --j;
        }
        if (j < 0) {
            j = 0;
        } else {
            ++j;
            if (textNodeFlag) {
                ++j;
            }
        }
        while (j < count2) {
            cur2 = nl.item(j);
            curName2 = null;
            curName2 = cur2.getLocalName() == null ? cur2.getNodeName() : cur2.getLocalName();
            if (cur2.getNodeType() == 1 && curName2.equals(name2)) {
                if (num >= first) {
                    results.addElement(cur2);
                    if (num != 0 || isList) {
                        curName2 = curName2.concat("[").concat(String.valueOf(num)).concat("]");
                    }
                    BizTranCache.setXPath(curName2);
                    BizTranCache.setNode(cur2);
                    if (BizTranCache.getLine(bakPath, first) == 0) {
                        BizTranCache.setLine(bakPath, first, j);
                    }
                }
                pos = j + 1;
                if (++num > last2) break;
            }
            ++j;
        }
        if (num == 0) {
            for (int i = 0; i < BizTranCache.getLine(bakPath, first) && (cur = nl.item(i)) != null; ++i) {
                curName = null;
                curName = cur.getLocalName() == null ? cur.getNodeName() : cur.getLocalName();
                if (cur.getNodeType() != 1 || !curName.equals(name2)) continue;
                if (num >= first) {
                    results.addElement(cur);
                    if (num != 0 || isList) {
                        curName = curName.concat("[").concat(String.valueOf(num)).concat("]");
                    }
                    BizTranCache.setXPath(curName);
                    BizTranCache.setNode(cur);
                    BizTranCache.setLine(bakPath, first, i);
                }
                pos = i + 1;
                if (++num > last2) break;
            }
        }
        if (results.getLength() == 0 && name2.equals(pName = parent.getLocalName() == null ? parent.getNodeName() : parent.getLocalName())) {
            results.addElement(parent);
            return;
        }
        if (last2 >= num && this.isExtendable()) {
            this.supplementElements(parent, name2, last2 + 1 - num, pos);
            nl = parent.getChildNodes();
            count2 = nl.getLength();
            for (int i = pos; i < count2; ++i) {
                cur = nl.item(i);
                curName = null;
                curName = cur.getLocalName() == null ? cur.getNodeName() : cur.getLocalName();
                if (cur.getNodeType() != 1 || !curName.equals(name2)) continue;
                if (num >= first) {
                    results.addElement(cur);
                    if (num != 0 || isList) {
                        curName = curName.concat("[").concat(String.valueOf(num)).concat("]");
                    }
                    BizTranCache.setXPath(curName);
                    BizTranCache.setNode(cur);
                }
                if (++num > last2) break;
            }
        }
    }

    @Override
    public void getElementNodeList(Node parent, String name2, int max, NodeListImpl results) throws SAXException {
        String curName;
        Node cur;
        int i;
        String pname = parent.getNodeName();
        if (parent.getNodeType() == 1 && !this.check(pname, name2, 0)) {
            XPathException.fatal("INVALID_ELEM", new Object[]{pname, name2 + "[*]"}, null);
        }
        NodeList nl = parent.getChildNodes();
        int count2 = nl.getLength();
        int num = 0;
        int pos = 0;
        for (i = 0; i < count2; ++i) {
            cur = nl.item(i);
            curName = null;
            curName = cur.getLocalName() == null ? cur.getNodeName() : cur.getLocalName();
            if (cur.getNodeType() != 1 || !curName.equals(name2)) continue;
            results.addElement(cur);
            if (num != 0) {
                curName = curName.concat("[").concat(String.valueOf(num)).concat("]");
            }
            BizTranCache.setXPath(curName);
            BizTranCache.setNode(cur);
            ++num;
            pos = i + 1;
            if (i + 1 >= count2) continue;
            BizTranCache.popXPath();
        }
        if (num < max && this.isExtendable()) {
            this.supplementElements(parent, name2, max - num, pos);
            nl = parent.getChildNodes();
            count2 = nl.getLength();
            for (i = pos; i < count2; ++i) {
                cur = nl.item(i);
                curName = null;
                curName = cur.getLocalName() == null ? cur.getNodeName() : cur.getLocalName();
                if (cur.getNodeType() != 1 || !curName.equals(name2)) continue;
                results.addElement(cur);
                if (num != 0) {
                    curName = curName.concat("[").concat(String.valueOf(num)).concat("]");
                }
                BizTranCache.setXPath(curName);
                BizTranCache.setNode(cur);
                ++num;
                if (i + 1 < count2) {
                    BizTranCache.popXPath();
                }
                if (num >= max) break;
            }
        }
    }

    @Override
    public void getAttrNode(Node parent, String name2, NodeListImpl results) throws SAXException {
        Attr attr;
        String pname = null;
        pname = parent.getLocalName() == null ? parent.getNodeName() : parent.getLocalName();
        if (parent.getNodeType() == 1 && !this.check(pname, "@" + name2, 0)) {
            XPathException.fatal("INVALID_ATTR", new Object[]{pname, name2}, null);
        }
        if ((attr = ((Element)parent).getAttributeNode(name2)) != null) {
            results.addElement(attr);
            return;
        }
        if (this.isExtendable()) {
            this.supplementAttr(parent, name2);
            attr = ((Element)parent).getAttributeNode(name2);
            if (attr != null) {
                results.addElement(attr);
                return;
            }
        }
    }

    protected void supplementAttr(Node parent, String name2) throws SAXException {
        Element element = (Element)parent;
        element.setAttribute(name2, "");
    }

    protected void supplementElements(Node parent, String name2, int count2, int position2) throws SAXException {
        if (this.doc == null) {
            this.doc = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        }
        for (int i = 0; i < count2; ++i) {
            Element node = this.doc.createElement(name2);
            parent.appendChild(node);
        }
    }

    @Override
    public boolean check(String parent, String name2, int index) {
        return true;
    }

    @Override
    public DataTypeDecl getTypeDecl(String parent, String name2) {
        return DataTypeDecl.getDefaultDataTypeDecl();
    }

    @Override
    public int getDefaultNumber() {
        return this.isExtendable() ? this.defaultNumber : 10000000;
    }

    @Override
    public void setDefaultNumber(int defaultNumber) {
        this.defaultNumber = defaultNumber;
    }

    @Override
    public boolean isExtendable() {
        return this.extendable;
    }

    @Override
    public void setExtendable(boolean extendable) {
        this.extendable = extendable;
    }

    @Override
    public void setVariableReference(VariableReference ref) {
        this.variableReference = ref;
    }

    @Override
    public VariableReference getVariableReference() {
        return this.variableReference;
    }

    public static NodeListImpl sortNodesByDocumentOrder(NodeList nodelist, Document document) {
        int i;
        int n = nodelist.getLength();
        int[] indexes = new int[n];
        Node[] nodes = new Node[n];
        for (i = 0; i < n; ++i) {
            nodes[i] = nodelist.item(i);
            int index = DefaultXPathSurpport.nodeOrderOfDocument(nodes[i], document);
            if (index < 0) {
                index = 10000000;
            }
            indexes[i] = index;
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (indexes[i] <= indexes[j]) continue;
                Node tmp = nodes[i];
                nodes[i] = nodes[j];
                nodes[j] = tmp;
                int k = indexes[i];
                indexes[i] = indexes[j];
                indexes[j] = k;
            }
        }
        NodeListImpl res = new NodeListImpl(n);
        for (int i2 = 0; i2 < n; ++i2) {
            res.addElement(nodes[i2]);
        }
        return res;
    }

    public static int nodeOrderOfDocument(Node node, Document document) {
        int order = 0;
        if (DefaultXPathSurpport.nodeOrderOfDocument0(node, document)) {
            return order;
        }
        return -1;
    }

    private static boolean nodeOrderOfDocument0(Node node, Node parent) {
        for (Node node1 = parent.getFirstChild(); node1 != null; node1 = node1.getNextSibling()) {
            ++order;
            if (node.equals(node1)) {
                return true;
            }
            if (!node1.hasChildNodes()) {
                return false;
            }
            if (!DefaultXPathSurpport.nodeOrderOfDocument0(node, node1)) continue;
            return true;
        }
        return false;
    }
}

