/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FilterExpr
implements Expr {
    Expr expr;
    Expr[] predicaties;

    FilterExpr(Expr expr) {
        this.expr = expr;
    }

    @Override
    public int getType() {
        return 23;
    }

    void appendPredicate(Expr predicate) {
        if (this.predicaties == null) {
            this.predicaties = new Expr[1];
            this.predicaties[0] = predicate;
        } else {
            int n = this.predicaties.length;
            Expr[] temp = new Expr[n + 1];
            System.arraycopy(this.predicaties, 0, temp, 0, n);
            temp[n] = predicate;
            this.predicaties = temp;
        }
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        XData obj1 = this.expr.eval(context, surpport);
        NodeList nodeset1 = obj1.nodeset();
        for (int i = 0; i < this.predicaties.length; ++i) {
            NodeListImpl nset;
            int n = nodeset1.getLength();
            int j = 0;
            if (nodeset1 instanceof NodeListImpl) {
                nset = (NodeListImpl)nodeset1;
                while (j < n) {
                    XData obj2 = this.expr.eval(new XNode(nset.item(j)), surpport);
                    if (!obj2.booleanValue()) {
                        nset.removeElementAt(j);
                        --n;
                        continue;
                    }
                    ++j;
                }
                continue;
            }
            nset = new NodeListImpl();
            for (j = 0; j < n; ++j) {
                Node node2 = nset.item(j);
                XData obj2 = this.expr.eval(new XNode(node2), surpport);
                if (!obj2.booleanValue()) continue;
                nset.addNode(node2);
            }
            nodeset1 = nset;
        }
        return new XNodeSet(nodeset1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.expr.toString());
        if (this.predicaties != null) {
            for (int i = 0; i < this.predicaties.length; ++i) {
                sb.append('[');
                sb.append(this.predicaties[i].toString());
                sb.append(']');
            }
        }
        return sb.toString();
    }
}

