/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XInteger;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XString;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XNodeEx;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathSurpport;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FunctionExpr
implements Expr {
    public static final String FUNC_LAST = "last";
    public static final String FUNC_POSITION = "position";
    public static final String FUNC_COUNT = "count";
    public static final String FUNC_ID = "id";
    public static final String FUNC_IDREF = "idref";
    public static final String FUNC_KEY = "key";
    public static final String FUNC_KEYREF = "keyref";
    public static final String FUNC_DOC = "doc";
    public static final String FUNC_DOCUMENT = "document";
    public static final String FUNC_DOCREF = "docref";
    public static final String FUNC_LOCAL_NAME = "local-name";
    public static final String FUNC_NAMESPACE = "namespace-uri";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_GENERATE_ID = "generate-id";
    public static final String FUNC_NOT = "not";
    public static final String FUNC_TRUE = "true";
    public static final String FUNC_FALSE = "false";
    public static final String FUNC_BOOLEAN = "boolean";
    public static final String FUNC_LANG = "lang";
    public static final String FUNC_NUMBER = "number";
    public static final String FUNC_FLOOR = "floor";
    public static final String FUNC_CEILING = "ceiling";
    public static final String FUNC_ROUND = "round";
    public static final String FUNC_SUM = "sum";
    public static final String FUNC_STARTS = "string";
    public static final String FUNC_STARTS_WITH = "starts-with";
    public static final String FUNC_CONTAINS = "contains";
    public static final String FUNC_SUBSTRING_BEFORE = "substring-before";
    public static final String FUNC_SUBSTRING_AFTER = "substring-after";
    public static final String FUNC_NORMALIZE_SPACE = "normalize-space";
    public static final String FUNC_TRANSLATE = "translate";
    public static final String FUNC_CONCAT = "concat";
    public static final String FUNC_SYSTEM_PROPERTY = "system-property";
    public static final String FUNC_EXT_FUNCTION_AVAILABLE = "function-available";
    public static final String FUNC_EXT_ELEM_AVAILABLE = "element-available";
    public static final String FUNC_SUBSTRING = "substring";
    public static final String FUNC_LENGTH = "string-length";
    public static final String FUNC_UNPARSED_ENTITY_URI = "unparsed-entity-uri";
    public static final String FUNC_DOCLOCATION = "document-location";
    public static Hashtable functionTable = new Hashtable();
    protected String name;
    protected Expr[] parameters = new Expr[0];

    static void registFunction(String name2, Object cls) {
        functionTable.put(name2, cls);
    }

    static FunctionExpr getFunctionExpr(String name2) {
        Object cls = functionTable.get(name2);
        Class<?> clss = null;
        if (cls instanceof String) {
            String clsnm = (String)cls;
            if (clsnm.indexOf(".") < 0) {
                String s = FunctionExpr.class.getName();
                clsnm = s + "$" + clsnm;
            }
            try {
                clss = Class.forName(clsnm);
                functionTable.put(name2, clss);
            }
            catch (Exception e) {
                return null;
            }
        } else if (cls instanceof Class) {
            clss = (Class<?>)cls;
        }
        if (clss == null) {
            return null;
        }
        try {
            FunctionExpr expr = (FunctionExpr)clss.newInstance();
            expr.name = name2;
            return expr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    FunctionExpr() {
    }

    @Override
    public int getType() {
        return 25;
    }

    public void addParameter(Expr parameter) {
        if (this.parameters == null) {
            this.parameters = new Expr[1];
            this.parameters[0] = parameter;
        } else {
            Expr[] tmp = new Expr[this.parameters.length + 1];
            System.arraycopy(this.parameters, 0, tmp, 0, this.parameters.length);
            tmp[this.parameters.length] = parameter;
            this.parameters = tmp;
        }
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        return null;
    }

    public String getFunctionName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append('(');
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                sb.append(this.parameters[i].toString());
                if (i >= this.parameters.length - 1) continue;
                sb.append(',');
            }
        }
        sb.append(')');
        return sb.toString();
    }

    protected Node getFirstNodeInDocumentOrder(XData context, XPathSurpport surpport) throws SAXException {
        Node ref;
        XData param = this.parameters != null && this.parameters.length > 0 ? this.parameters[0].eval(context, surpport) : context;
        if (!param.isNode()) {
            XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
        }
        if (param.size() == 0) {
            return null;
        }
        if (param.size() > 1) {
            Document doc = param.nodeValue().getOwnerDocument();
            if (null == doc) {
                XPathException.fatal("NO_OWNERDOC", new Object[0], null);
            }
            NodeListImpl nodelist = DefaultXPathSurpport.sortNodesByDocumentOrder(((XNodeSet)param).nodeset(), doc);
            ref = nodelist.elementAt(0);
        } else {
            ref = param.nodeValue();
        }
        return ref;
    }

    public void check() throws XPathException {
        if (this.parameters != null && this.parameters.length > 0) {
            XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
        }
    }

    static {
        FunctionExpr.registFunction(FUNC_LAST, FUNC_LAST);
        FunctionExpr.registFunction(FUNC_POSITION, FUNC_POSITION);
        FunctionExpr.registFunction(FUNC_COUNT, FUNC_COUNT);
        FunctionExpr.registFunction(FUNC_ID, FUNC_ID);
        FunctionExpr.registFunction(FUNC_LOCAL_NAME, FUNC_LOCAL_NAME);
        FunctionExpr.registFunction(FUNC_NAMESPACE, FUNC_NAMESPACE);
        FunctionExpr.registFunction(FUNC_NAME, FUNC_NAME);
        FunctionExpr.registFunction(FUNC_STARTS, FUNC_STARTS);
        FunctionExpr.registFunction(FUNC_STARTS_WITH, FUNC_STARTS_WITH);
        FunctionExpr.registFunction(FUNC_CONTAINS, FUNC_CONTAINS);
        FunctionExpr.registFunction(FUNC_SUBSTRING_BEFORE, FUNC_SUBSTRING_BEFORE);
        FunctionExpr.registFunction(FUNC_SUBSTRING_AFTER, FUNC_SUBSTRING_AFTER);
        FunctionExpr.registFunction(FUNC_NORMALIZE_SPACE, FUNC_NORMALIZE_SPACE);
        FunctionExpr.registFunction(FUNC_TRANSLATE, FUNC_TRANSLATE);
        FunctionExpr.registFunction(FUNC_CONCAT, FUNC_CONCAT);
        String func = "booleanFunc";
        FunctionExpr.registFunction(FUNC_NOT, func);
        FunctionExpr.registFunction(FUNC_TRUE, func);
        FunctionExpr.registFunction(FUNC_FALSE, func);
        FunctionExpr.registFunction(FUNC_BOOLEAN, func);
        FunctionExpr.registFunction(FUNC_LANG, func);
        func = "numberFunc";
        FunctionExpr.registFunction(FUNC_NUMBER, func);
        FunctionExpr.registFunction(FUNC_FLOOR, func);
        FunctionExpr.registFunction(FUNC_CEILING, func);
        FunctionExpr.registFunction(FUNC_ROUND, func);
        FunctionExpr.registFunction(FUNC_SUM, func);
    }

    static class numberFunc
    extends FunctionExpr {
        numberFunc() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            if (this.name.equals(FunctionExpr.FUNC_NUMBER)) {
                XData param1 = this.parameters != null && this.parameters.length > 0 ? this.parameters[0].eval(context, surpport) : context;
                return new XDouble(param1.doubleValue());
            }
            if (this.name.equals(FunctionExpr.FUNC_SUM)) {
                XData param1 = this.parameters[0].eval(context, surpport);
                double d1 = 0.0;
                int n = param1.size();
                for (int i = 0; i < n; ++i) {
                    d1 += param1.doubleValue();
                }
                return new XDouble(d1);
            }
            if (this.name.equals(FunctionExpr.FUNC_FLOOR)) {
                XData param1 = this.parameters[0].eval(context, surpport);
                return new XDouble(Math.floor(param1.doubleValue()));
            }
            if (this.name.equals(FunctionExpr.FUNC_CEILING)) {
                XData param1 = this.parameters[0].eval(context, surpport);
                return new XDouble(Math.ceil(param1.doubleValue()));
            }
            if (this.name.equals(FunctionExpr.FUNC_ROUND)) {
                XData param1 = this.parameters[0].eval(context, surpport);
                return new XDouble(Math.round(param1.doubleValue()));
            }
            return new XDouble(0.0);
        }

        @Override
        public void check() throws XPathException {
            if (this.name.equals(FunctionExpr.FUNC_NUMBER)) {
                if (this.parameters != null && this.parameters.length > 1) {
                    XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
                }
            } else if (this.parameters == null || this.parameters.length != 1) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
            }
        }
    }

    static class booleanFunc
    extends FunctionExpr {
        booleanFunc() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            Node node;
            if (this.name.equals(FunctionExpr.FUNC_BOOLEAN)) {
                return new XBoolean(this.booleanValue(context, surpport));
            }
            if (this.name.equals(FunctionExpr.FUNC_NOT)) {
                return new XBoolean(!this.booleanValue(context, surpport));
            }
            if (this.name.equals(FunctionExpr.FUNC_TRUE)) {
                return new XBoolean(true);
            }
            if (this.name.equals(FunctionExpr.FUNC_FALSE)) {
                return new XBoolean(false);
            }
            if (this.name.equals(FunctionExpr.FUNC_LANG) && (node = context.nodeValue()).getNodeType() == 1) {
                String lang = ((Element)node).getAttribute("xml:lang");
                int k = lang.indexOf("-");
                if (k > 0) {
                    lang = lang.substring(0, k);
                }
                XData param1 = this.parameters[0].eval(context, surpport);
                String s = param1.stringValue();
                return new XBoolean(lang.equalsIgnoreCase(s));
            }
            return new XBoolean(false);
        }

        private boolean booleanValue(XData context, XPathSurpport surpport) throws SAXException {
            XData param1 = this.parameters != null && this.parameters.length >= 1 ? this.parameters[0].eval(context, surpport) : context;
            if (param1.isNode()) {
                return param1.size() > 0;
            }
            if (param1.isString()) {
                return param1.stringValue().length() > 0;
            }
            return param1.booleanValue();
        }

        @Override
        public void check() throws XPathException {
            if (this.name.equals(FunctionExpr.FUNC_TRUE) || this.name.equals(FunctionExpr.FUNC_FALSE)) {
                if (this.parameters != null && this.parameters.length > 0) {
                    XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
                }
            } else if (this.name.equals(FunctionExpr.FUNC_BOOLEAN)) {
                if (this.parameters != null && this.parameters.length > 1) {
                    XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
                }
            } else if (this.parameters == null || this.parameters.length != 1) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
            }
        }
    }

    static class translate
    extends FunctionExpr {
        translate() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[1].eval(context, surpport);
            XData param3 = this.parameters[2].eval(context, surpport);
            String s1 = param1.stringValue();
            String s2 = param2.stringValue();
            String s3 = param2.stringValue();
            StringBuffer sb = new StringBuffer();
            int n = s1.length();
            for (int i = 0; i < n; ++i) {
                char c = s1.charAt(i);
                int k = s2.indexOf(c);
                if (k < 0) {
                    sb.append(c);
                    continue;
                }
                if (k >= s3.length()) continue;
                sb.append(s3.charAt(k));
            }
            return new XString(sb.toString());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 3) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "3"}, null);
            }
        }
    }

    static class normalize_space
    extends FunctionExpr {
        normalize_space() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            String s1;
            if (this.parameters != null && this.parameters.length >= 1) {
                XData param1 = this.parameters[0].eval(context, surpport);
                s1 = param1.stringValue();
            } else {
                s1 = context.stringValue();
            }
            StringTokenizer sz = new StringTokenizer(s1, " \n\b\t\r");
            StringBuffer sb = new StringBuffer();
            while (sz.hasMoreElements()) {
                String s = (String)sz.nextElement();
                if (s.length() <= 0) continue;
                sb.append(s);
                sb.append(' ');
            }
            return new XString(sb.toString());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class string_length
    extends FunctionExpr {
        string_length() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            String s1;
            if (this.parameters != null && this.parameters.length >= 1) {
                XData param1 = this.parameters[0].eval(context, surpport);
                s1 = param1.stringValue();
            } else {
                s1 = context.stringValue();
            }
            return new XInteger(s1.length());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class substring
    extends FunctionExpr {
        substring() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[1].eval(context, surpport);
            String s1 = param1.stringValue();
            int int1 = param2.intValue();
            if (this.parameters.length == 2) {
                return new XString(s1.substring(int1));
            }
            param2 = this.parameters[2].eval(context, surpport);
            int int2 = param2.intValue();
            return new XString(s1.substring(int1, int2));
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 2 && this.parameters.length != 3) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "3"}, null);
            }
        }
    }

    static class substring_after
    extends FunctionExpr {
        substring_after() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            String s2;
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[1].eval(context, surpport);
            String s1 = param1.stringValue();
            int k = s1.indexOf(s2 = param2.stringValue());
            String s = k >= 0 ? s1.substring(k + 1) : "";
            return new XString(s);
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 2) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class substring_before
    extends FunctionExpr {
        substring_before() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            String s2;
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[0].eval(context, surpport);
            String s1 = param1.stringValue();
            int k = s1.indexOf(s2 = param2.stringValue());
            String s = k > 0 ? s1.substring(0, k) : "";
            return new XString(s);
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 2) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class contains
    extends FunctionExpr {
        contains() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            String s2;
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[1].eval(context, surpport);
            String s1 = param1.stringValue();
            return new XBoolean(s1.indexOf(s2 = param2.stringValue()) >= 0);
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 2) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class starts_with
    extends FunctionExpr {
        starts_with() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param1 = this.parameters[0].eval(context, surpport);
            XData param2 = this.parameters[1].eval(context, surpport);
            String s1 = param1.stringValue();
            String s2 = param2.stringValue();
            return new XBoolean(s1.startsWith(s2));
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length != 2) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class concat
    extends FunctionExpr {
        concat() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            if (this.parameters != null && this.parameters.length > 1) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.parameters.length; ++i) {
                    XData param = this.parameters[0].eval(context, surpport);
                    sb.append(param.stringValue());
                }
                return new XString(sb.toString());
            }
            return new XString("");
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length < 2) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class string
    extends FunctionExpr {
        string() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param = this.parameters != null && this.parameters.length > 0 ? this.parameters[0].eval(context, surpport) : context;
            if (param.size() == 0) {
                return new XString("");
            }
            if (param.isNode()) {
                Node ref;
                Document doc = param.nodeValue().getOwnerDocument();
                if (null == doc && null == (doc = surpport.getDocument())) {
                    XPathException.fatal("NO_OWNERDOC", new Object[0], null);
                }
                DataTypeDecl dt = ((XNodeSet)param).getTypeDecl();
                if (param.size() > 1) {
                    NodeListImpl nodelist = DefaultXPathSurpport.sortNodesByDocumentOrder(((XNodeSet)param).nodeset(), doc);
                    ref = nodelist.elementAt(0);
                } else {
                    ref = param.nodeValue();
                }
                XNode xn = new XNode(ref);
                xn.setTypeDecl(dt);
                return new XString(xn.stringValue());
            }
            return new XString(param.stringValue());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class name
    extends FunctionExpr {
        name() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            Node ref = this.getFirstNodeInDocumentOrder(context, surpport);
            if (ref == null) {
                return new XString("");
            }
            return new XString(ref.getNodeName());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class namespace_uri
    extends FunctionExpr {
        namespace_uri() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            Node ref = this.getFirstNodeInDocumentOrder(context, surpport);
            if (ref == null) {
                return new XString("");
            }
            String s = ref.getNodeName();
            int k = s.indexOf(":");
            if (k <= 0) {
                return new XString("");
            }
            String nsdef = "xmlns:" + s.substring(0, k);
            String defaultNs = null;
            while (ref != null) {
                if (ref.getNodeType() != 1) {
                    ref = ref.getParentNode();
                    continue;
                }
                Element em = (Element)ref;
                NamedNodeMap map = em.getAttributes();
                if (map != null) {
                    int n = map.getLength();
                    for (int i = 0; i < n; ++i) {
                        Node attr = map.item(i);
                        String attrname = attr.getNodeName();
                        if (nsdef.equals(attrname)) {
                            return new XString(attr.getNodeValue());
                        }
                        if (defaultNs != null || !attrname.equals("xmlns")) continue;
                        defaultNs = attr.getNodeValue();
                    }
                }
                ref = ref.getParentNode();
            }
            if (defaultNs == null) {
                defaultNs = "";
            }
            return new XString(defaultNs);
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class local_name
    extends FunctionExpr {
        local_name() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            Node ref = this.getFirstNodeInDocumentOrder(context, surpport);
            if (ref == null) {
                return new XString("");
            }
            String s = ref.getNodeName();
            int k = s.indexOf(":");
            if (k > 0) {
                s = s.substring(k + 1);
            }
            return new XString(s);
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters != null && this.parameters.length > 1) {
                XPathException.fatal("INVALID_PARAM", new Object[]{this.getFunctionName(), "2"}, null);
            }
        }
    }

    static class id
    extends FunctionExpr {
        id() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param = this.parameters[0].eval(context, surpport);
            int nRefs = 1;
            Document doc = null;
            if (param.isNode()) {
                nRefs = param.size();
                doc = param.nodeValue().getOwnerDocument();
            } else {
                doc = surpport.getDocument();
            }
            if (null == doc) {
                XPathException.fatal("NO_OWNERDOC", new Object[0], null);
            }
            XNodeSet nodes = new XNodeSet();
            if (doc == null) {
                return nodes;
            }
            if (param.getType() == 0 || !param.isNode() && param.stringValue().length() == 0) {
                return nodes;
            }
            Hashtable<String, String> usedrefs = new Hashtable<String, String>();
            String currentPattern = this.toString();
            NodeListImpl mnl = nodes.mutableNodeset();
            TreeMap map = new TreeMap();
            for (int i = 0; i < nRefs; ++i) {
                String refval = param.stringValue(i);
                if (null == refval) continue;
                StringTokenizer tokenizer = new StringTokenizer(refval);
                while (tokenizer.hasMoreTokens()) {
                    String ref = tokenizer.nextToken();
                    if (null == ref || usedrefs.get(ref) != null) continue;
                    usedrefs.put(ref, currentPattern);
                    this.getElementByID(ref, doc, 0, map);
                }
            }
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                mnl.addElement((Node)it.next());
            }
            nodes.size();
            return nodes;
        }

        private Node getElementByID(String ref, Node parent, int order, SortedMap map) {
            if (!parent.hasChildNodes()) {
                return null;
            }
            for (Node node1 = parent.getFirstChild(); node1 != null; node1 = node1.getNextSibling()) {
                ++order;
                if (node1.getNodeType() != 1) continue;
                String s = ((Element)node1).getAttribute("ID");
                if (s != null && ref.equals(s)) {
                    map.put(new Integer(order), node1);
                    return node1;
                }
                Node node2 = this.getElementByID(ref, node1, order, map);
                if (node2 == null) continue;
                return node2;
            }
            return null;
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length == 0) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
            }
        }
    }

    static class count
    extends FunctionExpr {
        count() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            XData param = this.parameters[0].eval(context, surpport);
            return new XInteger(param.size());
        }

        @Override
        public void check() throws XPathException {
            if (this.parameters == null || this.parameters.length == 0) {
                XPathException.fatal("NEED_PARAM", new Object[]{this.getFunctionName(), "1"}, null);
            }
        }
    }

    static class position
    extends FunctionExpr {
        position() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            if (context instanceof XNodeEx) {
                int index = ((XNodeEx)context).getPosition();
                return new XInteger(index + 1);
            }
            return new XInteger(0);
        }
    }

    static class last
    extends FunctionExpr {
        last() {
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            if (context instanceof XNodeEx) {
                int last2 = ((XNodeEx)context).getLast();
                return new XInteger(last2 + 1);
            }
            return new XInteger(0);
        }
    }
}

