/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XData;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathSurpport;
import org.xml.sax.SAXException;

public class IndexExpr
implements Expr {
    protected Expr[][] indexArray;
    protected int count = 0;
    private int max = 0;
    protected boolean isSingleIndex;
    private final int BASESIZE = 4;
    private int replayLayer = 0;

    @Override
    public int getType() {
        return 24;
    }

    private final synchronized void ensureCapacity(int minCapacity) {
        if (this.max == 0) {
            this.max = minCapacity;
            this.indexArray = new Expr[this.max][2];
        } else if (minCapacity > this.max) {
            Expr[][] oldData = this.indexArray;
            this.max += 4;
            if (this.max < minCapacity) {
                this.max = minCapacity;
            }
            this.indexArray = new Expr[this.max][2];
            System.arraycopy(oldData, 0, this.indexArray, 0, this.count);
        }
    }

    public IndexExpr() {
        this.replayLayer = 0;
    }

    public IndexExpr(int replay) {
        this.replayLayer = replay;
    }

    public int getReplayLayer() {
        return this.replayLayer;
    }

    protected void append(Expr first, Expr last2) {
        this.ensureCapacity(this.count + 1);
        this.indexArray[this.count][0] = first;
        this.indexArray[this.count][1] = last2;
        ++this.count;
        this.isSingleIndex = this.count == 1 && last2 == null;
    }

    protected void append(Expr first) {
        this.append(first, null);
    }

    public int getSize() {
        return this.count;
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        return null;
    }

    public int getFirst(int index, XData context, XPathSurpport surpport) throws SAXException {
        Expr tmp = this.indexArray[index][0];
        try {
            XData data1 = tmp.eval(context, surpport);
            return data1.intValue();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XPathException(null, "", "", 0, 0, e);
        }
    }

    public int getLast(int index, XData context, XPathSurpport surpport) throws SAXException {
        Expr tmp = this.indexArray[index][1];
        if (tmp == null) {
            return -1;
        }
        try {
            XData data1 = tmp.eval(context, surpport);
            return data1.intValue();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XPathException(null, "", "", 0, 0, e);
        }
    }

    public boolean isRange(int index) {
        return this.indexArray[index][1] != null;
    }

    public boolean isANY() {
        return this.count == 0;
    }

    public int getMaxIndex(XData context, XPathSurpport surpport) throws SAXException {
        if (this.count == 0) {
            return 10000000;
        }
        int max = 0;
        for (int i = 0; i < this.count; ++i) {
            int tmp = this.getFirst(i, context, surpport);
            if (tmp > max) {
                max = tmp;
            }
            if ((tmp = this.getLast(i, context, surpport)) <= max) continue;
            max = tmp;
        }
        return max;
    }

    public String toString() {
        if (this.isANY()) {
            return "*";
        }
        int n = this.getSize();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            Expr first = this.indexArray[i][0];
            sb.append(first.toString());
            Expr last2 = this.indexArray[i][1];
            if (last2 != null) {
                sb.append(" to ");
                sb.append(last2.toString());
            }
            if (i >= n - 1) continue;
            sb.append(" , ");
        }
        return sb.toString();
    }
}

