/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDouble;
import com.argo21.common.lang.XNull;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.xml.sax.SAXException;

public class MultiplicativeExpr
implements Expr {
    Expr l_expr;
    Expr r_expr;
    int op;

    MultiplicativeExpr(int op, Expr l_expr, Expr r_expr) {
        this.op = op;
        this.l_expr = l_expr;
        this.r_expr = r_expr;
    }

    @Override
    public int getType() {
        return this.op;
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        XData obj1 = this.l_expr.eval(context, surpport);
        XData obj2 = this.r_expr.eval(context, surpport);
        double num1 = obj1.doubleValue();
        double num2 = obj2.doubleValue();
        switch (this.op) {
            case 12: {
                return new XDouble(num1 * num2);
            }
            case 13: {
                return new XDouble(num1 / num2);
            }
            case 14: {
                return new XDouble(num1 % num2);
            }
            case 15: {
                return new XDouble((int)(num1 / num2));
            }
        }
        return new XNull();
    }

    public String toString() {
        switch (this.op) {
            case 12: {
                return this.l_expr.toString() + " * " + this.r_expr.toString();
            }
            case 13: {
                return this.l_expr.toString() + " div " + this.r_expr.toString();
            }
            case 14: {
                return this.l_expr.toString() + " mod " + this.r_expr.toString();
            }
            case 15: {
                return this.l_expr.toString() + " quo " + this.r_expr.toString();
            }
        }
        return "";
    }
}

