/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XBoolean;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNull;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.xml.sax.SAXException;

public class RelationalExpr
implements Expr {
    Expr l_expr;
    Expr r_expr;
    int op;

    RelationalExpr(int op, Expr l_expr, Expr r_expr) {
        this.op = op;
        this.l_expr = l_expr;
        this.r_expr = r_expr;
    }

    @Override
    public int getType() {
        return this.op;
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        XData obj1 = this.l_expr.eval(context, surpport);
        XData obj2 = this.r_expr.eval(context, surpport);
        switch (this.op) {
            case 4: {
                return new XBoolean(obj1.notEquals(obj2));
            }
            case 5: {
                return new XBoolean(obj1.equals(obj2));
            }
            case 6: {
                return new XBoolean(obj1.lessThanOrEqual(obj2));
            }
            case 7: {
                return new XBoolean(obj1.lessThan(obj2));
            }
            case 8: {
                return new XBoolean(obj1.greaterThanOrEqual(obj2));
            }
            case 9: {
                return new XBoolean(obj1.greaterThan(obj2));
            }
        }
        return new XNull();
    }

    public String toString() {
        switch (this.op) {
            case 4: {
                return this.l_expr.toString() + "!=" + this.r_expr.toString();
            }
            case 5: {
                return this.l_expr.toString() + "==" + this.r_expr.toString();
            }
            case 6: {
                return this.l_expr.toString() + "<=" + this.r_expr.toString();
            }
            case 7: {
                return this.l_expr.toString() + "<" + this.r_expr.toString();
            }
            case 8: {
                return this.l_expr.toString() + ">=" + this.r_expr.toString();
            }
            case 9: {
                return this.l_expr.toString() + ">" + this.r_expr.toString();
            }
        }
        return "";
    }
}

