/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.util.BizTranCache;
import com.argo21.jxp.xpath.AttributeTest;
import com.argo21.jxp.xpath.ElementTest;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.IndexExpr;
import com.argo21.jxp.xpath.NodeTest;
import com.argo21.jxp.xpath.NodeTypeTest;
import com.argo21.jxp.xpath.XNodeEx;
import com.argo21.jxp.xpath.XPathSurpport;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StepExpr
implements Expr {
    public static final int AXISOP_NULL = 0;
    public static final int AXISOP_DOCUMENT = 1;
    public static final int AXISOP_ANCESTORS = 2;
    public static final int AXISOP_ANCESTORS_OR_SELF = 3;
    public static final int AXISOP_ATTRIBUTES = 4;
    public static final int AXISOP_CHILDREN = 5;
    public static final int AXISOP_DESCENDANTS = 6;
    public static final int AXISOP_DESCENDANTS_OR_SELF = 7;
    public static final int AXISOP_FOLLOWING = 8;
    public static final int AXISOP_FOLLOWING_SIBLINGS = 9;
    public static final int AXISOP_PARENT = 10;
    public static final int AXISOP_PRECEDING = 11;
    public static final int AXISOP_PRECEDING_SIBLINGS = 12;
    public static final int AXISOP_SELF = 13;
    public static final int AXISOP_NAMESPACE = 14;
    static final String[] AXISNAME_STRING = new String[]{"null", "document", "ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "parent", "preceding", "preceding-sibling", "self", "namespace"};
    static final Hashtable AXISNAME_TABLE = new Hashtable(23);
    protected int axis;
    protected NodeTest nodetest;
    protected Expr[] predicaties;
    protected String resultName;

    static int getAxisOp(String AxisName) {
        Integer tmp = (Integer)AXISNAME_TABLE.get(AxisName);
        return tmp == null ? 0 : tmp;
    }

    public static StepExpr getAbbreviatedStepExpr(String abbreviated) {
        if (abbreviated.equals("//")) {
            return new StepExpr(7, NodeTypeTest.getAllNodeTypeTest());
        }
        if (abbreviated.equals("..")) {
            return new StepExpr(10, NodeTypeTest.getAllNodeTypeTest());
        }
        if (abbreviated.equals(".")) {
            return new StepExpr(13, NodeTypeTest.getAllNodeTypeTest());
        }
        return null;
    }

    protected StepExpr(int axis) {
        this(axis, null);
    }

    protected StepExpr(int axis, NodeTest nodetest) {
        this.axis = axis;
        this.nodetest = nodetest;
    }

    @Override
    public int getType() {
        return 27;
    }

    public void appendPredicate(Expr predicate) {
        if (this.predicaties == null) {
            this.predicaties = new Expr[1];
            this.predicaties[0] = predicate;
        } else {
            int n = this.predicaties.length;
            Expr[] temp = new Expr[n + 1];
            System.arraycopy(this.predicaties, 0, temp, 0, n);
            temp[n] = predicate;
            this.predicaties = temp;
        }
    }

    @Override
    public XData eval(XData context, XPathSurpport surpport) throws SAXException {
        int n = context.size();
        boolean indexComplete = false;
        NodeListImpl results = new NodeListImpl();
        String tmpResultName = null;
        String parentName = null;
        for (int i = 0; i < n; ++i) {
            Node node = context.nodeValue(i);
            switch (this.axis) {
                case 2: {
                    indexComplete = this.selectAncestors(node, results, surpport);
                    break;
                }
                case 3: {
                    indexComplete = this.selectAncestorsOrSelf(node, results, surpport);
                    break;
                }
                case 4: {
                    indexComplete = this.selectAttribute(node, results, surpport);
                    break;
                }
                case 5: {
                    indexComplete = this.selectChild(node, results, surpport);
                    if (n <= 1) break;
                    BizTranCache.popXPath();
                    break;
                }
                case 6: {
                    indexComplete = this.selectDescendants(node, results, surpport, false);
                    break;
                }
                case 7: {
                    indexComplete = this.selectDescendants(node, results, surpport, true);
                    break;
                }
                case 8: {
                    indexComplete = this.selectFollowing(node, results, surpport);
                    break;
                }
                case 9: {
                    indexComplete = this.selectFollowingSiblings(node, results, surpport);
                    break;
                }
                case 10: {
                    indexComplete = this.selectParent(node, results, surpport);
                    break;
                }
                case 11: {
                    indexComplete = this.selectPreceding(node, results, surpport);
                    break;
                }
                case 12: {
                    indexComplete = this.selectPrecedingSiblings(node, results, surpport);
                    break;
                }
                case 13: {
                    indexComplete = this.selectSelf(node, results, surpport);
                    break;
                }
                case 14: {
                    indexComplete = this.selectNamespace(node, results, surpport);
                }
            }
            if (i == 0) {
                tmpResultName = this.resultName;
                if (node.getLocalName() == null) {
                    parentName = node.getNodeName();
                    continue;
                }
                parentName = node.getLocalName();
                continue;
            }
            if (tmpResultName != null && !tmpResultName.equals(this.resultName)) {
                tmpResultName = null;
            }
            String parentNameCur = null;
            parentNameCur = node.getLocalName() == null ? node.getNodeName() : node.getLocalName();
            if (parentNameCur.equals(parentName)) continue;
            parentName = null;
        }
        NodeList nl = !indexComplete ? this.evalPredicate(results, surpport) : results;
        int count2 = nl.getLength();
        if (count2 == 1) {
            Node nd = nl.item(0);
            XNode xnd = new XNode(nd);
            if (tmpResultName != null) {
                xnd.setTypeDecl(surpport.getTypeDecl(parentName, tmpResultName));
            }
            return xnd;
        }
        if (count2 > 1) {
            XNodeSet xnds = new XNodeSet(nl);
            if (tmpResultName != null) {
                xnds.setTypeDecl(surpport.getTypeDecl(parentName, tmpResultName));
            }
            return xnds;
        }
        return new XNodeSet(nl);
    }

    boolean selectChild(Node context, NodeListImpl results, XPathSurpport surpport) throws SAXException {
        if (this.nodetest instanceof ElementTest) {
            String name2 = ((ElementTest)this.nodetest).name;
            if (this.predicaties == null || this.predicaties.length == 0) {
                surpport.getElementNodeList(context, name2, 0, 0, results, false);
                this.resultName = name2;
                return true;
            }
            if (this.predicaties[0] instanceof IndexExpr) {
                IndexExpr expr = (IndexExpr)this.predicaties[0];
                int n = expr.getSize();
                if (n == 0) {
                    int max = surpport.getDefaultNumber();
                    if (max > 0 && max <= 10000000) {
                        surpport.getElementNodeList(context, name2, max, results);
                    }
                } else {
                    XNode data = new XNode(context);
                    for (int i = 0; i < n; ++i) {
                        int first = expr.getFirst(i, data, surpport);
                        int last2 = expr.getLast(i, data, surpport);
                        if (last2 < 0) {
                            last2 = first;
                        } else if (last2 < first) {
                            int tmp = first;
                            first = last2;
                            last2 = tmp;
                        }
                        surpport.getElementNodeList(context, name2, first, last2, results, true);
                    }
                }
                this.resultName = name2;
                return true;
            }
        }
        NodeList nl = context.getChildNodes();
        if (this.nodetest.isAllNode()) {
            results.addNodes(nl);
        } else {
            int n = nl.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nl.item(i);
                if (!this.nodetest.test(node)) continue;
                results.addNode(node);
            }
        }
        return false;
    }

    boolean selectAttribute(Node context, NodeListImpl results, XPathSurpport surpport) throws SAXException {
        if (!this.nodetest.isAllNode() && this.nodetest instanceof AttributeTest) {
            String name2 = ((AttributeTest)this.nodetest).name;
            surpport.getAttrNode(context, name2, results);
            this.resultName = "@" + name2;
            return true;
        }
        NamedNodeMap atts = context.getAttributes();
        int n = atts.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = atts.item(i);
            if (!this.nodetest.test(node)) continue;
            results.addNode(node);
        }
        return false;
    }

    boolean selectAncestors(Node context, NodeListImpl results, XPathSurpport surpport) {
        if (context.getNodeType() == 1) {
            int pos = results.getLength();
            for (Node node = context.getParentNode(); node != null; node = node.getParentNode()) {
                if (!this.nodetest.test(node)) continue;
                results.insertNode(node, pos);
            }
        }
        return false;
    }

    boolean selectAncestorsOrSelf(Node context, NodeListImpl results, XPathSurpport surpport) {
        if (context.getNodeType() == 1) {
            int pos = results.getLength();
            for (Node node = context; node != null; node = node.getParentNode()) {
                if (!this.nodetest.test(node)) continue;
                results.insertNode(node, pos);
            }
        }
        return false;
    }

    boolean selectFollowingSiblings(Node context, NodeListImpl results, XPathSurpport surpport) {
        if (context.getNodeType() == 1) {
            for (Node node = context.getNextSibling(); node != null; node = node.getNextSibling()) {
                if (!this.nodetest.test(node)) continue;
                results.addNode(node);
            }
        }
        return false;
    }

    boolean selectFollowing(Node context, NodeListImpl results, XPathSurpport surpport) {
        Document doc = context.getOwnerDocument();
        Node node = context;
        while (node != null) {
            Node nextNode = null;
            if (node != context) {
                if (this.nodetest.test(node)) {
                    results.addNode(node);
                }
                nextNode = node.getFirstChild();
            } else {
                nextNode = null;
            }
            while (null == nextNode) {
                nextNode = node.getNextSibling();
                if (null != nextNode || doc != (node = node.getParentNode()) && null != node) continue;
                nextNode = null;
                break;
            }
            node = nextNode;
        }
        return false;
    }

    boolean selectDescendants(Node context, NodeListImpl results, XPathSurpport surpport, boolean onSelf) {
        Node node = context;
        while (null != node) {
            if ((onSelf || context != node) && this.nodetest.test(node)) {
                results.addNode(node);
            }
            Node nextNode = node.getFirstChild();
            while (null == nextNode && !context.equals(node)) {
                nextNode = node.getNextSibling();
                if (null != nextNode || (node = node.getParentNode()) != null && !context.equals(node)) continue;
                nextNode = null;
                break;
            }
            node = nextNode;
        }
        return false;
    }

    boolean selectParent(Node context, NodeListImpl results, XPathSurpport surpport) {
        Node node = context;
        if (null != (context = context.getParentNode()) && this.nodetest.test(context)) {
            results.addElement(context);
        }
        return false;
    }

    boolean selectPreceding(Node context, NodeListImpl results, XPathSurpport surpport) {
        Document doc = context instanceof Document ? (Document)context : context.getOwnerDocument();
        Node node = doc;
        while (node != null && !context.equals(node)) {
            if (this.nodetest.test(node)) {
                boolean isParent = false;
                for (Node parent = context.getParentNode(); parent != null; parent = parent.getParentNode()) {
                    if (!parent.equals(node)) continue;
                    isParent = true;
                    break;
                }
                if (!isParent) {
                    results.addNode(node);
                }
            }
            Node nextNode = node.getFirstChild();
            while (nextNode == null) {
                nextNode = node.getNextSibling();
                if (nextNode != null || (node = node.getParentNode()) != null && !doc.equals(node)) continue;
                nextNode = null;
                break;
            }
            node = nextNode;
        }
        return false;
    }

    boolean selectPrecedingSiblings(Node context, NodeListImpl results, XPathSurpport surpport) {
        for (Node node = context.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (!this.nodetest.test(node)) continue;
            results.addNode(node);
        }
        return false;
    }

    boolean selectSelf(Node context, NodeListImpl results, XPathSurpport surpport) {
        if (this.nodetest.test(context)) {
            results.addNode(context);
        }
        return false;
    }

    boolean selectNamespace(Node context, NodeListImpl results, XPathSurpport surpport) throws SAXException {
        throw new SAXException("\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u306a\u3044");
    }

    NodeList evalPredicate(NodeList context, XPathSurpport surpport) throws SAXException {
        if (this.predicaties == null || this.predicaties.length == 0) {
            return context;
        }
        NodeListImpl results = null;
        for (int i = 0; i < this.predicaties.length; ++i) {
            int n = context.getLength();
            if (n <= 0) {
                return context;
            }
            if (this.predicaties[i] instanceof IndexExpr) {
                IndexExpr expr = (IndexExpr)this.predicaties[i];
                int index_num = expr.getSize();
                if (index_num == 0) {
                    results = new NodeListImpl(context);
                } else {
                    XNodeSet data = new XNodeSet(context);
                    results = new NodeListImpl(n);
                    for (int j = 0; j < index_num; ++j) {
                        int first = expr.getFirst(j, data, surpport);
                        int last2 = expr.getLast(j, data, surpport);
                        if (last2 < 0) {
                            last2 = first;
                        } else if (last2 < first) {
                            int tmp = first;
                            first = last2;
                            last2 = tmp;
                        }
                        for (int k = first; k <= last2; ++k) {
                            if (k >= n) continue;
                            context.item(k);
                        }
                    }
                }
            } else {
                XNodeEx item = new XNodeEx(context, 0);
                XData value = this.predicaties[i].eval(item, surpport);
                if (value.isNumber()) {
                    int k = value.intValue();
                    if (k >= 0 && k < n) {
                        item.setPosition(k);
                        results = new NodeListImpl(item.nodeValue());
                    } else {
                        results = new NodeListImpl();
                    }
                } else {
                    results = new NodeListImpl(n);
                    if (value.booleanValue()) {
                        results.addNode(item.nodeValue());
                    }
                    for (int j = 1; j < n; ++j) {
                        item.setPosition(j);
                        value = this.predicaties[i].eval(item, surpport);
                        if (!value.booleanValue()) continue;
                        results.addNode(item.nodeValue());
                    }
                }
            }
            context = results;
        }
        return results;
    }

    public String getShortPath() {
        switch (this.axis) {
            case 7: {
                return "";
            }
            case 10: {
                return "..";
            }
            case 13: {
                return ".";
            }
            case 5: {
                return this.nodetest.toString();
            }
            case 4: {
                return "@" + this.nodetest.toString();
            }
        }
        return this.toString();
    }

    public String getShortPath(XPathSurpport xpathSurpport) {
        switch (this.axis) {
            case 7: {
                return "";
            }
            case 10: {
                return "..";
            }
            case 13: {
                return ".";
            }
            case 5: {
                if (this.predicaties == null) {
                    return this.nodetest.toString();
                }
                StringBuffer sb = new StringBuffer(this.nodetest.toString());
                for (int i = 0; i < this.predicaties.length; ++i) {
                    if (((IndexExpr)this.predicaties[i]).getSize() > 0) {
                        int index = this.getFirstLast(i, xpathSurpport);
                        if (this.predicaties.length == 0) continue;
                        sb.append('[');
                        sb.append(index);
                        sb.append(']');
                        continue;
                    }
                    sb.append("[*]");
                }
                return sb.toString();
            }
            case 4: {
                return "@" + this.nodetest.toString();
            }
        }
        return this.toString();
    }

    private int getFirstLast(int i, XPathSurpport xpathSurpport) {
        try {
            int first = ((IndexExpr)this.predicaties[i]).getFirst(i, null, xpathSurpport);
            int last2 = ((IndexExpr)this.predicaties[i]).getLast(i, null, xpathSurpport);
            if (last2 < 0) {
                last2 = first;
            }
            if (first == last2) {
                return first;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(AXISNAME_STRING[this.axis]);
        sb.append("::");
        sb.append(this.nodetest.toString());
        if (this.predicaties != null) {
            for (int i = 0; i < this.predicaties.length; ++i) {
                sb.append('[');
                sb.append(this.predicaties[i].toString());
                sb.append(']');
            }
        }
        return sb.toString();
    }

    public String getName() {
        if (this.nodetest instanceof ElementTest) {
            return ((ElementTest)this.nodetest).name;
        }
        return null;
    }

    static {
        for (int i = 1; i < AXISNAME_STRING.length; ++i) {
            AXISNAME_TABLE.put(AXISNAME_STRING[i], new Integer(i));
        }
    }
}

