/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.NodeListImpl;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNodeSet;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UnionExpr
implements Expr {
    Expr l_expr;
    Expr r_expr;

    UnionExpr(Expr l_expr, Expr r_expr) {
        this.l_expr = l_expr;
        this.r_expr = r_expr;
    }

    @Override
    public XData eval(XData context, XPathSurpport support) throws SAXException {
        XData obj1 = this.l_expr.eval(context, support);
        XData obj2 = this.r_expr.eval(context, support);
        NodeList nodeset1 = obj1.nodeset();
        NodeList nodeset2 = obj2.nodeset();
        if (nodeset1 == null) {
            return new XNodeSet(nodeset2);
        }
        if (nodeset2 == null) {
            return new XNodeSet(nodeset1);
        }
        int n1 = nodeset1.getLength();
        if (n1 == 0) {
            return new XNodeSet(nodeset2);
        }
        int n2 = nodeset2.getLength();
        if (n2 == 0) {
            return new XNodeSet(nodeset1);
        }
        NodeListImpl nl = nodeset1 instanceof NodeListImpl ? (NodeListImpl)nodeset1 : new NodeListImpl(nodeset1);
        nl.addNodes(nodeset2);
        return new XNodeSet(nl);
    }

    public String toString() {
        return this.l_expr.toString() + " | " + this.r_expr.toString();
    }

    @Override
    public int getType() {
        return 20;
    }
}

