/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataSet;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XDOMAccess {
    Document doc;
    XPathParser parser;
    XPathSurpport surpport;

    public XDOMAccess(Document doc) {
        this.doc = doc;
        this.parser = new XPathParser();
        this.surpport = new DefaultXPathSurpport(doc);
        this.surpport.setExtendable(false);
    }

    public String getValue(String path) throws SAXException {
        XPath xpath = this.parser.parse(path);
        XData data = xpath.eval(this.doc, this.surpport);
        return data.stringValue();
    }

    public String[] getValues(String path) throws SAXException {
        XPath xpath = this.parser.parse(path);
        XData data = xpath.eval(this.doc, this.surpport);
        if (data instanceof XDataSet) {
            return ((XDataSet)data).stringValues();
        }
        return new String[]{data.stringValue()};
    }

    public void setValue(String path, String value) throws SAXException {
        XPath xpath = this.parser.parse(path);
        XData data = xpath.eval(this.doc, this.surpport);
        data.setValue(value);
    }

    public void getValues(String path, String[] values) throws SAXException {
        XPath xpath = this.parser.parse(path);
        XData data = xpath.eval(this.doc, this.surpport);
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            if (i >= values.length) continue;
            data.setValue(values[i]);
        }
    }
}

