/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.util.BizTranCache;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.PathExpr;
import com.argo21.jxp.xpath.StepExpr;
import com.argo21.jxp.xpath.XPathSurpport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPath {
    int line;
    Expr expr;

    XPath(Expr expr) {
        this.expr = expr;
    }

    public XData eval(XData node, XPathSurpport surpport) throws SAXException {
        return this.expr.eval(node, surpport);
    }

    public XData eval(Node node, XPathSurpport surpport) throws SAXException {
        return this.expr.eval(new XNodeSet(node), surpport);
    }

    public XData eval(NodeList nl, XPathSurpport surpport) throws SAXException {
        if (nl.getLength() > 0) {
            return this.expr.eval(new XNodeSet(nl), surpport);
        }
        return null;
    }

    public XData eval(XNode parent, XPathSurpport surpport, int num) throws SAXException {
        Expr cExpr = this.getCachedExpr(surpport, num);
        return cExpr.eval(parent, surpport);
    }

    public XData eval(XNodeSet parent, XPathSurpport surpport, int num) throws SAXException {
        Expr cExpr = this.getCachedExpr(surpport, num);
        return cExpr.eval(parent, surpport);
    }

    private Expr getCachedExpr(XPathSurpport surpport, int num) {
        String nodePath = this.getNodePathString(surpport);
        Expr ex = BizTranCache.getExpr(nodePath, num);
        if (ex != null) {
            return ex;
        }
        ex = this.expr;
        for (int i = 0; i < num; ++i) {
            if (ex instanceof PathExpr) {
                ex = ((PathExpr)ex).getR_step();
                continue;
            }
            if (!(ex instanceof StepExpr)) continue;
            BizTranCache.setExpr(nodePath, num, ex);
            return ex;
        }
        BizTranCache.setExpr(nodePath, num, ex);
        return ex;
    }

    public String getProlixPathString() {
        return this.expr.toString();
    }

    public String getNodePathString() {
        String s = this.expr instanceof PathExpr ? ((PathExpr)this.expr).getShortPath() : (this.expr instanceof StepExpr ? ((StepExpr)this.expr).getShortPath() : "");
        return s;
    }

    public String getNodePathString(XPathSurpport xpathSurpport) {
        String s = this.expr instanceof PathExpr ? ((PathExpr)this.expr).getShortPath(xpathSurpport) : (this.expr instanceof StepExpr ? ((StepExpr)this.expr).getShortPath(xpathSurpport) : "");
        return s;
    }
}

