/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xpath;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.jxp.xpath.AdditiveExpr;
import com.argo21.jxp.xpath.AllChildTest;
import com.argo21.jxp.xpath.AttributeTest;
import com.argo21.jxp.xpath.ElementTest;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.FilterExpr;
import com.argo21.jxp.xpath.FunctionExpr;
import com.argo21.jxp.xpath.IndexExpr;
import com.argo21.jxp.xpath.MultiplicativeExpr;
import com.argo21.jxp.xpath.NameSpaceAttributeTest;
import com.argo21.jxp.xpath.NameSpaceElementTest;
import com.argo21.jxp.xpath.NodeTest;
import com.argo21.jxp.xpath.NodeTypeTest;
import com.argo21.jxp.xpath.NumberExpr;
import com.argo21.jxp.xpath.OrAndExpr;
import com.argo21.jxp.xpath.PathExpr;
import com.argo21.jxp.xpath.ProcessingInstrictionTest;
import com.argo21.jxp.xpath.RelationalExpr;
import com.argo21.jxp.xpath.RootExpr;
import com.argo21.jxp.xpath.StepExpr;
import com.argo21.jxp.xpath.StringExpr;
import com.argo21.jxp.xpath.UnionExpr;
import com.argo21.jxp.xpath.VariableReferenceExpr;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathException;
import java.io.Reader;
import org.xml.sax.Locator;

public class XPathParser {
    static MessageCatalog msgCatalog = XPathException.msgCatalog;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    public static final String SELF_ABBREVIATED_STRING = ".";
    public static final String NODETYPE_COMMENT = "comment";
    public static final String NODETYPE_TEXT = "text";
    public static final String NODETYPE_PI = "processing-instruction";
    public static final String NODETYPE_NODE = "node";
    public static final String NODETYPE_ANYELEMENT = "*";
    public static final String FROM_ATTRIBUTE_STRING = "@";
    public static final String FROM_DOC_STRING = "document";
    public static final String FROM_DOCREF_STRING = "document";
    public static final String FROM_ID_STRING = "id";
    public static final String FROM_IDREF_STRING = "idref";
    protected XReader in;
    protected String refrance;
    private char[] buf = new char[64];

    public XPath parse(String contents) throws XPathException {
        this.in = XReader.createReader(contents.toCharArray(), null);
        this.in.setPublicId("");
        this.in.setSystemId("");
        Expr xpath = this.parseLocationPath();
        this.in = null;
        return new XPath(xpath);
    }

    public XPath parse(Reader in) throws XPathException {
        return this.parse(in, null);
    }

    public XPath parse(Reader in, String refrance) throws XPathException {
        this.refrance = refrance;
        if (in instanceof XReader) {
            this.in = (XReader)in;
        } else {
            this.in = XReader.createReader(in);
            this.in.setPublicId("");
            this.in.setSystemId("");
        }
        Expr xpath = this.parseLocationPath();
        this.in = null;
        return new XPath(xpath);
    }

    protected Expr compose(Expr expr1, Expr expr2) throws XPathException {
        if (expr1 != null && expr2 != null) {
            return new PathExpr(expr1, expr2);
        }
        if (expr1 == null) {
            XPathException.fatal("INVALID_LOP", PSEUDONAME_ROOT, (Locator)this.in);
        } else {
            XPathException.fatal("INVALID_ROP", PSEUDONAME_ROOT, (Locator)this.in);
        }
        return null;
    }

    protected Expr parseLocationPath() throws XPathException {
        if (this.in.peek(PSEUDONAME_ROOT)) {
            if (!this.in.peek(PSEUDONAME_ROOT)) {
                Expr expr1 = this.parseRelativeLocationPath();
                return new RootExpr(expr1);
            }
            Expr expr1 = this.parseRelativeLocationPath();
            expr1 = this.compose(StepExpr.getAbbreviatedStepExpr("//"), expr1);
            return new RootExpr(expr1);
        }
        return this.parseRelativeLocationPath();
    }

    protected Expr parseRelativeLocationPath() throws XPathException {
        Expr expr1 = this.parseStep();
        if (expr1 == null) {
            return null;
        }
        if (this.in.peek(PSEUDONAME_ROOT)) {
            if (this.in.peek(PSEUDONAME_ROOT)) {
                expr1 = this.compose(expr1, StepExpr.getAbbreviatedStepExpr("//"));
            }
            return this.compose(expr1, this.parseRelativeLocationPath());
        }
        return expr1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected StepExpr parseStep() throws XPathException {
        void var5_22;
        void var5_12;
        int axis;
        if (this.in.peekc('.')) {
            if (!this.in.peekc('.')) return StepExpr.getAbbreviatedStepExpr(SELF_ABBREVIATED_STRING);
            return StepExpr.getAbbreviatedStepExpr("..");
        }
        boolean isAttribute = this.in.peekc('@');
        String ncname = null;
        String testname = null;
        if (isAttribute) {
            axis = 4;
        } else {
            ncname = this.in.peekNCName();
            if (ncname != null && this.in.peek("::")) {
                axis = StepExpr.getAxisOp(ncname);
                if (axis <= 0) {
                    axis = 5;
                    String string2 = this.in.peekNCName();
                    testname = string2 != null ? ncname + "::" + string2 : ncname + "::";
                }
            } else {
                testname = ncname;
                axis = 5;
            }
        }
        if (testname == null) {
            testname = this.in.peekNCName();
        }
        Object var5_6 = null;
        if (testname == null) {
            if (!this.in.peekc('*')) {
                XPathException.fatal("NEED_CHAR", "*", (Locator)this.in);
                return null;
            }
            if (axis == 4) {
                AttributeTest attributeTest = new AttributeTest("*");
            } else {
                AllChildTest allChildTest = new AllChildTest();
            }
        } else if (this.in.peekc(':')) {
            if (this.in.peekc('*')) {
                if (axis == 4) {
                    NameSpaceAttributeTest nameSpaceAttributeTest = new NameSpaceAttributeTest(testname);
                } else {
                    NameSpaceElementTest nameSpaceElementTest = new NameSpaceElementTest(testname);
                }
                testname = null;
            } else {
                String s = this.in.peekNCName();
                testname = s != null ? testname + ":" + s : testname + ":";
            }
        }
        boolean isNodeTest = false;
        if (var5_12 == null) {
            int nodeType = 0;
            if (testname.equals(NODETYPE_COMMENT)) {
                if (this.mustbeParentheses()) {
                    NodeTypeTest nodeTypeTest = NodeTypeTest.getCommentNodeTypeTest();
                    isNodeTest = true;
                }
            } else if (testname.equals(NODETYPE_TEXT)) {
                if (this.mustbeParentheses()) {
                    NodeTypeTest nodeTypeTest = NodeTypeTest.getTextNodeTypeTest();
                    isNodeTest = true;
                }
            } else if (testname.equals(NODETYPE_NODE)) {
                if (this.mustbeParentheses()) {
                    NodeTypeTest nodeTypeTest = NodeTypeTest.getAllNodeTypeTest();
                    isNodeTest = true;
                }
            } else if (testname.equals(NODETYPE_PI) && this.in.peekc('(')) {
                nodeType = 7;
                this.in.peekWhitespace();
                String param = this.in.peekQuotedString();
                this.in.peekWhitespace();
                if (!this.in.peekc(')')) {
                    XPathException.fatal("NEED_CHAR", ")", (Locator)this.in);
                }
                if (param != null) {
                    ProcessingInstrictionTest processingInstrictionTest = new ProcessingInstrictionTest(param);
                } else {
                    NodeTypeTest nodeTypeTest = NodeTypeTest.getPINodeTypeTest();
                }
                isNodeTest = true;
            }
            if (!isNodeTest) {
                if (axis == 4) {
                    AttributeTest attributeTest = new AttributeTest(testname);
                } else {
                    ElementTest elementTest = new ElementTest(testname);
                }
            }
        }
        StepExpr step = new StepExpr(axis, (NodeTest)var5_22);
        Expr predicate;
        while ((predicate = this.parsePredicate()) != null) {
            step.appendPredicate(predicate);
        }
        return step;
    }

    boolean mustbeParentheses() throws XPathException {
        if (!this.in.peekc('(')) {
            return false;
        }
        this.in.peekWhitespace();
        return this.in.peekc(')');
    }

    boolean canReturnNumber(int type) {
        return type == 19 || type == 10 || type == 11 || type == 12 || type == 13 || type == 14 || type == 15 || type == 16;
    }

    protected Expr parsePredicate() throws XPathException {
        Expr expr = null;
        if (!this.in.peekc('[')) {
            return null;
        }
        this.in.peekWhitespace();
        if (this.in.peekc('*') || this.in.peekc('+')) {
            int k = 1;
            while (this.in.peekc('*') || this.in.peekc('+')) {
                ++k;
            }
            expr = new IndexExpr(k);
        } else if (!this.in.peekc('?')) {
            if (this.in.isChar(']')) {
                expr = new IndexExpr();
            } else {
                int type;
                expr = this.parseOrExpr();
                if (expr == null) {
                    XPathException.fatal("INVALID_PREDICATE", (Locator)this.in);
                }
                if (this.canReturnNumber(type = expr.getType()) || type == 22) {
                    Expr expr1 = expr;
                    expr = new IndexExpr();
                    while (true) {
                        Expr expr2 = null;
                        this.in.peekWhitespace();
                        if (this.in.peek("to") && this.in.peekWhitespace()) {
                            expr2 = this.parseAdditiveExpr();
                            if (expr2 == null) {
                                XPathException.fatal("INVALID_MAX", (Locator)this.in);
                            }
                            if (!this.canReturnNumber(type = expr2.getType()) && type != 22) {
                                XPathException.fatal("INVALID_MAX", (Locator)this.in);
                            }
                            this.in.peekWhitespace();
                        }
                        ((IndexExpr)expr).append(expr1, expr2);
                        if (!this.in.peekc(',')) break;
                        this.in.peekWhitespace();
                        expr1 = this.parseAdditiveExpr();
                        if (expr1 == null) {
                            XPathException.fatal("INVALID_MIN", (Locator)this.in);
                        }
                        if (this.canReturnNumber(type = expr1.getType()) || type == 22) continue;
                        XPathException.fatal("INVALID_MIN", (Locator)this.in);
                    }
                }
            }
        }
        this.in.peekWhitespace();
        if (!this.in.peekc(']')) {
            XPathException.fatal("NEED_CHAR", "]", (Locator)this.in);
        }
        return expr;
    }

    Expr parseOrExpr() throws XPathException {
        Expr l_expr = this.parseAndExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            this.in.peekWhitespace();
            if (!this.in.peek("or")) break;
            this.in.peekWhitespace();
            Expr r_expr = this.parseAndExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", "or", (Locator)this.in);
            }
            l_expr = new OrAndExpr(2, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseAndExpr() throws XPathException {
        Expr l_expr = this.parseEqualityExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            this.in.peekWhitespace();
            if (!this.in.peek("and")) break;
            this.in.peekWhitespace();
            Expr r_expr = this.parseEqualityExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", "and", (Locator)this.in);
            }
            l_expr = new OrAndExpr(3, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseEqualityExpr() throws XPathException {
        Expr l_expr = this.parseRelationalExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            int op;
            String sop;
            this.in.peekWhitespace();
            if (this.in.peekc('=')) {
                sop = "=";
                if (this.in.peekc('=')) {
                    sop = sop + "=";
                }
                op = 5;
            } else {
                if (!this.in.peek("!=")) break;
                op = 4;
                sop = "==";
            }
            this.in.peekWhitespace();
            Expr r_expr = this.parseRelationalExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", sop, (Locator)this.in);
            }
            l_expr = new RelationalExpr(op, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseRelationalExpr() throws XPathException {
        Expr l_expr = this.parseAdditiveExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            String sop;
            int op;
            this.in.peekWhitespace();
            if (this.in.peek(">=")) {
                op = 8;
                sop = ">=";
            } else if (this.in.peek("<=")) {
                op = 6;
                sop = "<=";
            } else if (this.in.peekc('>')) {
                op = 9;
                sop = ">";
            } else {
                if (!this.in.peekc('<')) break;
                op = 7;
                sop = "<";
            }
            this.in.peekWhitespace();
            Expr r_expr = this.parseAdditiveExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", sop, (Locator)this.in);
            }
            l_expr = new RelationalExpr(op, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseAdditiveExpr() throws XPathException {
        Expr l_expr = this.parseMultiplicativeExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            String sop;
            int op;
            this.in.peekWhitespace();
            if (this.in.peekc('+')) {
                op = 10;
                sop = "+";
            } else {
                if (!this.in.peekc('-')) break;
                op = 11;
                sop = "-";
            }
            this.in.peekWhitespace();
            Expr r_expr = this.parseMultiplicativeExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", sop, (Locator)this.in);
            }
            l_expr = new AdditiveExpr(op, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseMultiplicativeExpr() throws XPathException {
        Expr l_expr = this.parseUnaryExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            String sop;
            int op;
            this.in.peekWhitespace();
            if (this.in.peekc('*')) {
                op = 12;
                sop = "*";
            } else if (this.in.peek("mul")) {
                op = 12;
                sop = "mul";
            } else if (this.in.peek("div")) {
                op = 13;
                sop = "div";
            } else if (this.in.peek("mod")) {
                op = 14;
                sop = "mod";
            } else {
                if (!this.in.peek("quo")) break;
                op = 15;
                sop = "quo";
            }
            this.in.peekWhitespace();
            Expr r_expr = this.parseUnaryExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", sop, (Locator)this.in);
            }
            l_expr = new MultiplicativeExpr(op, l_expr, r_expr);
        }
        return l_expr;
    }

    Expr parseUnaryExpr() throws XPathException {
        if (this.in.peekc('-')) {
            this.in.peekWhitespace();
            Expr expr = this.parseUnionExpr();
            if (expr == null) {
                XPathException.fatal("INVALID_ROP", "-", (Locator)this.in);
            }
            return new AdditiveExpr(16, expr, null);
        }
        return this.parseUnionExpr();
    }

    protected Expr parseUnionExpr() throws XPathException {
        Expr l_expr = this.parsePathExpr();
        if (l_expr == null) {
            return null;
        }
        while (true) {
            this.in.peekWhitespace();
            if (!this.in.peekc('|')) break;
            int op = 20;
            this.in.peekWhitespace();
            Expr r_expr = this.parsePathExpr();
            if (r_expr == null) {
                XPathException.fatal("INVALID_ROP", "|", (Locator)this.in);
            }
            l_expr = new UnionExpr(l_expr, r_expr);
        }
        return l_expr;
    }

    protected Expr parsePathExpr() throws XPathException {
        Expr filter = this.parseFilterExpr();
        if (filter != null) {
            if (this.in.peek(PSEUDONAME_ROOT)) {
                if (this.in.peek(PSEUDONAME_ROOT)) {
                    Expr expr1 = this.parseRelativeLocationPath();
                    if (expr1 == null) {
                        XPathException.fatal("INVALID_ROP", "//", (Locator)this.in);
                    }
                    expr1 = this.compose(new StepExpr(7), expr1);
                    return this.compose(filter, expr1);
                }
                Expr expr1 = this.parseRelativeLocationPath();
                if (expr1 == null) {
                    XPathException.fatal("INVALID_ROP", PSEUDONAME_ROOT, (Locator)this.in);
                }
                return this.compose(filter, expr1);
            }
            return filter;
        }
        return this.parseLocationPath();
    }

    Expr parseFilterExpr() throws XPathException {
        Expr expr1;
        Expr current = this.parsePrimaryExpr();
        if (current == null) {
            return null;
        }
        FilterExpr filter = null;
        while ((expr1 = this.parsePredicate()) != null) {
            if (filter == null) {
                filter = new FilterExpr(current);
            }
            filter.appendPredicate(expr1);
        }
        if (filter != null) {
            return filter;
        }
        return current;
    }

    protected Expr parsePrimaryExpr() throws XPathException {
        Object obj = null;
        if (this.in.peekc('$')) {
            String s = this.in.peekSName();
            if (s == null) {
                XPathException.fatal("INVALID_VAR", (Locator)this.in);
            }
            return new VariableReferenceExpr(s);
        }
        if (this.in.peekc('(')) {
            this.in.peekWhitespace();
            Expr expr = this.parseOrExpr();
            if (expr == null) {
                XPathException.fatal("INVALID_CHAR", "(", (Locator)this.in);
            }
            this.in.peekWhitespace();
            if (this.in.peekc(')')) {
                XPathException.fatal("NEED_CHAR", ")", (Locator)this.in);
            }
            return expr;
        }
        obj = this.in.peekQuotedString();
        if (obj != null) {
            return new StringExpr((String)obj);
        }
        obj = this.in.peekNumber();
        if (obj != null) {
            return new NumberExpr(((Number)obj).doubleValue());
        }
        Expr expr = this.parseFunctionCall();
        if (expr != null) {
            return expr;
        }
        return null;
    }

    protected Expr parseFunctionCall() throws XPathException {
        String qname = this.in.peekNCName();
        if (qname == null) {
            return null;
        }
        if (qname.equals(NODETYPE_COMMENT) || qname.equals(NODETYPE_TEXT) || qname.equals(NODETYPE_NODE) || qname.equals(NODETYPE_PI)) {
            this.in.back(qname.length());
            return null;
        }
        if (!this.in.peekc('(')) {
            this.in.back(qname.length());
            return null;
        }
        FunctionExpr expr = FunctionExpr.getFunctionExpr(qname);
        if (expr == null) {
            this.in.back(qname.length());
            return null;
        }
        this.in.peekWhitespace();
        int k = 0;
        if (!this.in.peekc(')')) {
            while (true) {
                Expr arg = this.parseOrExpr();
                ++k;
                if (arg == null) {
                    XPathException.fatal("INVALID_PARAM", String.valueOf(k), (Locator)this.in);
                }
                expr.addParameter(arg);
                this.in.peekWhitespace();
                if (this.in.peekc(',')) {
                    this.in.peekWhitespace();
                    continue;
                }
                if (this.in.peekc(')')) break;
                XPathException.fatal("NEED_CHAR", ")", (Locator)this.in);
            }
        }
        try {
            expr.check();
        }
        catch (XPathException e) {
            XPathException e1 = new XPathException(e.getMessage(), this.in.getPublicId(), this.in.getSystemId(), this.in.getLineNumber(), this.in.getColumnNumber(), null);
            throw e1;
        }
        return expr;
    }

    private Double parseNumber() throws XPathException {
        int radix = 10;
        int type = 0;
        char c = this.in.getc();
        int num = 1;
        int k = 0;
        if (c == '-') {
            this.buf[k++] = c;
            c = this.in.getc();
            ++num;
            if (c < '0' || c > '9') {
                this.in.back(num);
                return null;
            }
        }
        if (c == '0') {
            this.buf[k++] = c;
            c = this.in.getc();
            if (c == 'x' || c == 'X') {
                radix = 16;
                c = this.in.getc();
            }
        } else if (c < '0' || c > '9') {
            this.in.back(num);
            return null;
        }
        if (radix == 10) {
            while (c != '\u0000') {
                if (c >= '0' && c <= '9') {
                    this.buf[k++] = c;
                } else if (c == '.') {
                    if (type < 2) {
                        type = 3;
                    }
                    this.buf[k++] = c;
                } else {
                    if (c != 'e' && c != 'E') {
                        this.in.ungetc();
                        break;
                    }
                    if (type < 2) {
                        type = 3;
                    }
                    this.buf[k++] = c;
                    if (this.in.peekc('+')) {
                        this.buf[k++] = 43;
                    }
                    if (this.in.peekc('-')) {
                        this.buf[k++] = 45;
                    }
                }
                c = this.in.getc();
            }
        } else {
            while (c != '\u0000') {
                if (c >= '0' && c <= '9') {
                    this.buf[k++] = c;
                } else {
                    if (!(c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                        this.in.ungetc();
                        break;
                    }
                    this.buf[k++] = c;
                }
                c = this.in.getc();
            }
        }
        try {
            return new Double(new String(this.buf, 0, k));
        }
        catch (Exception e) {
            XPathException.fatal(e, (Locator)this.in);
            return null;
        }
    }
}

