/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.ContentModel;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import java.util.Vector;

public class ContentModelNode
implements ContentModel {
    int type;
    boolean mixed;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public ContentModelNode(XSDDecl xsd, int type, String mixed) {
        this.xsd = xsd;
        this.type = type;
        this.setMixed(mixed);
    }

    public ContentModelNode(XSDDecl xsd, int type) {
        this.xsd = xsd;
        this.type = type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setMixed(String mixed) {
        this.mixed = mixed == null ? false : mixed.equals("true");
    }

    @Override
    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    @Override
    public String getMixed() {
        if (this.mixed) {
            return "true";
        }
        return "false";
    }

    @Override
    public boolean getMixedBool() {
        return this.mixed;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 58;
    }

    @Override
    public String getNodeName() {
        return this.getModeName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "ContentModel";
    }

    @Override
    public String getName() {
        return this.getModeName();
    }

    private String getModeName() {
        if (this.type == 0) {
            return "complexContent";
        }
        if (this.type == 1) {
            return "simpleContent";
        }
        return null;
    }

    public String getXML() {
        String typeRefbaseName = "";
        String prefix = "";
        StringBuffer sb = new StringBuffer();
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + this.getModeName());
        if (this.mixed) {
            sb.append(" mixed=\"true\"");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + this.getModeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

