/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.Derivation;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.util.Vector;

public class DerivationNode
implements Derivation {
    int derivationMode;
    XsdTypeRef base = null;
    String baseName = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public DerivationNode(XSDDecl xsd, int derivationMode, String baseName) {
        this.xsd = xsd;
        this.derivationMode = derivationMode;
        this.baseName = baseName;
    }

    public DerivationNode(XSDDecl xsd, int derivationMode, XsdTypeRef basenode) {
        this.xsd = xsd;
        this.derivationMode = derivationMode;
        this.base = basenode;
    }

    public DerivationNode(XSDDecl xsd) {
        this.xsd = xsd;
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public void setBase(XsdTypeRef base) {
        this.base = base;
    }

    @Override
    public XsdTypeRef getBase() {
        return this.base;
    }

    @Override
    public int getDerivationMode() {
        return this.derivationMode;
    }

    @Override
    public void setDerivationMode(int mode) {
        this.derivationMode = mode;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 62;
    }

    @Override
    public String getNodeName() {
        return this.getModeName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "Derivation";
    }

    @Override
    public String getName() {
        return this.getModeName();
    }

    private String getModeName() {
        if (this.derivationMode == 0) {
            return "restriction";
        }
        if (this.derivationMode == 1) {
            return "extension";
        }
        return null;
    }

    public String getXML() {
        String typeRefbaseName = "";
        String prefix = "";
        StringBuffer sb = new StringBuffer();
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + this.getModeName());
        if (this.base != null) {
            sb.append(" base=\"");
            typeRefbaseName = this.base.toString();
            XSDDecl tmpxsd = this.base.getXsdDecl();
            if (tmpxsd != null && this.xsd != null) {
                typeRefbaseName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.base.toString());
            }
            sb.append(typeRefbaseName);
            sb.append("\"");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + this.getModeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

