/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.IdentityConstraint;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import java.util.Vector;

public class IdentityConstraintNode
implements IdentityConstraint {
    String name = null;
    int type;
    String refer = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public IdentityConstraintNode(XSDDecl xsd, String name2, int type) {
        this.xsd = xsd;
        this.name = name2;
        this.type = type;
    }

    @Override
    public void setName(String name2) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setRefer(String refer) {
        this.refer = refer;
    }

    @Override
    public String getRefer() {
        return this.refer;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null;
    }

    @Override
    public int getNodeType() {
        return 59;
    }

    @Override
    public String getNodeName() {
        return this.getTypeName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    private String getTypeName() {
        if (this.type == 0) {
            return "unique";
        }
        if (this.type == 1) {
            return "key";
        }
        if (this.type == 2) {
            return "keyref";
        }
        return "";
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "IdentityConstraint";
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + this.getTypeName());
        if (this.name != null) {
            sb.append(" name=\"");
            sb.append(this.name);
            sb.append("\"");
        }
        if (this.refer != null && this.type == 2) {
            sb.append(" refer=\"");
            sb.append(this.refer);
            sb.append("\"");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + this.getTypeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

