/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.jxp.xsd.AnyAttributeNode;
import com.argo21.jxp.xsd.MgsDecl;
import com.argo21.jxp.xsd.ModelGroupNode;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdElementDeclNode;
import java.util.Vector;

public class MgsDeclNode
extends AnyAttributeNode
implements MgsDecl {
    int model;
    String minOcc;
    String maxOcc;

    public MgsDeclNode(XSDDecl xsd, int model) {
        super(xsd);
        this.xsd = xsd;
        this.model = model;
    }

    public void setModel(int model) {
        this.model = model;
    }

    @Override
    public int getModel() {
        return this.model;
    }

    @Override
    public void setMinOccours(String minOcc) {
        this.minOcc = minOcc;
    }

    @Override
    public int getMinOccours() {
        if (this.minOcc == null || this.minOcc == "") {
            return 1;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.minOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @Override
    public String getMinOccoursString() {
        return this.minOcc;
    }

    @Override
    public void setMaxOccours(String maxOcc) {
        this.maxOcc = maxOcc;
    }

    @Override
    public String getMaxOccoursString() {
        return this.maxOcc;
    }

    @Override
    public int getMaxOccours() {
        if (this.maxOcc == null || this.maxOcc == "") {
            return 1;
        }
        if (this.maxOcc.equals("unbounded")) {
            return 10000;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.maxOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    public boolean containsTag(String name2) {
        Vector childlist = this.children.getChildrenList();
        if (childlist.size() == 0) {
            return false;
        }
        int n = childlist.size();
        for (int i = 0; i < n; ++i) {
            ModelGroupNode gr;
            XsdDeclNode cp = (XsdDeclNode)childlist.elementAt(i);
            if (cp.getNodeType() == 54) {
                MgsDeclNode mg = (MgsDeclNode)cp;
                if (!mg.containsTag(name2)) continue;
                return true;
            }
            if (cp.getNodeType() == 50) {
                XsdElementDeclNode el = (XsdElementDeclNode)cp;
                if (name2.equals(el.getName())) {
                    return true;
                }
                XsdDeclNode elenode = el.getSubElementDecl(name2);
                if (elenode == null) continue;
                return true;
            }
            if (cp.getNodeType() != 56 || !(gr = (ModelGroupNode)cp).containsTag(name2)) continue;
            return true;
        }
        return false;
    }

    public void getChildElement(Vector elelist, XsdChildren child) {
        if (child == null) {
            return;
        }
        Vector childlist = child.getChildrenList();
        if (childlist.size() == 0) {
            return;
        }
        int n = childlist.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode cp = (XsdDeclNode)childlist.elementAt(i);
            if (cp.getNodeType() == 54) {
                MgsDeclNode mg = (MgsDeclNode)cp;
                elelist.add(cp);
                continue;
            }
            if (cp.getNodeType() == 50) {
                XsdElementDeclNode el = (XsdElementDeclNode)cp;
                elelist.add(cp);
                continue;
            }
            if (cp.getNodeType() != 56) continue;
            ModelGroupNode g = (ModelGroupNode)cp;
            elelist.add(cp);
        }
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 54;
    }

    @Override
    public String getName() {
        return this.getNodeName();
    }

    @Override
    public String getNodeName() {
        if (this.model == 0) {
            return "sequence";
        }
        if (this.model == 1) {
            return "choice";
        }
        if (this.model == 2) {
            return "any";
        }
        if (this.model == 3) {
            return "all";
        }
        return "Sequence";
    }

    @Override
    public String getNodeTypeName() {
        return "Mgs";
    }

    @Override
    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        String name2 = this.getNodeName();
        sb.append("<" + prefix + name2);
        if (this.minOcc != null) {
            sb.append(" minOccurs=\"" + this.minOcc + "\"");
        }
        if (this.maxOcc != null) {
            sb.append(" maxOccurs=\"" + this.maxOcc + "\"");
        }
        if (this.model == 2) {
            if (this.nameSpace != null) {
                sb.append(" namespace=\"").append(this.nameSpace).append("\"");
            }
            if (this.processContents != null) {
                sb.append(" processContents=\"").append(this.processContents).append("\"");
            }
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + name2 + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

