/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.MgsDeclNode;
import com.argo21.jxp.xsd.ModelGroup;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdElementDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.util.Vector;

public class ModelGroupNode
implements ModelGroup {
    String name = null;
    XsdTypeRef ref = null;
    String minOcc;
    String maxOcc;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public ModelGroupNode(XSDDecl xsd, String name2) {
        this.xsd = xsd;
        this.name = name2;
    }

    public ModelGroupNode(XSDDecl xsd, XsdTypeRef ref) {
        this.xsd = xsd;
        this.ref = ref;
    }

    @Override
    public void setMinOccours(String minOcc) {
        this.minOcc = minOcc;
    }

    @Override
    public String getMinOccoursString() {
        return this.minOcc;
    }

    @Override
    public int getMinOccours() {
        if (this.minOcc == null || this.minOcc == "") {
            return 1;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.minOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @Override
    public void setMaxOccours(String maxOcc) {
        this.maxOcc = maxOcc;
    }

    @Override
    public String getMaxOccoursString() {
        return this.maxOcc;
    }

    @Override
    public int getMaxOccours() {
        if (this.maxOcc == null || this.maxOcc == "") {
            return 1;
        }
        if (this.maxOcc.equals("unbounded")) {
            return 10000;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.maxOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @Override
    public String getName() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return this.name;
    }

    @Override
    public String getRefName() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return null;
    }

    @Override
    public XsdTypeRef getRef() {
        return this.ref;
    }

    public boolean isRef() {
        return this.ref != null;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 56;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "Group";
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        String name2 = this.getNodeName();
        String typeRefName = "";
        if (this.ref != null) {
            sb.append("<" + prefix + "group ref=\"");
            typeRefName = this.ref.toString();
            XSDDecl tmpxsd = this.ref.getXsdDecl();
            if (tmpxsd != null && this.xsd != null) {
                typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.ref.toString());
            }
            sb.append(typeRefName);
            sb.append("\"");
            if (this.minOcc != null) {
                sb.append(" minOccurs=\"" + this.minOcc + "\"");
            }
            if (this.maxOcc != null) {
                sb.append(" maxOccurs=\"" + this.maxOcc + "\"");
            }
        } else {
            sb.append("<" + prefix + "group name=\"");
            sb.append(name2);
            sb.append("\" ");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "group>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }

    public void getChildElement(Vector elelist, XsdChildren child) {
        if (child == null) {
            return;
        }
        Vector childlist = child.getChildrenList();
        if (childlist.size() == 0) {
            return;
        }
        int n = childlist.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode cp = (XsdDeclNode)childlist.elementAt(i);
            if (cp.getNodeType() == 54) {
                MgsDeclNode mg = (MgsDeclNode)cp;
                XsdChildren mgchild = mg.getChildren();
                this.getChildElement(elelist, mgchild);
                continue;
            }
            if (cp.getNodeType() == 50) {
                XsdElementDeclNode el = (XsdElementDeclNode)cp;
                elelist.add(cp);
                continue;
            }
            if (cp.getNodeType() != 56) continue;
            ModelGroupNode g = (ModelGroupNode)cp;
            elelist.add(cp);
        }
    }

    public boolean containsTag(String name2) {
        Vector childlist = null;
        if (this.ref != null) {
            XsdDeclNode refnode = this.ref.getDeclNode();
            XsdChildren refChildren = refnode.getChildren();
            if (refChildren == null) {
                return false;
            }
            childlist = refChildren.getChildrenList();
        } else {
            if (this.children == null) {
                return false;
            }
            childlist = this.children.getChildrenList();
        }
        if (childlist == null) {
            return false;
        }
        if (childlist.size() == 0) {
            return false;
        }
        int n = childlist.size();
        for (int i = 0; i < n; ++i) {
            ModelGroupNode gr;
            XsdDeclNode cp = (XsdDeclNode)childlist.elementAt(i);
            if (cp.getNodeType() == 54) {
                MgsDeclNode mg = (MgsDeclNode)cp;
                if (!mg.containsTag(name2)) continue;
                return true;
            }
            if (cp.getNodeType() == 50) {
                XsdElementDeclNode el = (XsdElementDeclNode)cp;
                if (name2.equals(el.getName())) {
                    return true;
                }
                XsdDeclNode elenode = el.getSubElementDecl(name2);
                if (elenode == null) continue;
                return true;
            }
            if (cp.getNodeType() != 56 || !(gr = (ModelGroupNode)cp).containsTag(name2)) continue;
            return true;
        }
        return false;
    }

    public int getChildMgs() {
        if (this.children == null) {
            return 0;
        }
        Vector childlist = this.children.getChildrenList();
        if (childlist.size() == 0) {
            return 0;
        }
        int n = childlist.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode cp = (XsdDeclNode)childlist.elementAt(i);
            if (cp.getNodeType() != 54) continue;
            MgsDeclNode mg = (MgsDeclNode)cp;
            return mg.getModel();
        }
        return 0;
    }
}

