/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.MessageCatalog;
import com.argo21.common.lang.XsdDataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.XmlParser;
import com.argo21.jxp.xsd.AnyAttributeNode;
import com.argo21.jxp.xsd.AttributeGroupNode;
import com.argo21.jxp.xsd.ComplexTypeNode;
import com.argo21.jxp.xsd.ContentModelNode;
import com.argo21.jxp.xsd.DerivationNode;
import com.argo21.jxp.xsd.IdentityConstraintNode;
import com.argo21.jxp.xsd.MgsDeclNode;
import com.argo21.jxp.xsd.ModelGroupNode;
import com.argo21.jxp.xsd.ParseErrorHandler;
import com.argo21.jxp.xsd.SchemaDeclNode;
import com.argo21.jxp.xsd.SelectorFieldNode;
import com.argo21.jxp.xsd.SimpleTypeNode;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDException;
import com.argo21.jxp.xsd.XSDExtractor;
import com.argo21.jxp.xsd.XSDSchemaDecl;
import com.argo21.jxp.xsd.XsdAnnotationNode;
import com.argo21.jxp.xsd.XsdAppinfoDocNode;
import com.argo21.jxp.xsd.XsdAttDef;
import com.argo21.jxp.xsd.XsdAttDefNode;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdChildrenNode;
import com.argo21.jxp.xsd.XsdCommentDecl;
import com.argo21.jxp.xsd.XsdCommentDeclNode;
import com.argo21.jxp.xsd.XsdDataTypeImpl;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdDeclNodeList;
import com.argo21.jxp.xsd.XsdDeclNodeListImpl;
import com.argo21.jxp.xsd.XsdElementDecl;
import com.argo21.jxp.xsd.XsdElementDeclNode;
import com.argo21.jxp.xsd.XsdFacetNode;
import com.argo21.jxp.xsd.XsdImportNode;
import com.argo21.jxp.xsd.XsdIncludeNode;
import com.argo21.jxp.xsd.XsdListNode;
import com.argo21.jxp.xsd.XsdNotationDeclNode;
import com.argo21.jxp.xsd.XsdPIDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;
import com.argo21.jxp.xsd.XsdTypeRefNode;
import com.argo21.jxp.xsd.XsdUnionNode;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDDocument
implements XSDDecl,
XSDSchemaDecl {
    protected Vector xsds = new Vector(1);
    protected XsdDeclNodeListImpl nodes = new XsdDeclNodeListImpl(40);
    protected Hashtable elementDecls = new Hashtable(11);
    protected Hashtable elementDeclsPath = new Hashtable(11);
    protected Hashtable entityDecls = new Hashtable(11);
    protected Hashtable attrDecls = new Hashtable(11);
    protected Hashtable globalElementDecls = new Hashtable(11);
    protected Hashtable globalAttrDecls = new Hashtable(11);
    protected Hashtable globalComplexDecls = new Hashtable(11);
    protected Hashtable globalSimpleDecls = new Hashtable(11);
    protected Hashtable globalModelgrpDecls = new Hashtable(11);
    protected Hashtable globalAttrgrpDecls = new Hashtable(11);
    protected Vector xsdDataTypeDecls = new Vector(10);
    protected Hashtable dataTypeDecls = new Hashtable();
    protected Vector typeNoneDecls = new Vector(11);
    protected Document doc = null;
    protected String name = null;
    protected String publicId = null;
    protected String systemId = null;
    protected String url = null;
    protected String nameSpace = null;
    protected Exception lastErr = null;
    protected Properties properties = new Properties();
    protected static String eol;
    private XReader docReader = null;
    static MessageCatalog msgCatalog;
    private XsdElementDeclNode rootElement = null;

    public static String getErrorMessage(String msgId, Object[] paraments) {
        return msgCatalog.getMessage(msgId, paraments);
    }

    public XSDDocument() {
        this(null, null);
    }

    public XSDDocument(String name2) {
        this(name2, null);
    }

    public XSDDocument(String name2, String url) {
        this.name = name2;
        this.url = url;
    }

    public XSDDocument(String nameSpace, String url, boolean isDataType) {
        this.nameSpace = nameSpace;
        this.url = url;
        if (isDataType) {
            this.createDataType();
        }
    }

    @Override
    public void removeDecls() throws XSDException {
        int k = 0;
        while (k < this.nodes.size()) {
            this.nodes.removeElementAt(k);
        }
        this.elementDecls.clear();
        this.attrDecls.clear();
        this.globalElementDecls.clear();
        this.globalAttrDecls.clear();
        this.globalComplexDecls.clear();
        this.globalSimpleDecls.clear();
        this.globalModelgrpDecls.clear();
        this.globalAttrgrpDecls.clear();
        this.typeNoneDecls.clear();
        this.entityDecls.clear();
        this.xsdDataTypeDecls.clear();
    }

    public static XsdElementDecl createElementDecl(XSDDocument xsd, String eleName, String contentspec) throws XSDException {
        return new XsdElementDeclNode((XSDDecl)xsd, eleName, contentspec.toCharArray());
    }

    public static XsdCommentDecl createCommentDecl(XSDDocument xsd, String text) throws XSDException {
        XsdCommentDeclNode decl = new XsdCommentDeclNode(xsd, text);
        return decl;
    }

    @Override
    public XsdElementDecl createElementDecl(String eleName, String contentspec) throws XSDException {
        XsdElementDeclNode decl = new XsdElementDeclNode((XSDDecl)this, eleName, contentspec.toCharArray());
        return decl;
    }

    public XsdCommentDecl createCommentDecl(String text) throws XSDException {
        return new XsdCommentDeclNode(this, text);
    }

    @Override
    public void appendChild(XsdDeclNode newChild) throws XSDException {
        int type = newChild.getNodeType();
        boolean isGlobalNode = false;
        XsdDeclNode parent = newChild.getParentDecl();
        if (parent != null && parent.getNodeType() == 71) {
            isGlobalNode = true;
        }
        if (type == 50) {
            String s = newChild.getNodeName();
            if (s != null) {
                XsdElementDeclNode elemdecl = (XsdElementDeclNode)this.elementDecls.get(s);
                if (elemdecl != null) {
                    ((XsdElementDeclNode)newChild).attributeDefs = elemdecl.attributeDefs;
                }
                this.elementDecls.put(s, newChild);
                String path = this.getNamePath(newChild);
                this.elementDeclsPath.put(path, newChild);
                if (isGlobalNode) {
                    this.globalElementDecls.put(s, newChild);
                }
            }
            this.nodes.addElement(newChild);
        } else if (type == 52) {
            String s = newChild.getNodeName();
            if (s != null && isGlobalNode) {
                this.globalComplexDecls.put(s, newChild);
            }
            this.nodes.addElement(newChild);
        } else if (type == 53) {
            String s = newChild.getNodeName();
            if (s != null && isGlobalNode) {
                this.globalSimpleDecls.put(s, newChild);
            }
            this.nodes.addElement(newChild);
        } else if (type == 56) {
            String s = newChild.getNodeName();
            if (s != null && isGlobalNode) {
                this.globalModelgrpDecls.put(s, newChild);
            }
            this.nodes.addElement(newChild);
        } else if (type == 57) {
            String s = newChild.getNodeName();
            if (s != null && isGlobalNode) {
                this.globalAttrgrpDecls.put(s, newChild);
            }
            this.nodes.addElement(newChild);
        } else if (type == 55) {
            XsdAttDef attdef = (XsdAttDef)newChild;
            String attname = attdef.getAttributeName();
            String refname = attdef.getRefName();
            if (attname == null && refname == null) {
                XSDDocument.fatal("ATTR_NEED_ELEM", this, new Object[]{attdef.getNodeName()});
            }
            if (refname == null) {
                this.attrDecls.put(attname, newChild);
                if (isGlobalNode) {
                    this.globalAttrDecls.put(attname, newChild);
                }
            }
            this.nodes.addElement(newChild);
        } else {
            this.nodes.addElement(newChild);
        }
    }

    private String getNamePath(XsdDeclNode node) {
        StringBuffer sb = new StringBuffer();
        XsdDeclNode parent = node.getParentDecl();
        if (parent != null) {
            sb.append(this.getNamePath(parent));
        }
        if (node.getNodeType() == 50) {
            sb.append("/");
            sb.append(node.getNodeName());
        }
        return sb.toString();
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public XsdDeclNode getFirstChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        XsdDeclNode node = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 71) continue;
            return node;
        }
        return null;
    }

    @Override
    public XsdDeclNode getLastChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        return this.nodes.elementAt(this.nodes.size() - 1);
    }

    @Override
    public String getNodeName() {
        String s = this.properties.getValue("name");
        if (s != null) {
            return s;
        }
        if (this.name != null) {
            return this.name;
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 50) continue;
            return node.getNodeName();
        }
        return null;
    }

    @Override
    public XsdElementDecl getRootElement() {
        return this.rootElement;
    }

    @Override
    public int getNodeType() {
        return 72;
    }

    public int getXSDType() {
        return 0;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties ps) {
        this.properties = ps;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void putProperty(String name2, String value) {
        this.properties.repleace(name2, value);
    }

    @Override
    public String getVersion() {
        return this.properties.getValue("version");
    }

    @Override
    public String getEncoding() {
        return this.properties.getValue("encoding");
    }

    @Override
    public String getSchemaPrefix(boolean sep) {
        String prefix = this.properties.getValue("schemaPrefix");
        if (prefix == null) {
            return "";
        }
        if (sep) {
            if (prefix == "") {
                return prefix;
            }
            return prefix + ":";
        }
        return prefix;
    }

    @Override
    public String getInstancePrefix(boolean sep) {
        String prefix = this.properties.getValue("instancePrefix");
        if (prefix == null) {
            return "";
        }
        if (sep) {
            if (prefix == "") {
                return prefix;
            }
            return prefix + ":";
        }
        return prefix;
    }

    @Override
    public String getSchemaLocation() {
        String location = this.properties.getValue("schemaLocation");
        if (location == null) {
            return "";
        }
        if (location == "") {
            return location;
        }
        return location;
    }

    @Override
    public String getPluralSchemaLocation() {
        String location = this.properties.getValue("pluralSchemaLocation");
        if (location == null) {
            return "";
        }
        return location;
    }

    @Override
    public String getPluralSchemaLocationURL() {
        String location = this.properties.getValue("pluralSchemaLocationURL");
        if (location == null) {
            return "";
        }
        return location;
    }

    @Override
    public boolean getWithxsd() {
        String with = this.properties.getValue("withxsd");
        if (with == null) {
            return false;
        }
        return with.equals("YES");
    }

    @Override
    public Document getOwnerDocument() {
        return this.doc;
    }

    @Override
    public XsdDeclNode getPreviousSibling() {
        return null;
    }

    @Override
    public XsdDeclNode getNextSibling() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.nodes.size() > 0;
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.write(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public XsdDeclNode getPreviousChild(XsdDeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (--index >= 0) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    @Override
    public XsdDeclNode getNextChild(XsdDeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (++index < this.nodes.size()) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    @Override
    public XsdDeclNodeList getAllDeclNode() {
        return this.nodes;
    }

    @Override
    public Vector getAllDeclName() {
        int n = this.nodes.size();
        Vector<String> names = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            XsdDeclNode decl = this.nodes.elementAt(i);
            names.addElement(decl.getNodeName());
        }
        return names;
    }

    @Override
    public void write(Writer out) throws IOException {
        this.write(out, true);
    }

    @Override
    public void write(Writer out, boolean xmlPI) throws IOException {
        String s = this.properties.getValue("version");
        String s1 = this.properties.getValue("encoding");
        if (xmlPI && (s != null || s1 != null)) {
            out.write("<?xml ");
            if (s != null) {
                out.write("version=\"");
                out.write(s);
                out.write("\"");
                if (s1 != null) {
                    out.write(" ");
                }
            }
            if (s1 != null) {
                out.write("encoding=\"");
                out.write(s1);
                out.write("\"");
            }
            out.write("?>");
            out.write(eol);
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() == 71) {
                out.write(node.toString());
                out.write(eol);
                break;
            }
            out.write(node.toString());
        }
    }

    public void writePI(Writer out) throws IOException {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 7) continue;
            out.write(node.toString());
            out.write(eol);
        }
    }

    public void writeEx(Writer out, boolean xmlPI) throws IOException {
        XsdDeclNode node;
        int i;
        String s = this.properties.getValue("version");
        String s1 = this.properties.getValue("encoding");
        if (xmlPI && (s != null || s1 != null)) {
            out.write("<?xml ");
            if (s != null) {
                out.write("version=\"");
                out.write(s);
                out.write("\"");
                if (s1 != null) {
                    out.write(" ");
                }
            }
            if (s1 != null) {
                out.write("encoding=\"");
                out.write(s1);
                out.write("\"");
            }
            out.write("?>");
            out.write(eol);
        }
        int n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            if (node.getNodeType() == 71) {
                out.write(node.toString());
                out.write(eol);
                break;
            }
            out.write(node.toString());
        }
        out.write(eol);
        n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            String attr;
            DataTypeDecl dt;
            node = this.nodes.elementAt(i);
            int type = node.getNodeType();
            if (type == 50) {
                dt = node.getDataTypeDecl();
                if (dt == null) continue;
                XsdElementDecl element = (XsdElementDecl)node;
                attr = "element=\"" + element.getNodeName() + "\"";
                s = dt.getXML(attr);
                if (s == null) continue;
                out.write(dt.getXML(attr));
                out.write(eol);
                continue;
            }
            if (type != 55 || (dt = node.getDataTypeDecl()) == null) continue;
            XsdAttDef attdef = (XsdAttDef)node;
            attr = "element=\"" + attdef.getElementName() + "\" attr=\"" + attdef.getNodeName() + "\"";
            s = dt.getXML(attr);
            if (s == null) continue;
            out.write(dt.getXML(attr));
            out.write(eol);
        }
    }

    @Override
    public XsdDeclNode getTypeXsdDeclNode(String datatype, int nodeType, int findType) {
        XsdDeclNode declnode = null;
        block0 : switch (findType) {
            case 0: {
                switch (nodeType) {
                    case 50: {
                        declnode = (XsdDeclNode)this.dataTypeDecls.get(datatype);
                        if (declnode == null) {
                            declnode = this.getGlobalComplexDecls(datatype);
                        }
                        if (declnode != null) break block0;
                        declnode = this.getGlobalSimpleDecls(datatype);
                        break block0;
                    }
                    case 55: {
                        declnode = (XsdDeclNode)this.dataTypeDecls.get(datatype);
                        if (declnode != null) break block0;
                        declnode = this.getGlobalSimpleDecls(datatype);
                        break block0;
                    }
                    case 64: {
                        declnode = (XsdDeclNode)this.dataTypeDecls.get(datatype);
                        if (declnode != null) break block0;
                        declnode = this.getGlobalSimpleDecls(datatype);
                        break block0;
                    }
                    case 63: {
                        declnode = (XsdDeclNode)this.dataTypeDecls.get(datatype);
                        if (declnode != null) break block0;
                        declnode = this.getGlobalSimpleDecls(datatype);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (nodeType) {
                    case 50: {
                        declnode = this.getGlobalElementDecls(datatype);
                        break block0;
                    }
                    case 55: {
                        declnode = this.getGlobalAttrDecls(datatype);
                        break block0;
                    }
                    case 57: {
                        declnode = this.getGlobalAttrgrpDecls(datatype);
                        break block0;
                    }
                    case 56: {
                        declnode = this.getGlobalModelgrpDecls(datatype);
                        break block0;
                    }
                }
                break;
            }
            case 2: 
            case 62: {
                declnode = (XsdDeclNode)this.dataTypeDecls.get(datatype);
                if (declnode == null) {
                    declnode = this.getGlobalSimpleDecls(datatype);
                }
                if (declnode != null) break;
                declnode = this.getGlobalComplexDecls(datatype);
                break;
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalComplexDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalComplexDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalComplexDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalSimpleDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalSimpleDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalSimpleDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalElementDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalElementDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalElementDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalAttrDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalAttrDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalAttrDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalAttrgrpDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalAttrgrpDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalAttrgrpDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    public XsdDeclNode getGlobalModelgrpDecls(String datatype) {
        XsdDeclNode declnode = (XsdDeclNode)this.globalModelgrpDecls.get(datatype);
        if (declnode == null) {
            int n = this.xsds.size();
            XSDDocument tmpxsd = null;
            for (int i = 0; i < n && (declnode = (tmpxsd = (XSDDocument)this.xsds.get(i)).getGlobalModelgrpDecls(datatype)) == null; ++i) {
            }
        }
        return declnode;
    }

    @Override
    public XsdDeclNodeList getAttListDecls(String element) {
        XsdElementDeclNode elemdecl = (XsdElementDeclNode)this.getElementDecl(element);
        if (elemdecl == null) {
            return null;
        }
        return elemdecl.getAttListDecls();
    }

    public XsdAttDef getAttDef(String attribute) {
        XsdDeclNode decl = (XsdDeclNode)this.attrDecls.get(attribute);
        if (decl != null && decl.getNodeType() == 55) {
            return (XsdAttDef)decl;
        }
        return null;
    }

    @Override
    public XsdAttDef getAttListDecl(String element, String attribute) {
        XsdElementDecl elementdecl = this.getElementDecl(element);
        if (elementdecl == null) {
            return null;
        }
        return elementdecl.getAttListDecl(attribute);
    }

    @Override
    public XsdElementDecl getElementDecl(String element) {
        XsdDeclNode decl = (XsdDeclNode)this.elementDecls.get(element);
        if (decl != null && decl.getNodeType() == 50) {
            return (XsdElementDecl)decl;
        }
        decl = this.getExternalElementDecls(this.xsds, element);
        if (decl != null && decl.getNodeType() == 50) {
            return (XsdElementDecl)decl;
        }
        return null;
    }

    public XsdDeclNode getExternalElementDecls(Vector xsds, String element) {
        int n = xsds.size();
        XSDDocument externalxsd = null;
        XsdDeclNode decl = null;
        for (int i = 0; i < n; ++i) {
            externalxsd = (XSDDocument)xsds.get(i);
            decl = (XsdDeclNode)externalxsd.elementDecls.get(element);
            if (!(decl != null ? decl.getNodeType() == 50 : (decl = this.getExternalElementDecls(externalxsd.xsds, element)) != null)) continue;
            return decl;
        }
        return null;
    }

    @Override
    public XsdElementDecl getElementDecl(Node node) {
        String name2 = this.getNodeNamePath(node);
        return this.getElementDeclByName(name2);
    }

    private XsdElementDecl getElementDeclByName(String name2) {
        XsdDeclNode decl = (XsdDeclNode)this.elementDeclsPath.get(name2);
        if (decl != null && decl.getNodeType() == 50) {
            return (XsdElementDecl)decl;
        }
        decl = this.getExternalElementDeclsPath(this.xsds, name2);
        if (decl != null && decl.getNodeType() == 50) {
            return (XsdElementDecl)decl;
        }
        String path = this.deleteRootNodeName(name2);
        while (path != null) {
            decl = (XsdDeclNode)this.elementDeclsPath.get(path);
            if (decl != null && decl.getNodeType() == 50) {
                return (XsdElementDecl)decl;
            }
            decl = this.getExternalElementDeclsPath(this.xsds, path);
            if (decl != null && decl.getNodeType() == 50) {
                return (XsdElementDecl)decl;
            }
            path = this.deleteRootNodeName(path);
        }
        return null;
    }

    private String getNodeNamePath(Node node) {
        StringBuffer sb = new StringBuffer();
        Node parent = node.getParentNode();
        if (parent != null) {
            sb.append(this.getNodeNamePath(parent));
        }
        if (node.getNodeType() == 1) {
            sb.append("/");
            sb.append(node.getLocalName());
        }
        return sb.toString();
    }

    private String deleteRootNodeName(String path) {
        if (path.length() <= 0) {
            return null;
        }
        int slash = (path = path.substring(1)).indexOf("/");
        if (slash == -1) {
            return null;
        }
        return path.substring(slash);
    }

    public XsdDeclNode getExternalElementDeclsPath(Vector xsds, String element) {
        int n = xsds.size();
        XSDDocument externalxsd = null;
        XsdDeclNode decl = null;
        for (int i = 0; i < n; ++i) {
            externalxsd = (XSDDocument)xsds.get(i);
            decl = (XsdDeclNode)externalxsd.elementDeclsPath.get(element);
            if (!(decl != null ? decl.getNodeType() == 50 : (decl = this.getExternalElementDeclsPath(externalxsd.xsds, element)) != null)) continue;
            return decl;
        }
        return null;
    }

    @Override
    public Enumeration getAllEntityDecls() {
        return this.entityDecls.elements();
    }

    public Vector getXsds() {
        return this.xsds;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return null;
    }

    @Override
    public XsdChildren getChildren() {
        return null;
    }

    @Override
    public void setChildren(XsdChildren children) {
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
    }

    @Override
    public void createXmlSchemaDocument(String xmlns) {
        XSDDocument xsd = new XSDDocument(xmlns, null, true);
        this.xsds.addElement(xsd);
    }

    @Override
    public boolean createExternalXSDDocument(String xmlns, String schemaLocation, String parentSchema) {
        XSDDocument newXsd = new XSDDocument(xmlns, schemaLocation, false);
        try {
            newXsd.load(schemaLocation, parentSchema);
            newXsd.resolveAttrOnElement();
            this.xsds.addElement(newXsd);
            return true;
        }
        catch (XSDException e) {
            Debug.println(e);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Debug.println(e);
            return false;
        }
    }

    public String getPrefixInputStream(XReader in) throws IOException, XSDException {
        String prefix;
        block2: {
            prefix = null;
            String nsPrefix = null;
            String nameSpace = null;
            while (true) {
                in.peekWhitespace();
                in.skipTo("xmlns");
                if (in.isEOF()) break block2;
                nsPrefix = "";
                nameSpace = "";
                if (in.peek(":")) {
                    nsPrefix = in.peekXmlName();
                }
                in.peekWhitespace();
                if (!in.peek("=")) continue;
                in.peekWhitespace();
                nameSpace = in.peekQuotedString();
                if (nameSpace.equals("http://www.w3.org/2001/XMLSchema")) break;
            }
            prefix = nsPrefix;
        }
        return prefix;
    }

    public boolean parseXMLSchema(XReader input, String prefix) throws XSDException {
        char[] val = this.getSchemaForSchemasStringBuf(input, prefix);
        if (val == null) {
            XSDDocument.fatal("INVALID_IMPORT_XSD", (Locator)input);
            return false;
        }
        XReader in = XReader.createReader(val, null);
        InputSource is = new InputSource(in);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            spf.setFeature("http://xml.org/sax/features/namespaces", true);
            spf.setFeature("http://xml.org/sax/features/validation", true);
            spf.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
            return false;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            return false;
        }
        SAXParser parser = null;
        try {
            parser = spf.newSAXParser();
        }
        catch (SAXException ex) {
            System.err.println("Parser creation failed: " + ex.getMessage());
            return false;
        }
        catch (ParserConfigurationException ex) {
            System.err.println("Parser creation failed: " + ex.getMessage());
            return false;
        }
        try {
            parser.parse(is, (DefaultHandler)new ParseErrorHandler());
        }
        catch (SAXParseException err) {
            XSDDocument.fatal(err, "INVALID_IMPORT_XSD", in);
        }
        catch (SAXException ee) {
            XSDDocument.fatal(ee, "INVALID_IMPORT_XSD", in);
        }
        catch (IOException ei) {
            XSDDocument.fatal(ei, "INVALID_IMPORT_XSD", in);
        }
        return true;
    }

    public char[] getSchemaForSchemasStringBuf(XReader in, String prefix) {
        if (prefix != null && prefix != "") {
            prefix = prefix + ":";
        }
        in.peekWhitespace();
        StringBuffer sb = new StringBuffer();
        String xmldef = null;
        Object xmlns = null;
        String xmlsch = null;
        xmldef = in.readStringTo("<" + prefix + "schema", false);
        sb.append(xmldef + "<" + prefix + "schema");
        String targetNamespace = null;
        Hashtable<String, String> xmlnsList = new Hashtable<String, String>();
        String version = null;
        String finalDefault = null;
        String blockDefault = null;
        String elementFormDefault = null;
        String attributeFormDefault = null;
        while (true) {
            in.peekWhitespace();
            if (in.isEOF() || in.peek(">")) break;
            if (in.peek("targetNamespace")) {
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                targetNamespace = in.peekQuotedString();
                continue;
            }
            if (in.peek("xmlns")) {
                String nsPrefix = in.peek(":") ? in.peekXmlName() : "none";
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                String nameSpace = in.peekQuotedString();
                xmlnsList.put(nsPrefix, nameSpace);
                continue;
            }
            if (in.peek("elementFormDefault")) {
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                elementFormDefault = in.peekQuotedString();
                continue;
            }
            if (in.peek("attributeFormDefault")) {
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                attributeFormDefault = in.peekQuotedString();
                continue;
            }
            if (in.peek("version")) {
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                version = in.peekQuotedString();
                continue;
            }
            if (in.peek("finalDefault")) {
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                finalDefault = in.peekQuotedString();
                continue;
            }
            if (!in.peek("blockDefault")) break;
            in.peekWhitespace();
            in.peek("=");
            in.peekWhitespace();
            blockDefault = in.peekQuotedString();
        }
        Enumeration enumKey = xmlnsList.keys();
        String key = null;
        Object nsPrefix = null;
        String tmpNSapce = null;
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            tmpNSapce = (String)xmlnsList.get(key);
            key = key == "none" ? "" : ":" + key;
            sb.append(" xmlns" + key + "=\"" + tmpNSapce + "\"");
        }
        if (targetNamespace != null) {
            sb.append(" targetNamespace=\"" + targetNamespace + "\"");
        }
        if (elementFormDefault != null) {
            sb.append(" elementFormDefault=\"" + elementFormDefault + "\"");
        }
        if (attributeFormDefault != null) {
            sb.append(" attributeFormDefault=\"" + attributeFormDefault + "\"");
        }
        if (blockDefault != null) {
            sb.append(" blockDefault=\"" + blockDefault + "\"");
        }
        if (finalDefault != null) {
            sb.append(" finalDefault=\"" + finalDefault + "\"");
        }
        if (version != null) {
            sb.append(" version=\"" + version + "\"");
        }
        URL url = XSDDocument.class.getResource("valid/XMLSchema.xsd");
        String urlbuf = url.toString();
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"http://www.w3.org/2001/XMLSchema " + urlbuf + "\">");
        in.peekWhitespace();
        xmlsch = in.readStringTo("schema>", false);
        sb.append(xmlsch + "schema>");
        int len = sb.length();
        char[] retval = new char[len];
        sb.getChars(0, len, retval, 0);
        return retval;
    }

    public boolean parseXSDDecl(XReader in, boolean isParse, String parentSchema) throws IOException, XSDException {
        XsdTypeRef typenode;
        XsdChildren childNode;
        String encoding;
        String version;
        block11: {
            version = null;
            encoding = null;
            childNode = null;
            if (isParse && !in.isEOF()) {
                try {
                    if (!this.parseXMLSchema(in, this.getSchemaPrefix(false))) {
                        return false;
                    }
                }
                catch (XSDException ex) {
                    XSDDocument.fatal(ex, (Locator)in);
                }
                in.top();
            }
            if (in.peek("<?xml")) {
                while (true) {
                    in.peekWhitespace();
                    if (in.isEOF()) break block11;
                    if (in.peek("version")) {
                        in.peekWhitespace();
                        in.peek("=");
                        in.peekWhitespace();
                        version = in.peekQuotedString();
                        in.peekWhitespace();
                    }
                    if (!in.peek("encoding")) break;
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    encoding = in.peekQuotedString();
                    in.peekWhitespace();
                }
                if (in.peek("?>")) {
                    // empty if block
                }
            }
        }
        this.properties.append("version", version);
        this.properties.append("encoding", encoding);
        this.parseXSDDeclNode(in, childNode, parentSchema);
        int n = this.typeNoneDecls.size();
        for (int i = 0; i < n; ++i) {
            typenode = (XsdTypeRef)this.typeNoneDecls.get(i);
            if (typenode.isTypeNode()) continue;
            this.findTypeReferenceProc(typenode, typenode.getNodePrefix(), typenode.getNodeString(), typenode.getTargetNodeType(), typenode.getTargetFindType(), true);
        }
        Iterator iterator = this.typeNoneDecls.iterator();
        while (iterator.hasNext()) {
            typenode = (XsdTypeRef)iterator.next();
            if (!typenode.isTypeNode()) continue;
            iterator.remove();
        }
        if (this.typeNoneDecls.size() > 0) {
            XSDDocument.fatal("INVALID_REF", (Locator)in);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseXSDDeclNode(XReader in, XsdChildren childNode, String parentSchema) throws XSDException {
        try {
            do {
                in.peekWhitespace();
                if (in.isEOF()) return true;
            } while (this.parseSchemaDecl(in, childNode, parentSchema) || this.parseIncludeDecl(in, childNode, parentSchema) || this.parseImportDecl(in, childNode, parentSchema) || this.parseAnyAttributeDecl(in, childNode, parentSchema) || this.parseElementDecl(in, childNode, parentSchema) || this.parseComplexTypeDecl(in, childNode, parentSchema) || this.parseSimpleTypeDecl(in, childNode, parentSchema) || this.parseMgsDecl(in, childNode, parentSchema) || this.parseAttributeGroupDecl(in, childNode, parentSchema) || this.parseAttributeDecl(in, childNode, parentSchema) || this.parseGroupDecl(in, childNode, parentSchema) || this.parseDerivationDecl(in, childNode, parentSchema) || this.parseContentModelDecl(in, childNode, parentSchema) || this.parseFacetDecl(in, childNode, parentSchema) || this.parseListDecl(in, childNode, parentSchema) || this.parseUnionDecl(in, childNode, parentSchema) || this.parseIdentityDecl(in, childNode, parentSchema) || this.parseSelectorFieldDecl(in, childNode, parentSchema) || this.parseNotationDecl(in, childNode, parentSchema) || this.parsePI(in, childNode, parentSchema) || this.parseComment(in, childNode, parentSchema) || this.parseAnnotationDecl(in, childNode, parentSchema) || this.parseAppinfoDocDecl(in, childNode) || this.parseRedifine(in, childNode) || this.parseDataDecl(in));
            if (!in.isChar(']')) return true;
            return true;
        }
        catch (IOException e) {
            XSDDocument.fatal(e, (Locator)in);
        }
        return true;
    }

    protected boolean parseRedifine(XReader in, XsdChildren childNode) throws IOException, XSDException {
        String prefix = this.getSchemaPrefix(true);
        if (!in.peek("<" + prefix + "redefine")) {
            return false;
        }
        XSDDocument.fatal("INVALID_REDEFINE", (Locator)in);
        return false;
    }

    protected boolean parseSchemaDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block25: {
            XsdDeclNode xsdDeclNode;
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "schema")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "schema")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            SchemaDeclNode decl = null;
            XsdChildrenNode newChild = null;
            String targetNamespace = null;
            Object xmlns = null;
            Hashtable<String, String> xmlnsList = new Hashtable<String, String>();
            String version = null;
            String finalDefault = null;
            String blockDefault = null;
            String elementFormDefault = null;
            String attributeFormDefault = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block25;
                if (in.peek("targetNamespace")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_SCHEMA", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    targetNamespace = in.peekQuotedString();
                    continue;
                }
                if (in.peek("xmlns")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_SCHEMA", (Locator)in);
                    }
                    String nsPrefix = in.peek(":") ? in.peekXmlName() : "none";
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    String nameSpace = in.peekQuotedString();
                    xmlnsList.put(nsPrefix, nameSpace);
                    if (!nameSpace.equals("http://www.w3.org/2001/XMLSchema")) continue;
                    this.createXmlSchemaDocument(nameSpace);
                    continue;
                }
                if (in.peek("elementFormDefault")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    elementFormDefault = in.peekQuotedString();
                    continue;
                }
                if (in.peek("attributeFormDefault")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    attributeFormDefault = in.peekQuotedString();
                    continue;
                }
                if (in.peek("version")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    version = in.peekQuotedString();
                    continue;
                }
                if (in.peek("finalDefault")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    finalDefault = in.peekQuotedString();
                    continue;
                }
                if (in.peek("blockDefault")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    blockDefault = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                int n = xmlnsList.size();
                if (n != 0) {
                    decl = new SchemaDeclNode(this, xmlnsList);
                }
                if (decl == null) {
                    return false;
                }
                decl.setAttributeFormDefault(attributeFormDefault);
                decl.setElementFormDefault(elementFormDefault);
                decl.setTargetNamespace(targetNamespace);
                decl.setBlockDefault(blockDefault);
                decl.setFinalDefault(finalDefault);
                decl.setVersion(version);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    xsdDeclNode = childNode.getParentDecl();
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.nameSpace = targetNamespace != null ? targetNamespace : null;
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                int n = xmlnsList.size();
                if (n != 0) {
                    decl = new SchemaDeclNode(this, xmlnsList);
                }
                if (decl == null) {
                    return false;
                }
                decl.setAttributeFormDefault(attributeFormDefault);
                decl.setElementFormDefault(elementFormDefault);
                decl.setTargetNamespace(targetNamespace);
                decl.setBlockDefault(blockDefault);
                decl.setFinalDefault(finalDefault);
                decl.setVersion(version);
                this.appendChild(decl);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    xsdDeclNode = childNode.getParentDecl();
                }
                this.nameSpace = targetNamespace != null ? targetNamespace : null;
            } else if (in.peek("<" + prefix + "schema")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseIncludeDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block18: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "include")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "include")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdIncludeNode decl = null;
            XsdChildrenNode newChild = null;
            String schemaLocation = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block18;
                if (in.peek("schemaLocation")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_INCLUDE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    schemaLocation = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new XsdIncludeNode(this, schemaLocation);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
                if (!this.createExternalXSDDocument(this.nameSpace, schemaLocation, parentSchema)) {
                    XSDDocument.fatal("INVALID_URI", (Locator)in, schemaLocation);
                }
            } else if (in.peek("/>")) {
                decl = new XsdIncludeNode(this, schemaLocation);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
                if (!this.createExternalXSDDocument(this.nameSpace, schemaLocation, parentSchema)) {
                    XSDDocument.fatal("INVALID_URI", (Locator)in, schemaLocation);
                }
            } else if (in.peek("<" + prefix + "include")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseImportDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block20: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "import")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "import")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdImportNode decl = null;
            XsdChildrenNode newChild = null;
            String namespace = null;
            String schemaLocation = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block20;
                if (in.peek("namespace")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_IMPORT", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    namespace = in.peekQuotedString();
                    continue;
                }
                if (in.peek("schemaLocation")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_IMPORT", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    schemaLocation = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new XsdImportNode(this, namespace, schemaLocation);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
                if (!this.createExternalXSDDocument(namespace, schemaLocation, parentSchema)) {
                    XSDDocument.fatal("INVALID_URI", (Locator)in, schemaLocation);
                }
            } else if (in.peek("/>")) {
                decl = new XsdImportNode(this, namespace, schemaLocation);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
                if (!this.createExternalXSDDocument(namespace, schemaLocation, parentSchema)) {
                    XSDDocument.fatal("INVALID_URI", (Locator)in, schemaLocation);
                }
            } else if (in.peek("<" + prefix + "import")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parsePI(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        boolean space = true;
        if (in.peek("?>")) {
            in.peekWhitespace();
            return false;
        }
        if (!in.peek("<?")) {
            return false;
        }
        String name2 = in.peekXmlName();
        if (name2 == null) {
            in.peekWhitespace();
            XSDDocument.fatal("INVALID_CHAR", (Locator)in, String.valueOf(in.getc()));
        }
        if (!in.peekWhitespace()) {
            XSDDocument.fatal("NEED_SPACE_AFTER", (Locator)in, "<?" + name2);
        }
        String contents = in.readStringTo("?>", true);
        XsdPIDeclNode decl = new XsdPIDeclNode(this, name2, contents);
        if (childNode != null) {
            childNode.insertChild(decl);
            XsdDeclNode parentnode = childNode.getParentDecl();
            decl.setParentDecl(parentnode);
            this.appendChild(decl);
        } else {
            this.appendChild(decl);
            this.parseXSDDeclNode(in, childNode, parentSchema);
        }
        return true;
    }

    protected boolean parseElementDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block55: {
            String prefix = this.getSchemaPrefix(true);
            if (in.peek("</" + prefix + "element")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "element")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("INVALID_ELEMENT", (Locator)in);
            }
            XsdElementDeclNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String ref = null;
            String type = null;
            XsdTypeRef refModel = null;
            XsdTypeRef typeModel = null;
            String minOcc = null;
            String maxOcc = null;
            String fixed = null;
            String sDefault = null;
            String sAbstract = null;
            String block = null;
            String sFinal = null;
            String nillable = null;
            String subtitutionGroup = null;
            XsdTypeRef subref = null;
            String form = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block55;
                if (in.peek("name")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("ref")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    ref = in.peekQuotedString();
                    refModel = this.findTypeReference(ref, 50, 1, true);
                    continue;
                }
                if (in.peek("type")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    type = in.peekQuotedString();
                    typeModel = this.findTypeReference(type, 50, 0, true);
                    continue;
                }
                if (in.peek("minOccurs")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    minOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("maxOccurs")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    maxOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("maxOccurs")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    maxOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("fixed")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    fixed = in.peekQuotedString();
                    continue;
                }
                if (in.peek("default")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sDefault = in.peekQuotedString();
                    continue;
                }
                if (in.peek("abstract")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sAbstract = in.peekQuotedString();
                    continue;
                }
                if (in.peek("block")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    block = in.peekQuotedString();
                    continue;
                }
                if (in.peek("final")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sFinal = in.peekQuotedString();
                    continue;
                }
                if (in.peek("final")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sFinal = in.peekQuotedString();
                    continue;
                }
                if (in.peek("nillable")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    nillable = in.peekQuotedString();
                    continue;
                }
                if (in.peek("substitutionGroup")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    subtitutionGroup = in.peekQuotedString();
                    subref = this.findTypeReference(subtitutionGroup, 50, 1, true);
                    continue;
                }
                if (in.peek("form")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    form = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                if (name2 != null) {
                    decl = typeModel == null ? new XsdElementDeclNode(this, name2) : new XsdElementDeclNode((XSDDecl)this, name2, typeModel);
                } else if (ref != null) {
                    decl = new XsdElementDeclNode((XSDDecl)this, refModel, 2);
                } else {
                    XSDDocument.fatal("INVALID_ELEMENT", (Locator)in);
                }
                if (minOcc != null) {
                    decl.setMinOccurs(minOcc);
                }
                if (maxOcc != null) {
                    decl.setMaxOccurs(maxOcc);
                }
                if (sDefault != null) {
                    decl.setDefault(sDefault);
                }
                if (sAbstract != null) {
                    decl.setAbstract(sAbstract);
                }
                if (fixed != null) {
                    decl.setFixed(fixed);
                }
                if (block != null) {
                    decl.setBlock(block);
                }
                if (sFinal != null) {
                    decl.setFinal(sFinal);
                }
                if (nillable != null) {
                    decl.setNillable(nillable);
                }
                if (subtitutionGroup != null) {
                    decl.setSubtitutionGroup(subref);
                }
                if (form != null) {
                    decl.setForm(form);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                if (name2 != null) {
                    decl = typeModel == null ? new XsdElementDeclNode(this, name2) : new XsdElementDeclNode((XSDDecl)this, name2, typeModel);
                } else if (ref != null) {
                    decl = new XsdElementDeclNode((XSDDecl)this, refModel, 2);
                } else {
                    XSDDocument.fatal("INVALID_ELEMENT", (Locator)in);
                }
                if (minOcc != null) {
                    decl.setMinOccurs(minOcc);
                }
                if (maxOcc != null) {
                    decl.setMaxOccurs(maxOcc);
                }
                if (sDefault != null) {
                    decl.setDefault(sDefault);
                }
                if (sAbstract != null) {
                    decl.setAbstract(sAbstract);
                }
                if (fixed != null) {
                    decl.setFixed(fixed);
                }
                if (block != null) {
                    decl.setBlock(block);
                }
                if (sFinal != null) {
                    decl.setFinal(sFinal);
                }
                if (nillable != null) {
                    decl.setNillable(nillable);
                }
                if (subtitutionGroup != null) {
                    decl.setSubtitutionGroup(subref);
                }
                if (form != null) {
                    decl.setForm(form);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "element")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseComplexTypeDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block22: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "complexType")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "complexType")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            ComplexTypeNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String sAbstract = null;
            String sFinal = null;
            String mixed = null;
            String block = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block22;
                if (in.peek("name")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_COMPLEXTYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("abstract")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_COMPLEXTYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sAbstract = in.peekQuotedString();
                    continue;
                }
                if (in.peek("mixed")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_COMPLEXTYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    mixed = in.peekQuotedString();
                    continue;
                }
                if (in.peek("final")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_COMPLEXTYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sFinal = in.peekQuotedString();
                    continue;
                }
                if (in.peek("block")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_COMPLEXTYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    block = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = name2 == null ? new ComplexTypeNode(this) : new ComplexTypeNode(this, name2);
                decl.setAbstract(sAbstract);
                decl.setBlock(block);
                decl.setMixed(mixed);
                decl.setFinal(sFinal);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new ComplexTypeNode(this, name2);
                decl.setAbstract(sAbstract);
                decl.setBlock(block);
                decl.setMixed(mixed);
                decl.setFinal(sFinal);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "complexType")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseSimpleTypeDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block15: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "simpleType")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "simpleType")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            SimpleTypeNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String sFinal = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block15;
                if (in.peek("name")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_SIMPLETYPE", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("final")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sFinal = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = name2 == null ? new SimpleTypeNode(this) : new SimpleTypeNode((XSDDecl)this, name2);
                decl.setFinal(sFinal);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new SimpleTypeNode((XSDDecl)this, name2);
                decl.setFinal(sFinal);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "simpleType")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseMgsDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block27: {
            int model;
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "sequence") || in.peek("</" + prefix + "choice") || in.peek("</" + prefix + "any") || in.peek("</" + prefix + "all")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "sequence")) {
                model = 0;
            } else if (in.peek("<" + prefix + "choice")) {
                model = 1;
            } else if (in.peek("<" + prefix + "any")) {
                model = 2;
            } else if (in.peek("<" + prefix + "all")) {
                model = 3;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            MgsDeclNode decl = null;
            XsdChildrenNode newChild = null;
            String minOcc = null;
            String maxOcc = null;
            String namespace = null;
            String processContents = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block27;
                if (in.peek("minOccurs")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_MGS", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    minOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("maxOccurs")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_MGS", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    maxOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("id")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    in.peekQuotedString();
                    continue;
                }
                if (in.peek("namespace")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_MGS", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    namespace = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("processContents")) break;
                if (!space) {
                    XSDDocument.fatal("INVALID_MGS", (Locator)in);
                }
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                processContents = in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new MgsDeclNode((XSDDecl)this, model);
                decl.setMaxOccours(maxOcc);
                decl.setMinOccours(minOcc);
                decl.setNameSpace(namespace);
                decl.setProcessContents(processContents);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new MgsDeclNode((XSDDecl)this, model);
                decl.setMaxOccours(maxOcc);
                decl.setMinOccours(minOcc);
                decl.setNameSpace(namespace);
                decl.setProcessContents(processContents);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "sequence")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseAttributeDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block27: {
            String prefix = this.getSchemaPrefix(true);
            if (in.peek("</" + prefix + "attribute")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "attribute")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("INVALID_ATTLIST", (Locator)in);
            }
            XsdAttDefNode decl = null;
            XsdChildrenNode newChild = null;
            String attrname = null;
            String use = null;
            String ref = null;
            String type = null;
            XsdTypeRef refModel = null;
            XsdTypeRef typeModel = null;
            String sDefault = null;
            String fixed = null;
            String form = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block27;
                if (in.peek("name")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    attrname = in.peekQuotedString();
                    continue;
                }
                if (in.peek("ref")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    ref = in.peekQuotedString();
                    refModel = this.findTypeReference(ref, 55, 1, true);
                    continue;
                }
                if (in.peek("type")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    type = in.peekQuotedString();
                    typeModel = this.findTypeReference(type, 55, 0, true);
                    continue;
                }
                if (in.peek("use")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    use = in.peekQuotedString();
                    continue;
                }
                if (in.peek("default")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    sDefault = in.peekQuotedString();
                    continue;
                }
                if (in.peek("fixed")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    fixed = in.peekQuotedString();
                    continue;
                }
                if (in.peek("form")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    form = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                if (attrname != null) {
                    decl = new XsdAttDefNode(this, attrname, typeModel, use, sDefault, fixed);
                } else if (ref != null) {
                    decl = new XsdAttDefNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_ATTLIST", (Locator)in);
                }
                decl.setForm(form);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                if (attrname != null) {
                    decl = new XsdAttDefNode(this, attrname, typeModel, use, sDefault, fixed);
                } else if (ref != null) {
                    decl = new XsdAttDefNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_ATTLIST", (Locator)in);
                }
                decl.setForm(form);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "attribute")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseGroupDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block28: {
            String prefix = this.getSchemaPrefix(true);
            if (in.peek("</" + prefix + "group")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "group")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("INVALID_GROUP", (Locator)in);
            }
            ModelGroupNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String ref = null;
            XsdTypeRef refModel = null;
            String minOcc = null;
            String maxOcc = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block28;
                if (in.peek("name")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("ref")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    ref = in.peekQuotedString();
                    refModel = this.findTypeReference(ref, 56, 1, true);
                    continue;
                }
                if (in.peek("minOccurs")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    minOcc = in.peekQuotedString();
                    continue;
                }
                if (in.peek("maxOccurs")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    maxOcc = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                if (name2 != null) {
                    decl = new ModelGroupNode((XSDDecl)this, name2);
                } else if (ref != null) {
                    decl = new ModelGroupNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_GROUP", (Locator)in);
                }
                if (minOcc != null) {
                    decl.setMinOccours(minOcc);
                }
                if (maxOcc != null) {
                    decl.setMaxOccours(maxOcc);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                if (name2 != null) {
                    decl = new ModelGroupNode((XSDDecl)this, name2);
                } else if (ref != null) {
                    decl = new ModelGroupNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_GROUP", (Locator)in);
                }
                if (minOcc != null) {
                    decl.setMinOccours(minOcc);
                }
                if (maxOcc != null) {
                    decl.setMaxOccours(maxOcc);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "group")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseAttributeGroupDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block22: {
            String prefix = this.getSchemaPrefix(true);
            if (in.peek("</" + prefix + "attributeGroup")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "attributeGroup")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("INVALID_ATTGROUP", (Locator)in);
            }
            AttributeGroupNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String ref = null;
            XsdTypeRef refModel = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block22;
                if (in.peek("name")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("ref")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    ref = in.peekQuotedString();
                    refModel = this.findTypeReference(ref, 57, 1, true);
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                if (name2 != null) {
                    decl = new AttributeGroupNode((XSDDecl)this, name2);
                } else if (ref != null) {
                    decl = new AttributeGroupNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_ATTGROUP", (Locator)in);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                if (name2 != null) {
                    decl = new AttributeGroupNode((XSDDecl)this, name2);
                } else if (ref != null) {
                    decl = new AttributeGroupNode((XSDDecl)this, refModel);
                } else {
                    XSDDocument.fatal("INVALID_ATTGROUP", (Locator)in);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "attributeGroup")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseDerivationDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block17: {
            String prefix = this.getSchemaPrefix(true);
            int derivationMode = -1;
            boolean space = true;
            if (in.peek("</" + prefix + "extension") || in.peek("</" + prefix + "restriction")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "restriction")) {
                derivationMode = 0;
            } else if (in.peek("<" + prefix + "extension")) {
                derivationMode = 1;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            DerivationNode decl = null;
            XsdChildrenNode newChild = null;
            String basename = null;
            XsdTypeRef basenode = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block17;
                if (in.peek("base")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_DERIVATION", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    basename = in.peekQuotedString();
                    basenode = this.findTypeReference(basename, 62, 2, true);
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = basenode == null ? new DerivationNode((XSDDecl)this, derivationMode, basename) : new DerivationNode((XSDDecl)this, derivationMode, basenode);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = basenode == null ? new DerivationNode((XSDDecl)this, derivationMode, basename) : new DerivationNode((XSDDecl)this, derivationMode, basenode);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "restriction") || in.peek("</" + prefix + "extension")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseContentModelDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block17: {
            String prefix = this.getSchemaPrefix(true);
            int type = -1;
            boolean space = true;
            if (in.peek("</" + prefix + "complexContent") || in.peek("</" + prefix + "simpleContent")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "complexContent")) {
                type = 0;
            } else if (in.peek("<" + prefix + "simpleContent")) {
                type = 1;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            ContentModelNode decl = null;
            XsdChildrenNode newChild = null;
            String mixed = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block17;
                if (in.peek("mixed")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_CONTENT", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    mixed = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = mixed == null ? new ContentModelNode(this, type) : new ContentModelNode(this, type, mixed);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = mixed == null ? new ContentModelNode(this, type) : new ContentModelNode(this, type, mixed);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "complexContent") || in.peek("</" + prefix + "simpleContent")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseFacetDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block36: {
            int type;
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "length") || in.peek("</" + prefix + "minLength") || in.peek("</" + prefix + "maxLength") || in.peek("</" + prefix + "pattern") || in.peek("</" + prefix + "enumeration") || in.peek("</" + prefix + "whiteSpace") || in.peek("</" + prefix + "maxInclusive") || in.peek("</" + prefix + "maxExclusive") || in.peek("</" + prefix + "minInclusive") || in.peek("</" + prefix + "minExclusive") || in.peek("</" + prefix + "totalDigits") || in.peek("</" + prefix + "fractionDigits")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "length")) {
                type = 0;
            } else if (in.peek("<" + prefix + "minLength")) {
                type = 1;
            } else if (in.peek("<" + prefix + "maxLength")) {
                type = 2;
            } else if (in.peek("<" + prefix + "pattern")) {
                type = 3;
            } else if (in.peek("<" + prefix + "enumeration")) {
                type = 4;
            } else if (in.peek("<" + prefix + "whiteSpace")) {
                type = 5;
            } else if (in.peek("<" + prefix + "maxInclusive")) {
                type = 6;
            } else if (in.peek("<" + prefix + "maxExclusive")) {
                type = 7;
            } else if (in.peek("<" + prefix + "minInclusive")) {
                type = 8;
            } else if (in.peek("<" + prefix + "minExclusive")) {
                type = 9;
            } else if (in.peek("<" + prefix + "totalDigits")) {
                type = 10;
            } else if (in.peek("<" + prefix + "fractionDigits")) {
                type = 11;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdFacetNode decl = null;
            XsdChildrenNode newChild = null;
            String value = "";
            String fixed = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block36;
                if (in.peek("value")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_FACET", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    value = in.peekQuotedString();
                    continue;
                }
                if (in.peek("fixed")) {
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    fixed = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = fixed == null ? new XsdFacetNode(this, type, value) : new XsdFacetNode(this, type, value, fixed);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = fixed == null ? new XsdFacetNode(this, type, value) : new XsdFacetNode(this, type, value, fixed);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseListDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block14: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "list")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "list")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdListNode decl = null;
            XsdChildrenNode newChild = null;
            String itemTypeName = null;
            XsdTypeRef itemType = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block14;
                if (in.peek("itemType")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_LIST", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    itemTypeName = in.peekQuotedString();
                    itemType = this.findTypeReference(itemTypeName, 64, 0, true);
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = itemType != null ? new XsdListNode(this, itemType) : new XsdListNode(this);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = itemType != null ? new XsdListNode(this, itemType) : new XsdListNode(this);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "list")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseUnionDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block16: {
            XsdDeclNode parentnode;
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "union")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "union")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdUnionNode decl = null;
            XsdChildrenNode newChild = null;
            String memberTypeString = null;
            Vector<XsdTypeRef> memberType = new Vector<XsdTypeRef>();
            XsdTypeRef memberTypeObj = null;
            block0: while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block16;
                if (in.peek("memberTypes")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_UNION", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    memberTypeString = in.peekQuotedString();
                    String[] memberTypeArr = memberTypeString.split(" ");
                    int idx = memberTypeArr.length;
                    int i = 0;
                    while (true) {
                        if (i >= idx) continue block0;
                        memberTypeObj = this.findTypeReference(memberTypeArr[i], 63, 0, true);
                        if (memberTypeObj != null) {
                            memberType.addElement(memberTypeObj);
                        }
                        ++i;
                    }
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = memberTypeString != null ? new XsdUnionNode(this, memberType) : new XsdUnionNode(this);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = memberTypeString != null ? new XsdUnionNode(this, memberType) : new XsdUnionNode(this);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "union")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseIdentityDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block23: {
            String prefix = this.getSchemaPrefix(true);
            int type = -1;
            boolean space = true;
            if (in.peek("</" + prefix + "unique") || in.peek("</" + prefix + "keyref") || in.peek("</" + prefix + "key")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "unique")) {
                type = 0;
            } else if (in.peek("<" + prefix + "keyref")) {
                type = 2;
            } else if (in.peek("<" + prefix + "key")) {
                type = 1;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            IdentityConstraintNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String refer = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block23;
                if (in.peek("name")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_IDENTITY", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("refer")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_IDENTITY", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    refer = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new IdentityConstraintNode(this, name2, type);
                if (refer != null) {
                    decl.setRefer(refer);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new IdentityConstraintNode(this, name2, type);
                if (refer != null) {
                    decl.setRefer(refer);
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "unique") || in.peek("</" + prefix + "key") || in.peek("</" + prefix + "keyref")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseSelectorFieldDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block17: {
            String prefix = this.getSchemaPrefix(true);
            int type = -1;
            boolean space = true;
            if (in.peek("</" + prefix + "selector") || in.peek("</" + prefix + "field")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "selector")) {
                type = 0;
            } else if (in.peek("<" + prefix + "field")) {
                type = 1;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            SelectorFieldNode decl = null;
            XsdChildrenNode newChild = null;
            String xpath = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block17;
                if (in.peek("xpath")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_IDENTITY", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    xpath = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new SelectorFieldNode(this, type, xpath);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new SelectorFieldNode(this, type, xpath);
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("</" + prefix + "selector") || in.peek("</" + prefix + "field")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseAnyAttributeDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block19: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "anyAttribute")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "anyAttribute")) {
                if (!in.peekWhitespace()) {
                    space = false;
                }
            } else {
                return false;
            }
            AnyAttributeNode decl = null;
            XsdChildrenNode newChild = null;
            String namespace = null;
            String processContents = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block19;
                if (in.peek("namespace")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_ANYATT", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    namespace = in.peekQuotedString();
                    continue;
                }
                if (in.peek("processContents")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_ANYATT", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    processContents = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = processContents != null && namespace != null ? new AnyAttributeNode(this, namespace, processContents) : (processContents == null ? new AnyAttributeNode(this, namespace) : new AnyAttributeNode(this));
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = processContents != null && namespace != null ? new AnyAttributeNode(this, namespace, processContents) : (processContents == null ? new AnyAttributeNode(this, namespace) : new AnyAttributeNode(this));
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "anyAttribute")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseAnnotationDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block14: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "annotation")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (!in.peek("<" + prefix + "annotation")) {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdAnnotationNode decl = null;
            XsdChildrenNode newChild = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block14;
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new XsdAnnotationNode(this);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new XsdAnnotationNode(this);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "annotaion")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseAppinfoDocDecl(XReader in, XsdChildren childNode) throws IOException, XSDException {
        block26: {
            String prefix = this.getSchemaPrefix(true);
            int type = -1;
            boolean space = true;
            if (in.peek("</" + prefix + "appinfo") || in.peek("</" + prefix + "documentation")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "appinfo")) {
                type = 0;
            } else if (in.peek("<" + prefix + "documentation")) {
                type = 1;
            } else {
                return false;
            }
            if (!in.peekWhitespace()) {
                space = false;
            }
            XsdAppinfoDocNode decl = null;
            Object newChild = null;
            String source = null;
            String lang = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block26;
                if (in.peek("source")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_APPDOC", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    source = in.peekQuotedString();
                    continue;
                }
                if (in.peek("xml:lang")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_APPDOC", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    lang = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                String s1 = null;
                if (type == 0) {
                    s1 = in.readStringTo("</" + prefix + "appinfo", false);
                    in.peekWhitespace();
                    in.peek(">");
                } else if (type == 1) {
                    s1 = in.readStringTo("</" + prefix + "documentation", false);
                    in.peekWhitespace();
                    in.peek(">");
                }
                decl = new XsdAppinfoDocNode(this, type, source);
                if (decl != null) {
                    if (type == 1 && lang != null) {
                        decl.setLang(lang);
                    }
                    decl.setText(s1);
                    if (childNode != null) {
                        childNode.insertChild(decl);
                        XsdDeclNode parentnode = childNode.getParentDecl();
                        decl.setParentDecl(parentnode);
                    }
                    this.appendChild(decl);
                }
            } else if (in.peek("/>")) {
                decl = new XsdAppinfoDocNode(this, type, source);
                if (decl != null) {
                    if (type == 1 && lang != null) {
                        decl.setLang(lang);
                    }
                    if (childNode != null) {
                        childNode.insertChild(decl);
                        XsdDeclNode parentnode = childNode.getParentDecl();
                        decl.setParentDecl(parentnode);
                    }
                    this.appendChild(decl);
                }
            } else if (in.peek("</" + prefix + "appinfo") || in.peek("</" + prefix + "documentation")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseComment(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        boolean space = true;
        if (in.peek("-->")) {
            in.peekWhitespace();
            return false;
        }
        if (!in.peek("<!--")) {
            return false;
        }
        String s1 = in.readStringTo("-->", false);
        if (s1 != null) {
            XsdCommentDecl decl = XSDDocument.createCommentDecl(this, s1);
            if (childNode != null) {
                childNode.insertChild(decl);
                XsdDeclNode parentnode = childNode.getParentDecl();
                decl.setParentDecl(parentnode);
                this.appendChild(decl);
            } else {
                this.appendChild(decl);
                this.parseXSDDeclNode(in, childNode, parentSchema);
            }
        } else {
            XSDDocument.fatal("INVALID_COMENT", (Locator)in);
        }
        return true;
    }

    protected boolean parseNotationDecl(XReader in, XsdChildren childNode, String parentSchema) throws IOException, XSDException {
        block21: {
            String prefix = this.getSchemaPrefix(true);
            boolean space = true;
            if (in.peek("</" + prefix + "notation")) {
                in.peekWhitespace();
                in.peek(">");
                return false;
            }
            if (in.peek("<" + prefix + "notation")) {
                if (!in.peekWhitespace()) {
                    space = false;
                }
            } else {
                return false;
            }
            XsdNotationDeclNode decl = null;
            XsdChildrenNode newChild = null;
            String name2 = null;
            String systemId = null;
            String publicId = null;
            while (true) {
                in.peekWhitespace();
                if (in.isEOF()) break block21;
                if (in.peek("name")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_NOTATION", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    name2 = in.peekQuotedString();
                    continue;
                }
                if (in.peek("system")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_NOTATION", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    systemId = in.peekQuotedString();
                    continue;
                }
                if (in.peek("public")) {
                    if (!space) {
                        XSDDocument.fatal("INVALID_NOTATION", (Locator)in);
                    }
                    in.peekWhitespace();
                    in.peek("=");
                    in.peekWhitespace();
                    publicId = in.peekQuotedString();
                    continue;
                }
                if (!in.peek("id")) break;
                in.peekWhitespace();
                in.peek("=");
                in.peekWhitespace();
                in.peekQuotedString();
            }
            if (in.peek(">")) {
                decl = new XsdNotationDeclNode(this, name2, publicId, systemId);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                newChild = new XsdChildrenNode(decl);
                decl.setChildren(newChild);
                this.appendChild(decl);
                this.parseXSDDeclNode(in, newChild, parentSchema);
            } else if (in.peek("/>")) {
                decl = new XsdNotationDeclNode(this, name2, publicId, systemId);
                if (decl == null) {
                    return false;
                }
                if (childNode != null) {
                    childNode.insertChild(decl);
                    XsdDeclNode parentnode = childNode.getParentDecl();
                    decl.setParentDecl(parentnode);
                }
                this.appendChild(decl);
            } else if (in.peek("<" + prefix + "notation")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            } else {
                return false;
            }
        }
        in.peekWhitespace();
        return true;
    }

    protected boolean parseDataDecl(XReader in) throws XSDException {
        if (!in.peek("<DATA")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            XSDDocument.fatal("INVALID_DATADECL", (Locator)in);
        }
        Properties properties = new Properties();
        boolean hasEnded = false;
        while (!in.isEOF()) {
            if (in.isChar('\\')) {
                in.getc();
                if (in.isChar('>')) {
                    in.getc();
                    hasEnded = true;
                    break;
                }
                XSDDocument.fatal("NEED_CHAR", (Locator)in, ">");
            }
            if (in.isChar('>')) {
                in.getc();
                break;
            }
            String propertyname = in.peekXmlName();
            if (propertyname == null) {
                XSDDocument.fatal("INVALID_DATADECL", (Locator)in);
            }
            in.peekWhitespace();
            if (!in.peekc('=')) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, "=");
            }
            in.peekWhitespace();
            String propertyvalue = in.peekQuotedString();
            if (propertyvalue == null) {
                XSDDocument.fatal("NEED_CHAR", (Locator)in, "\"");
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (!hasEnded) {
            in.peekWhitespace();
            String s = in.readStringTo("</DATA>", false);
            properties.append("value", Properties.parseSpecialChar(s));
        }
        XsdDataTypeDecl dtDecl = new XsdDataTypeDecl(properties);
        String element = properties.getValue("element");
        String attr = properties.getValue("attr");
        dtDecl.setElement(element);
        dtDecl.setAttribute(attr);
        this.xsdDataTypeDecls.addElement(dtDecl);
        return true;
    }

    private void addDataTypeDeclOnEleAttr() {
        int n = this.xsdDataTypeDecls.size();
        String ele = null;
        String attr = null;
        for (int i = 0; i < n; ++i) {
            XsdAttDefNode attdef;
            XsdDataTypeDecl datadecl = (XsdDataTypeDecl)this.xsdDataTypeDecls.elementAt(i);
            ele = datadecl.getElement();
            attr = datadecl.getAttribute();
            if (!ele.equals("")) {
                XsdElementDeclNode elemdecl = (XsdElementDeclNode)this.getElementDecl(ele);
                if (elemdecl == null) continue;
                if (attr.equals("")) {
                    elemdecl.setDataTypeDecl(datadecl);
                    continue;
                }
                XsdAttDefNode attdecl = (XsdAttDefNode)elemdecl.getAttListDecl(attr);
                if (attdecl == null) continue;
                attdecl.setDataTypeDecl(datadecl);
                continue;
            }
            if (attr.equals("") || (attdef = (XsdAttDefNode)this.globalAttrDecls.get(attr)) == null) continue;
            attdef.setDataTypeDecl(datadecl);
        }
        this.xsdDataTypeDecls.clear();
    }

    private String getAllPath(String urlid) {
        if (urlid == null || this.url == null) {
            return urlid;
        }
        URL baseUri = null;
        if (this.url != null) {
            try {
                baseUri = new URL(this.url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        URL uri = null;
        try {
            uri = new URL(urlid);
        }
        catch (MalformedURLException ex) {
            File file = new File(urlid);
            try {
                uri = !file.isAbsolute() && baseUri != null ? new URL(baseUri, file.getPath()) : file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    @Override
    public void resolveAttrOnElement() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 50) continue;
            XsdElementDeclNode elenode = (XsdElementDeclNode)node;
            XsdChildren child = null;
            if (elenode.getTypeAttr() != null) {
                XsdTypeRef typeattr = elenode.getTypeAttr();
                XSDDecl tmpxsd = typeattr.getXsdDecl();
                XsdDeclNode tmpdeclnode = typeattr.getDeclNode();
                if (tmpdeclnode.getNodeType() != 73) {
                    child = tmpdeclnode.getChildren();
                }
            } else if (elenode.hasChildren()) {
                child = elenode.getChildren();
            }
            if (child == null) continue;
            Vector childList = child.getChildrenList();
            Vector attList = new Vector();
            this.ElementAddAttDef(childList, attList, null);
            if (attList.size() <= 0) continue;
            elenode.addAttDefs(attList);
        }
        this.addDataTypeDeclOnEleAttr();
        n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            XsdDeclNode node1;
            XsdDeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 50) continue;
            XsdElementDeclNode elenode = (XsdElementDeclNode)node;
            int type = 5;
            Vector child = elenode.getChildNames();
            if (child.size() > 0) {
                type = 8;
            }
            if (!elenode.hasChildren()) {
                elenode.setType(type);
                continue;
            }
            XsdChildren child1 = elenode.getChildren();
            Vector childList1 = child1.getChildrenList();
            if (childList1.size() > 0 && (node1 = (XsdDeclNode)childList1.elementAt(0)).getNodeType() == 52) {
                ComplexTypeNode cmp = (ComplexTypeNode)node1;
                if (cmp.getMixedBool()) {
                    type = 5;
                }
                if (!cmp.hasChildren()) {
                    type = 7;
                } else {
                    MgsDeclNode mgs;
                    XsdDeclNode node2;
                    XsdChildren child2 = cmp.getChildren();
                    Vector childList2 = child2.getChildrenList();
                    if (childList2.size() > 0 && (node2 = (XsdDeclNode)childList2.elementAt(0)).getNodeType() == 54 && (mgs = (MgsDeclNode)node2).getModel() == 2) {
                        type = 6;
                    }
                }
            }
            elenode.setType(type);
        }
    }

    private void ElementAddAttDef(Vector childList, Vector attList, XsdDeclNode attgrp) {
        int n = childList.size();
        for (int i = 0; i < n; ++i) {
            XsdChildren childnode;
            XsdDeclNode tmpdeclnode;
            XsdTypeRef typeref;
            XsdChildren childnode2;
            XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
            if (node.getNodeType() == 50 || node.getNodeType() == 54) continue;
            if (node.getNodeType() == 52) {
                childnode2 = ((ComplexTypeNode)node).getChildren();
                if (childnode2 == null) continue;
                this.ElementAddAttDef(childnode2.getChildrenList(), attList, attgrp);
                continue;
            }
            if (node.getNodeType() == 58) {
                childnode2 = ((ContentModelNode)node).getChildren();
                if (childnode2 == null) continue;
                this.ElementAddAttDef(childnode2.getChildrenList(), attList, attgrp);
                continue;
            }
            if (node.getNodeType() == 55) {
                XsdAttDefNode attrnode = (XsdAttDefNode)node;
                if (attrnode.isRef()) {
                    typeref = attrnode.getRef();
                    tmpdeclnode = typeref.getDeclNode();
                    if (tmpdeclnode == null) continue;
                    XsdAttDefNode attrdef = (XsdAttDefNode)tmpdeclnode;
                    if (attrdef.getNodeName() != null) {
                        attList.addElement(attrdef);
                        continue;
                    }
                    XsdChildren childnode3 = attrdef.getChildren();
                    if (childnode3 == null) continue;
                    this.ElementAddAttDef(childnode3.getChildrenList(), attList, attgrp);
                    continue;
                }
                if (attrnode.getNodeName() == null) continue;
                attList.addElement(attrnode);
                continue;
            }
            if (node.getNodeType() == 57) {
                AttributeGroupNode attgrpnode = (AttributeGroupNode)node;
                if (attgrp != null) {
                    if (attgrp.getNodeName().equals(attgrpnode.getNodeName())) {
                        attgrp = null;
                        continue;
                    }
                } else if (attgrp == null) {
                    attgrp = attgrpnode;
                }
                if (attgrpnode.isRef()) {
                    typeref = attgrpnode.getRef();
                    tmpdeclnode = typeref.getDeclNode();
                    if (tmpdeclnode != null && (childnode = ((AttributeGroupNode)tmpdeclnode).getChildren()) != null) {
                        this.ElementAddAttDef(childnode.getChildrenList(), attList, attgrp);
                    }
                } else {
                    XsdChildren childnode4 = ((AttributeGroupNode)node).getChildren();
                    if (childnode4 != null) {
                        this.ElementAddAttDef(childnode4.getChildrenList(), attList, attgrp);
                    }
                }
                attgrp = null;
                continue;
            }
            if (node.getNodeType() == 62) {
                XsdChildren childnode5;
                DerivationNode derinode = (DerivationNode)node;
                typeref = derinode.getBase();
                if (typeref == null) {
                    childnode5 = derinode.getChildren();
                    if (childnode5 == null) continue;
                    this.ElementAddAttDef(childnode5.getChildrenList(), attList, null);
                    continue;
                }
                if (derinode.getDerivationMode() == 1 && (tmpdeclnode = typeref.getDeclNode()) != null && tmpdeclnode.getNodeType() == 52 && (childnode = ((ComplexTypeNode)tmpdeclnode).getChildren()) != null) {
                    this.ElementAddAttDef(childnode.getChildrenList(), attList, null);
                }
                if ((childnode5 = derinode.getChildren()) == null) continue;
                this.ElementAddAttDef(childnode5.getChildrenList(), attList, null);
                continue;
            }
            if (node.getNodeType() != 56) continue;
        }
    }

    @Override
    public void resolveHierarchy() {
        XsdDeclNode parent;
        XsdDeclNode node;
        int i;
        XsdElementDeclNode first = null;
        XsdElementDeclNode simpleFirstElement = null;
        int n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            XsdDeclNode parentnode;
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 50 || (parentnode = node.getParentDecl()).getNodeType() != 71) continue;
            XsdElementDeclNode elenode = (XsdElementDeclNode)node;
            if (elenode.hasChildren()) {
                first = (XsdElementDeclNode)node;
                break;
            }
            Vector v = elenode.getChildNames();
            if (v.size() > 0) {
                first = (XsdElementDeclNode)node;
                break;
            }
            if (simpleFirstElement != null) continue;
            simpleFirstElement = (XsdElementDeclNode)node;
        }
        if (first != null) {
            this.rootElement = first;
            this.rootElement.parents = null;
        } else {
            this.rootElement = null;
            if (simpleFirstElement != null) {
                this.rootElement = simpleFirstElement;
                this.rootElement.parents = null;
            }
        }
        for (i = 0; i < n && ((node = this.nodes.elementAt(i)).getNodeType() != 50 || (parent = node.getParentDecl()).getNodeType() != 71 || this.rootElement == node); ++i) {
        }
    }

    public XReader getErrorXReader() {
        return this.docReader;
    }

    @Override
    public boolean load(String address, String parentSchema) throws XSDException, IOException {
        return this.load(address, false, parentSchema);
    }

    public boolean load(String address, boolean isExternal, String parentSchema) throws XSDException, IOException {
        String prefix;
        URL url = null;
        String nexParentSchema = null;
        try {
            url = new URL(address);
            nexParentSchema = parentSchema;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url == null) {
            File file = new File(address);
            if (!file.exists()) {
                file = new File(parentSchema + "/" + address);
            }
            url = file.toURL();
            address = url.toString();
            nexParentSchema = file.getParent();
        }
        if ((prefix = this.properties.getValue("schemaPrefix")) == null) {
            XReader tmpReader = XReader.createReader(url, false);
            prefix = this.getPrefixInputStream(tmpReader);
            this.properties.repleace("schemaPrefix", prefix);
        }
        XReader parseReader = XReader.createReader(url, false);
        try {
            if (!this.parseXMLSchema(parseReader, prefix)) {
                return false;
            }
        }
        catch (XSDException ex) {
            XSDDocument.fatal(ex.getException(), ex.getMessageID(), parseReader);
        }
        String encoding = this.properties.getValue("encoding");
        this.docReader = encoding == null ? XReader.createReader(url, false) : XReader.createReader(url.openStream(), encoding);
        try {
            if (!isExternal) {
                this.url = this.docReader.getSystemId();
            }
            this.properties.repleace("encoding", this.docReader.getEncoding());
            this.parseXSDDecl(this.docReader, false, nexParentSchema);
            this.docReader.peekWhitespace();
            if (!this.docReader.isEOF()) {
                XSDDocument.fatal("INVALID_CHAR", (Locator)this.docReader, String.valueOf(this.docReader.getc()));
            }
            this.docReader.close();
            this.docReader = null;
            return true;
        }
        catch (XSDException e) {
            try {
                this.docReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void save(String address) throws IOException {
        if (address.startsWith("file:/") && (address = address.substring(6)).startsWith("/")) {
            address = address.substring(1);
        }
        File file = new File(address);
        OutputStreamWriter writer = null;
        String encoding = this.getEncoding();
        if (encoding != null) {
            encoding = MIME2Java.convert(encoding);
        }
        try {
            if (encoding != null) {
                CharsetEncoder charsetEncoder = Charset.forName(encoding).newEncoder();
            }
            if (encoding == null) {
                writer = new OutputStreamWriter(new FileOutputStream(file));
                this.putProperty("encoding", MIME2Java.reverse(writer.getEncoding()));
            } else {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            }
            this.write(writer);
            this.url = file.toURL().toString();
            writer.close();
        }
        catch (IllegalArgumentException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void loadByXML(String address) throws XSDException, IOException {
        InputSource is;
        String encoding;
        URL url = null;
        try {
            File file = new File(address);
            if (file.exists()) {
                url = file.toURL();
            }
        }
        catch (IOException file) {
            // empty catch block
        }
        if (url == null) {
            url = new URL(address);
        }
        if ((encoding = this.properties.getValue("encoding")) == null) {
            is = XReader.createInputSource(url, false);
        } else {
            is = new InputSource(XReader.createReader(url.openStream(), encoding));
            is.setSystemId(url.toString());
        }
        encoding = is.getEncoding();
        if (encoding != null) {
            this.properties.repleace("encoding", encoding);
        }
        this.properties.repleace("version", "1.0");
        try {
            IXmlParser parser = XmlParser.getXmlParser();
            this.doc = parser.createXmlDocument(is, false);
        }
        catch (SAXParseException e) {
            throw new XSDException(null, e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        catch (SAXException e) {
            throw new XSDException(null, is.getPublicId(), is.getSystemId(), 0, 0, e);
        }
        catch (ParserConfigurationException e) {
            throw new XSDException(null, is.getPublicId(), is.getSystemId(), 0, 0, e);
        }
        this.url = address;
        DocumentType dt = this.doc.getDoctype();
        if (dt == null) {
            this.extractFromXML(this.doc);
        } else {
            this.extractFromXML(this.doc);
        }
    }

    void extractFromXML(Document document) throws XSDException {
        XSDExtractor eg = new XSDExtractor(document);
        for (XsdElementDecl elem : eg.getElementDecls(this)) {
            String s = elem.getNodeName();
            this.elementDecls.put(s, elem);
            this.nodes.addElement(elem);
            XsdDeclNodeList attlist = elem.getAttListDecls();
            int n1 = attlist == null ? 0 : attlist.size();
            for (int j = 0; j < n1; ++j) {
                this.nodes.addElement(attlist.item(j));
            }
        }
    }

    public Vector getPathNamesStringToRoot(String name2) {
        Vector<String> v = new Vector<String>();
        if (this.name == null) {
            return v;
        }
        XsdElementDecl decl = null;
        if (name2.startsWith("@")) {
            name2 = name2.substring(1);
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = this.nodes.item(i);
                if (node.getNodeType() != 55 || !name2.equals(node.getNodeName())) continue;
                name2 = ((XsdAttDef)node).getElementName();
                decl = this.getElementDecl(name2);
                break;
            }
        } else {
            XsdElementDeclNode parentDecl = (XsdElementDeclNode)this.getElementDecl(name2);
            decl = (XsdElementDeclNode)parentDecl.getParentDecl();
        }
        while (decl != null) {
            v.insertElementAt(decl.getName(), 0);
            decl = (XsdElementDeclNode)decl.getParentDecl();
        }
        return v;
    }

    @Override
    public String getAbsolutePath(String[] names, char split) {
        int n = names.length;
        if (n < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        XsdElementDecl parentDecl = null;
        for (int i = 0; i < n; ++i) {
            int num;
            String name2 = names[i];
            if (name2.startsWith("@")) {
                XsdAttDef att;
                if (parentDecl != null && (att = parentDecl.getAttListDecl(name2.substring(1))) != null) {
                    sb.append(split);
                    sb.append(name2);
                }
                return sb.toString();
            }
            char c = '\u0000';
            if (parentDecl != null && (num = ((XsdElementDeclNode)parentDecl).getOccurrenceSubElement(name2)) > 1) {
                c = '*';
            }
            sb2.append(split);
            sb2.append(name2);
            parentDecl = parentDecl == null ? this.getElementDecl(name2) : this.getElementDeclByName(sb2.toString());
            if (parentDecl == null) break;
            sb.append(split);
            sb.append(name2);
            if (c == '\u0000') continue;
            sb.append('[');
            sb.append(c);
            sb.append(']');
        }
        return sb.toString();
    }

    public void filterAndSort(String root) {
        XsdElementDeclNode elem = (XsdElementDeclNode)this.getElementDecl(root);
        if (elem == null) {
            return;
        }
        this.rootElement = elem;
        this.name = this.rootElement.getNodeName();
        XsdDeclNodeListImpl nodes1 = new XsdDeclNodeListImpl(this.nodes.size());
        Hashtable elementDecls1 = new Hashtable();
        this.filterAndSort(elem, nodes1, elementDecls1);
        this.nodes = nodes1;
        this.elementDecls = elementDecls1;
    }

    private void filterAndSort(XsdElementDeclNode elem, XsdDeclNodeListImpl nodes1, Hashtable elementDecls1) {
        nodes1.addElement(elem);
        elementDecls1.put(elem.getNodeName(), elem);
        Hashtable attlist = elem.attributeDefs;
        if (attlist != null) {
            Enumeration en = attlist.elements();
            while (en.hasMoreElements()) {
                nodes1.addElement((XsdDeclNode)en.nextElement());
            }
        }
        XsdDeclNodeList list = elem.getSubElementDecls();
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            XsdElementDeclNode elem1 = (XsdElementDeclNode)list.item(i);
            if (elementDecls1.containsKey(elem1.getNodeName())) continue;
            this.filterAndSort(elem1, nodes1, elementDecls1);
        }
    }

    public static XSDDocument createXSDByXML(Document document) {
        XSDDocument xsd = new XSDDocument();
        try {
            DocumentType dt = document.getDoctype();
            if (dt == null) {
                xsd = XSDDocument.extractFromXML0(document);
                xsd.doc = document;
            } else {
                xsd = XSDDocument.extractFromXML0(document);
                xsd.doc = document;
            }
            xsd.lastErr = null;
        }
        catch (Exception e1) {
            xsd.lastErr = e1;
        }
        return xsd;
    }

    public Exception getLastErr() {
        return this.lastErr;
    }

    static XSDDocument extractFromXML0(Document document) throws XSDException {
        XSDExtractor eg = new XSDExtractor(document);
        int max = eg.size() - 1;
        if (max <= 0) {
            return null;
        }
        XSDDocument xsd = new XSDDocument();
        for (int i = 0; i < max; ++i) {
            String ec;
            String sn = eg.getElementName(i);
            if (i == 0) {
                xsd.name = sn;
            }
            if ((ec = eg.getElementContents(i)) == null) continue;
            XsdElementDecl eleNode = xsd.createElementDecl(sn, ec);
            xsd.appendChild(eleNode);
        }
        return xsd;
    }

    public static String serializied(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        char c = '\u0000';
        for (k = 0; k < n && (c = str.charAt(k)) != '\n' && c != '\r' && c != '%' && c != '*' && c != '[' && c != ']' && c != '<' && c != '>' && c != '&'; ++k) {
        }
        if (k == n) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        sb.append("&#");
        sb.append((int)c);
        sb.append(';');
        ++k;
        while (k < n) {
            c = str.charAt(k);
            if (c == '\n' || c == '\r' || c == '%' || c == '*' || c == '[' || c == ']' || c == '<' || c == '>' || c == '&') {
                sb.append("&#");
                sb.append((int)c);
                sb.append(';');
            } else {
                sb.append(c);
            }
            ++k;
        }
        return sb.toString();
    }

    public static String unSerializied(String str) {
        int k;
        if (str == null) {
            return null;
        }
        int n = str.length();
        for (k = 0; k < n && str.charAt(k) != '&'; ++k) {
        }
        if (k > n - 1) {
            return str;
        }
        if (str.charAt(k + 1) != '#') {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        if (k > 0) {
            sb.append(str.substring(0, k));
        }
        while (k < n) {
            char c = str.charAt(k);
            if (c == '&') {
                int k1 = k + 1;
                if (k1 < n && str.charAt(k1) == '#') {
                    int k2;
                    int base = 10;
                    if (++k1 < n && (str.charAt(k1) == 'x' || str.charAt(k1) == 'x')) {
                        base = 16;
                    }
                    for (k2 = ++k1; k2 < n && str.charAt(k2) != ';'; ++k2) {
                    }
                    if (k2 <= n && k2 > k1) {
                        String strnum = str.substring(k1, k2);
                        try {
                            int num = Integer.parseInt(strnum, base);
                            sb.append((char)num);
                            k = k2 + 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (k >= k2) continue;
                    sb.append(str.substring(k, k2));
                    k = k2;
                    continue;
                }
                sb.append(c);
                ++k;
                continue;
            }
            sb.append(c);
            ++k;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            XSDDocument xsd = new XSDDocument();
            xsd.load("c:/B2BProxy2/book.dtd", null);
            XsdElementDeclNode decl = (XsdElementDeclNode)xsd.getElementDecl("Item");
            System.out.println(xsd.toString());
        }
        catch (IOException xsd) {
        }
        catch (XSDException e) {
            System.out.println(e);
        }
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public static void fatal(Exception e, Locator locator) throws XSDException {
        throw new XSDException(null, locator, e);
    }

    public static void fatal(Exception orgEx, String msgID, Locator locator) throws XSDException {
        String msg = msgCatalog.getMessage(msgID);
        XSDException e = new XSDException(msg, locator, orgEx);
        e.msgID = msgID;
        throw e;
    }

    public static void fatal(String msgID, Locator locator) throws XSDException {
        XSDDocument.fatal(msgID, locator, new Object[0]);
    }

    public static void fatal(String msgID, Locator locator, String s) throws XSDException {
        XSDDocument.fatal(msgID, locator, new Object[]{s});
    }

    public static void fatal(String msgID, Locator locator, Object[] parameters) throws XSDException {
        String msg = msgCatalog.getMessage(msgID, parameters);
        XSDException e = new XSDException(msg, locator);
        e.msgID = msgID;
        throw e;
    }

    public static void fatal(String msgID, XSDDocument xsd, Object[] parameters) throws XSDException {
        String msg = msgCatalog.getMessage(msgID, parameters);
        XSDException e = new XSDException(msg, xsd.publicId, xsd.systemId, 0, 0);
        e.msgID = msgID;
        throw e;
    }

    @Override
    public String getNodeTypeName() {
        return "XSDDecl";
    }

    public String getXmlSchemaPrefix() {
        return this.getPrefixByNamespace("http://www.w3.org/2001/XMLSchema");
    }

    public void setDefaultDataTypeDecl() {
        XsdDeclNode node = null;
        int type = 0;
        int size = 0;
        String val = "";
        for (int i = 0; i < this.nodes.size(); ++i) {
            XsdDeclNode typedecl;
            XsdElementDeclNode ele;
            XsdTypeRef typeref;
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 50 || (typeref = (ele = (XsdElementDeclNode)node).getTypeAttr()) == null || (typedecl = typeref.getDeclNode()) == null || typedecl.getNodeType() != 73) continue;
            XsdDataTypeImpl dataimpl = (XsdDataTypeImpl)typedecl;
            size = 0;
            val = "";
            if (ele.getDefault() != null && ele.getDefault() != "") {
                val = ele.getDefault();
            }
            if (ele.getFixed() != null && ele.getFixed() != "") {
                val = ele.getFixed();
            }
            switch (dataimpl.getDataType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: {
                    type = 1;
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    type = 2;
                    break;
                }
                case 19: {
                    type = 3;
                    break;
                }
                case 20: {
                    type = 4;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    type = 6;
                }
            }
            DataTypeDecl datadecl = new DataTypeDecl(type, size, val);
            ele.setDataTypeDecl(datadecl);
        }
    }

    public XsdTypeRef getDefaultTypeReference() {
        String nsPrefix = this.getXmlSchemaPrefix();
        XsdTypeRef typeRedNode = this.findTypeReferenceProc(null, nsPrefix, "string", 50, 0, false);
        if (typeRedNode == null) {
            return null;
        }
        if (!typeRedNode.isTypeNode()) {
            this.typeNoneDecls.addElement(typeRedNode);
        }
        return typeRedNode;
    }

    public XsdTypeRef findTypeReference(String name2, int nodeType, int findType, boolean oneself) {
        MyPrefix mp = new MyPrefix(name2);
        XsdTypeRef typeRedNode = this.findTypeReferenceProc(null, mp.getPrefix(), mp.getType(), nodeType, findType, oneself);
        if (typeRedNode == null) {
            return null;
        }
        if (!typeRedNode.isTypeNode()) {
            this.typeNoneDecls.addElement(typeRedNode);
        }
        return typeRedNode;
    }

    public XsdTypeRef findTypeReference(XsdTypeRef typeRefNode, String name2, int nodeType, int findType, boolean oneself) {
        MyPrefix mp = new MyPrefix(name2);
        XsdTypeRef typeRedNode = this.findTypeReferenceProc(typeRefNode, mp.getPrefix(), mp.getType(), nodeType, findType, oneself);
        if (typeRedNode == null) {
            return null;
        }
        if (!typeRedNode.isTypeNode()) {
            this.typeNoneDecls.addElement(typeRedNode);
        }
        return typeRedNode;
    }

    protected XsdTypeRef findTypeReferenceProc(XsdTypeRef typeRefNode, String nsPrefix, String type, int nodeType, int findType, boolean oneself) {
        XsdDeclNode node = this.getFirstChild();
        if (node.getNodeType() != 71) {
            return null;
        }
        SchemaDeclNode schemaNode = (SchemaDeclNode)node;
        Hashtable xmlnsList = schemaNode.getXmlnsList();
        if (nsPrefix == null || nsPrefix == "") {
            nsPrefix = "none";
        }
        String nameSpace = (String)xmlnsList.get(nsPrefix);
        XsdDeclNode findTypeNode = null;
        int n = this.xsds.size();
        boolean isFind = false;
        XSDDocument tmpxsd = null;
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            if ((nameSpace != null ? !nameSpace.equals(tmpxsd.getNameSpace()) : tmpxsd.getNameSpace() != null) || (findTypeNode = tmpxsd.getTypeXsdDeclNode(type, nodeType, findType)) == null) continue;
            isFind = true;
            if (typeRefNode == null) {
                typeRefNode = new XsdTypeRefNode((XSDDecl)tmpxsd, type, nodeType, findType);
                break;
            }
            typeRefNode.setXsdDecl(tmpxsd);
            typeRefNode.setNodeString(type);
            break;
        }
        if (!isFind && oneself) {
            findTypeNode = this.getTypeXsdDeclNode(type, nodeType, findType);
            if (findTypeNode != null) {
                if (typeRefNode == null) {
                    typeRefNode = new XsdTypeRefNode((XSDDecl)this, type, nodeType, findType);
                } else {
                    typeRefNode.setXsdDecl(this);
                    typeRefNode.setNodeString(type);
                }
            } else {
                typeRefNode = new XsdTypeRefNode(nsPrefix, type, nodeType, findType);
            }
        }
        return typeRefNode;
    }

    @Override
    public String getTyperefNameAdditionPrefix(String namespace, String typerefName) {
        String pre = this.getPrefixByNamespace(namespace);
        if (pre == null) {
            return typerefName;
        }
        if (pre == "") {
            return typerefName;
        }
        return pre + ":" + typerefName;
    }

    @Override
    public String getPrefixByNamespace(String namespace) {
        if (namespace == null) {
            return "";
        }
        XsdDeclNode node = this.getFirstChild();
        if (node.getNodeType() != 71) {
            return null;
        }
        Object typeRefNode = null;
        SchemaDeclNode schemaNode = (SchemaDeclNode)node;
        Hashtable xmlnsList = schemaNode.getXmlnsList();
        if (!xmlnsList.contains(namespace)) {
            return null;
        }
        Enumeration enumKey = xmlnsList.keys();
        String key = null;
        String nsPrefix = null;
        String tmpNSapce = null;
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            tmpNSapce = (String)xmlnsList.get(key);
            if (!tmpNSapce.equals(namespace)) continue;
            nsPrefix = key;
            break;
        }
        if (key == "none") {
            nsPrefix = "";
        }
        return nsPrefix;
    }

    public void getExternalBuiltinDataType(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            if (!tmpxsd.getNameSpace().equals("http://www.w3.org/2001/XMLSchema")) continue;
            Enumeration enumKey = tmpxsd.dataTypeDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.dataTypeDecls.get(key);
                vec.addElement(prefix + key);
            }
            break;
        }
    }

    public void getExternalGlobalAttribute(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalAttrDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalAttrDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalAttrDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalAttrDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    public void getExternalGlobalElement(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalElementDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalElementDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalElementDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalElementDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    public void getExternalGlobalAttributeGroup(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalAttrgrpDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalAttrgrpDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalAttrgrpDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalAttrgrpDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    public void getExternalGlobalComplexType(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalComplexDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalComplexDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalComplexDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalComplexDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    public void getExternalGlobalSimpleType(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalSimpleDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalSimpleDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalSimpleDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalSimpleDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    public void getExternalGlobalGroup(Vector vec) {
        String prefix = null;
        String key = null;
        XsdDeclNode node = null;
        int n = this.xsds.size();
        XSDDocument tmpxsd = null;
        prefix = this.getPrefixByNamespace(this.nameSpace);
        if (prefix == null) {
            prefix = "";
        } else if (prefix != "") {
            prefix = prefix + ":";
        }
        Enumeration enumKey = this.globalModelgrpDecls.keys();
        while (enumKey.hasMoreElements()) {
            key = (String)enumKey.nextElement();
            node = (XsdDeclNode)this.globalModelgrpDecls.get(key);
            vec.addElement(prefix + key);
        }
        for (int i = 0; i < n; ++i) {
            tmpxsd = (XSDDocument)this.xsds.get(i);
            prefix = this.getPrefixByNamespace(tmpxsd.nameSpace);
            if (prefix == null) {
                prefix = "";
            } else if (prefix != "") {
                prefix = prefix + ":";
            }
            enumKey = tmpxsd.globalModelgrpDecls.keys();
            while (enumKey.hasMoreElements()) {
                key = (String)enumKey.nextElement();
                node = (XsdDeclNode)tmpxsd.globalModelgrpDecls.get(key);
                vec.addElement(prefix + key);
            }
        }
    }

    private void createDataType() {
        try {
            XsdDataTypeImpl decl = new XsdDataTypeImpl(1, "normalizedString");
            this.dataTypeDecls.put("normalizedString", decl);
            decl = new XsdDataTypeImpl(0, "string");
            this.dataTypeDecls.put("string", decl);
            decl = new XsdDataTypeImpl(2, "token");
            this.dataTypeDecls.put("token", decl);
            decl = new XsdDataTypeImpl(3, "byte");
            this.dataTypeDecls.put("byte", decl);
            decl = new XsdDataTypeImpl(4, "unsignedByte");
            this.dataTypeDecls.put("unsignedByte", decl);
            decl = new XsdDataTypeImpl(5, "base64Binary");
            this.dataTypeDecls.put("base64Binary", decl);
            decl = new XsdDataTypeImpl(6, "hexBinary");
            this.dataTypeDecls.put("hexBinary", decl);
            decl = new XsdDataTypeImpl(7, "integer");
            this.dataTypeDecls.put("integer", decl);
            decl = new XsdDataTypeImpl(8, "positiveInteger");
            this.dataTypeDecls.put("positiveInteger", decl);
            decl = new XsdDataTypeImpl(9, "negativeInteger");
            this.dataTypeDecls.put("negativeInteger", decl);
            decl = new XsdDataTypeImpl(10, "nonNegativeInteger");
            this.dataTypeDecls.put("nonNegativeInteger", decl);
            decl = new XsdDataTypeImpl(11, "nonPositiveInteger");
            this.dataTypeDecls.put("nonPositiveInteger", decl);
            decl = new XsdDataTypeImpl(12, "int");
            this.dataTypeDecls.put("int", decl);
            decl = new XsdDataTypeImpl(13, "unsignedInt");
            this.dataTypeDecls.put("unsignedInt", decl);
            decl = new XsdDataTypeImpl(14, "long");
            this.dataTypeDecls.put("long", decl);
            decl = new XsdDataTypeImpl(15, "unsignedLong");
            this.dataTypeDecls.put("unsignedLong", decl);
            decl = new XsdDataTypeImpl(16, "short");
            this.dataTypeDecls.put("short", decl);
            decl = new XsdDataTypeImpl(17, "unsignedShort");
            this.dataTypeDecls.put("unsignedShort", decl);
            decl = new XsdDataTypeImpl(18, "decimal");
            this.dataTypeDecls.put("decimal", decl);
            decl = new XsdDataTypeImpl(19, "float");
            this.dataTypeDecls.put("float", decl);
            decl = new XsdDataTypeImpl(20, "double");
            this.dataTypeDecls.put("double", decl);
            decl = new XsdDataTypeImpl(21, "boolean");
            this.dataTypeDecls.put("boolean", decl);
            decl = new XsdDataTypeImpl(22, "time");
            this.dataTypeDecls.put("time", decl);
            decl = new XsdDataTypeImpl(23, "dateTime");
            this.dataTypeDecls.put("dateTime", decl);
            decl = new XsdDataTypeImpl(24, "duration");
            this.dataTypeDecls.put("duration", decl);
            decl = new XsdDataTypeImpl(25, "date");
            this.dataTypeDecls.put("date", decl);
            decl = new XsdDataTypeImpl(26, "gMonth");
            this.dataTypeDecls.put("gMonth", decl);
            decl = new XsdDataTypeImpl(27, "gYear");
            this.dataTypeDecls.put("gYear", decl);
            decl = new XsdDataTypeImpl(28, "gYearMonth");
            this.dataTypeDecls.put("gYearMonth", decl);
            decl = new XsdDataTypeImpl(29, "gDay");
            this.dataTypeDecls.put("gDay", decl);
            decl = new XsdDataTypeImpl(30, "gMonthDay");
            this.dataTypeDecls.put("gMonthDay", decl);
            decl = new XsdDataTypeImpl(31, "Name");
            this.dataTypeDecls.put("Name", decl);
            decl = new XsdDataTypeImpl(32, "QName");
            this.dataTypeDecls.put("QName", decl);
            decl = new XsdDataTypeImpl(33, "NCName");
            this.dataTypeDecls.put("NCName", decl);
            decl = new XsdDataTypeImpl(34, "anyURI");
            this.dataTypeDecls.put("anyURI", decl);
            decl = new XsdDataTypeImpl(35, "language");
            this.dataTypeDecls.put("language", decl);
            decl = new XsdDataTypeImpl(36, "ID");
            this.dataTypeDecls.put("ID", decl);
            decl = new XsdDataTypeImpl(37, "IDREF");
            this.dataTypeDecls.put("IDREF", decl);
            decl = new XsdDataTypeImpl(38, "IDREFS");
            this.dataTypeDecls.put("IDREFS", decl);
            decl = new XsdDataTypeImpl(39, "ENTITY");
            this.dataTypeDecls.put("ENTITY", decl);
            decl = new XsdDataTypeImpl(40, "ENTITIES");
            this.dataTypeDecls.put("ENTITIES", decl);
            decl = new XsdDataTypeImpl(41, "NMTOKEN");
            this.dataTypeDecls.put("NMTOKEN", decl);
            decl = new XsdDataTypeImpl(42, "NMTOKENS");
            this.dataTypeDecls.put("NMTOKENS", decl);
            decl = new XsdDataTypeImpl(45, "anyType");
            this.dataTypeDecls.put("anyType", decl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getValueOnly(String value) {
        MyPrefix mp = new MyPrefix(value);
        return mp.getType();
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
        String lang = System.getProperty("user.msg.lang", null);
        if (lang == null) {
            lang = Locale.getDefault().getLanguage();
        }
        String classbase = "com.argo21.jxp.xsd.XSDMessageCatalog_";
        try {
            msgCatalog = (MessageCatalog)Class.forName(classbase + lang).newInstance();
        }
        catch (Exception e) {
            try {
                msgCatalog = (MessageCatalog)Class.forName(classbase + "en").newInstance();
            }
            catch (Exception e1) {
                System.out.println(e1);
                System.exit(1);
            }
        }
    }

    static class MyPrefix {
        String myPrefix = null;
        String myType = null;
        String allStrings = null;

        MyPrefix() {
        }

        MyPrefix(String allStrings) {
            this.allStrings = allStrings;
            this.devideAllString();
        }

        void setAllStrings(String allStrings) {
            this.allStrings = allStrings;
            this.devideAllString();
        }

        void devideAllString() {
            if (this.allStrings == null) {
                this.myPrefix = null;
                this.myType = null;
                return;
            }
            int i = this.allStrings.indexOf(":");
            if (i > 0) {
                this.myPrefix = this.allStrings.substring(0, i);
                this.myType = this.allStrings.substring(i + 1);
            } else {
                this.myPrefix = null;
                this.myType = this.allStrings;
            }
        }

        String getPrefix() {
            return this.myPrefix;
        }

        void setPrefix(String prefix) {
            this.myPrefix = prefix;
        }

        String getType() {
            return this.myType;
        }

        void setType(String type) {
            this.myType = type;
        }

        String getAllStrings() {
            return this.allStrings;
        }
    }
}

