/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdElementDecl;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDExtractor
extends Vector {
    Hashtable elementTable = new Hashtable();

    public XSDExtractor(Document document) {
        Element root = document.getDocumentElement();
        this.extractNodeToXSD(root);
    }

    private int findElementEntity(String name2) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!name2.equals(((ElementEntity)this.elementData[i]).elemname)) continue;
            return i;
        }
        return -1;
    }

    private int findSubName(Vector v, String name2) {
        int n = v.size();
        for (int i = 0; i < v.size(); ++i) {
            if (!name2.equals(((ContentsEntity)v.elementAt((int)i)).elemname)) continue;
            return i;
        }
        return -1;
    }

    private boolean extractNodeToXSD(Node node) {
        if (node.getNodeType() == 1) {
            Node child;
            int i;
            String nname = node.getNodeName();
            boolean multi = false;
            ElementEntity pe = (ElementEntity)this.elementTable.get(nname);
            if (pe == null) {
                pe = new ElementEntity(nname);
                this.addElement(pe);
                this.elementTable.put(nname, pe);
            }
            ++pe.occ;
            NodeList children = node.getChildNodes();
            int nChildren = children.getLength();
            Vector v = pe.contents;
            for (int i2 = 0; i2 < nChildren; ++i2) {
                int k;
                Node child2 = children.item(i2);
                ContentsEntity se = null;
                if (child2.getNodeType() == 1) {
                    String name2 = child2.getNodeName();
                    if (this.elementTable.get(name2) == null) {
                        ElementEntity spe = new ElementEntity(name2);
                        this.addElement(spe);
                        this.elementTable.put(name2, spe);
                    }
                    if ((k = this.findSubName(v, name2)) < 0) {
                        se = new ContentsEntity(name2);
                    }
                } else if (child2.getNodeType() == 3) {
                    String s = child2.getNodeValue();
                    if (s == null || s.trim().equals("")) continue;
                    k = this.findSubName(v, "#PCDATA");
                    if (k < 0) {
                        se = new ContentsEntity("#PCDATA");
                    }
                } else {
                    k = -1;
                }
                if (k >= 0) {
                    se = (ContentsEntity)v.elementAt(k);
                    if (pe.occ >= 2) continue;
                    se.elemtype = 1;
                    continue;
                }
                if (se == null) continue;
                v.addElement(se);
            }
            NamedNodeMap attrs = node.getAttributes();
            int n = attrs.getLength();
            for (i = 0; i < n; ++i) {
                child = attrs.item(i);
                int k = this.findSubName(v, child.getNodeName());
                if (k >= 0) continue;
                ContentsEntity se = new ContentsEntity(child.getNodeName());
                se.elemtype = 2;
                v.addElement(se);
            }
            for (i = 0; i < nChildren; ++i) {
                child = children.item(i);
                if (!child.hasChildNodes()) continue;
                this.extractNodeToXSD(child);
            }
        }
        return true;
    }

    public String getXML() {
        String sn;
        int i;
        int max = this.size();
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < max; ++i) {
            sn = this.getElementName(i);
            String ec = this.getElementContents(i);
            if (ec == null) continue;
            buf.append("<!ELEMENT ");
            buf.append(sn);
            buf.append(" ");
            buf.append(ec);
            buf.append(">\n");
        }
        for (i = 0; i < max; ++i) {
            sn = this.getElementName(i);
            String ac = this.getAttributeContents(i);
            if (ac == null) continue;
            buf.append("<!ATTLIST ");
            buf.append(sn);
            buf.append(" ");
            buf.append(ac);
            buf.append(">\n");
        }
        return buf.toString();
    }

    public XsdElementDecl[] getElementDecls(XSDDecl xsd) {
        int n = this.size();
        XsdElementDecl[] res = new XsdElementDecl[n];
        for (int i = 0; i < n; ++i) {
            ElementEntity pe = (ElementEntity)this.elementAt(i);
            res[i] = this.getElementDecl(pe, xsd);
        }
        return res;
    }

    private XsdElementDecl getElementDecl(ElementEntity pe, XSDDecl xsd) {
        String name2 = pe.elemname;
        Vector v = pe.contents;
        int n = v.size();
        boolean hasPCData = false;
        boolean hasElement = false;
        boolean hasAttr = false;
        Vector<String> elem_names = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            ContentsEntity se = (ContentsEntity)v.elementAt(i);
            if (se.elemname.equals("#PCDATA")) {
                hasPCData = true;
                continue;
            }
            if (se.elemtype != 2) {
                elem_names.addElement(se.elemname);
                hasElement = true;
                continue;
            }
            hasAttr = true;
        }
        XsdElementDecl elem = null;
        return elem;
    }

    public String getElementName(int index) {
        int max = this.size() - 1;
        if (index > max || index < 0) {
            return null;
        }
        ElementEntity pe = (ElementEntity)this.elementAt(index);
        return pe.elemname;
    }

    public String getElementContents(int index) {
        ContentsEntity se;
        int i;
        int max = this.size() - 1;
        if (index > max || index < 0) {
            return null;
        }
        ElementEntity pe = (ElementEntity)this.elementAt(index);
        Vector v = pe.contents;
        int max1 = v.size() - 1;
        if (max1 < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer("(");
        boolean hasElement = false;
        boolean hasPCData = false;
        for (i = 0; i <= max1; ++i) {
            se = (ContentsEntity)v.elementAt(i);
            if (se.elemname.equals("#PCDATA")) {
                hasPCData = true;
                break;
            }
            if (se.elemtype == 0) {
                if (hasElement) {
                    buf.append(",");
                }
                hasElement = true;
                buf.append(se.elemname);
                continue;
            }
            if (se.elemtype != 1) continue;
            if (hasElement) {
                buf.append(",");
            }
            hasElement = true;
            buf.append(se.elemname);
            buf.append("*");
        }
        if (hasPCData) {
            buf = new StringBuffer("(");
            hasElement = false;
            if (max1 == 1) {
                ContentsEntity se2 = (ContentsEntity)v.elementAt(0);
                buf.append(se2.elemname);
                hasElement = true;
                buf.append(')');
                if (se2.elemtype == 1) {
                    buf.append('*');
                }
            } else {
                for (i = 0; i <= max1; ++i) {
                    se = (ContentsEntity)v.elementAt(i);
                    if (hasElement) {
                        buf.append("|");
                    }
                    hasElement = true;
                    buf.append(se.elemname);
                }
                buf.append(")*");
            }
        } else {
            buf.append(")");
        }
        if (hasElement) {
            return buf.toString();
        }
        return null;
    }

    public String getAttributeContents(int index) {
        int max = this.size() - 1;
        if (index > max || index < 0) {
            return null;
        }
        ElementEntity pe = (ElementEntity)this.elementAt(index);
        Vector v = pe.contents;
        int max1 = v.size() - 1;
        if (max1 < 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean hasElement = false;
        for (int i = 0; i <= max1; ++i) {
            ContentsEntity se = (ContentsEntity)v.elementAt(i);
            if (se.elemtype != 2) continue;
            if (hasElement) {
                buf.append("\n");
            }
            hasElement = true;
            buf.append(se.elemname);
            buf.append(" CDATA  #IMPLIED");
        }
        if (hasElement) {
            return buf.toString();
        }
        return null;
    }

    class ContentsEntity {
        protected String elemname;
        protected int elemtype;

        ContentsEntity(String name2) {
            this.elemname = name2;
            this.elemtype = 0;
        }
    }

    class ElementEntity {
        String elemname;
        Vector contents;
        int occ = 0;

        public ElementEntity(String name2) {
            this.elemname = name2;
            this.contents = new Vector();
        }
    }
}

