/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdAppinfoDoc;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import java.util.Vector;

public class XsdAppinfoDocNode
implements XsdAppinfoDoc {
    int type;
    String source = null;
    String lang = null;
    String text = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public XsdAppinfoDocNode(XSDDecl xsd, int type, String source) {
        this.xsd = xsd;
        this.type = type;
        this.source = source;
    }

    public XsdAppinfoDocNode(XSDDecl xsd, int type) {
        this.xsd = xsd;
        this.type = type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 67;
    }

    @Override
    public String getNodeName() {
        return this.getModeName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "AppinfoDoc";
    }

    public String getName() {
        return this.getModeName();
    }

    private String getModeName() {
        if (this.type == 0) {
            return "appinfo";
        }
        if (this.type == 1) {
            return "documentation";
        }
        return null;
    }

    public String getXML() {
        String typeRefbaseName = "";
        String prefix = "";
        StringBuffer sb = new StringBuffer();
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + this.getModeName());
        if (this.source != null && this.source != "") {
            sb.append(" source=\"" + this.source + "\" ");
        }
        if (this.type == 1 && this.lang != null && this.lang != "") {
            sb.append(" xml:lang=\"" + this.lang + "\" ");
        }
        if (this.text != null && this.text != "") {
            sb.append(">\n");
            sb.append(this.text + "\n");
            sb.append("</" + prefix + this.getModeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

