/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.XmlChars;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XSDException;
import com.argo21.jxp.xsd.XsdAttDef;
import com.argo21.jxp.xsd.XsdAttDefault;
import com.argo21.jxp.xsd.XsdAttDefaultImpl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.util.Vector;
import org.xml.sax.Locator;

public class XsdAttDefNode
implements XsdAttDef {
    String name;
    XsdTypeRef attType;
    XsdAttDefault attDefault;
    XsdTypeRef ref;
    String elementname;
    String form;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;
    DataTypeDecl dtDecl;
    boolean isEntityRef = false;
    private XReader in = null;

    public XsdAttDefNode(XSDDecl xsd, String attributeName, XsdTypeRef attType, String attUse, String attFixed, String attDefault) {
        this.name = attributeName;
        this.isEntityRef = false;
        this.xsd = xsd;
        this.attType = attType;
        try {
            this.attDefault = this.parseAttDefault(this.attType, attUse, attFixed, attDefault);
        }
        catch (XSDException e) {
            e.printStackTrace();
        }
    }

    public XsdAttDefNode(XSDDecl xsd, XsdTypeRef ref) {
        this.ref = ref;
        this.isEntityRef = false;
        this.xsd = xsd;
        this.name = null;
        this.attType = null;
        this.attDefault = null;
    }

    public XsdAttDefNode(String attributeName, XsdTypeRef attType, XsdAttDefault attDefault) {
        this(null, attributeName, attType, attDefault);
    }

    public XsdAttDefNode(XSDDecl xsd, String attributeName, XsdTypeRef attType, XsdAttDefault attDefault) {
        this.name = attributeName;
        this.attType = attType;
        this.attDefault = attDefault;
        this.isEntityRef = false;
        this.xsd = xsd;
    }

    XsdAttDefNode(XSDDecl xsd, XReader in) throws XSDException {
        this.xsd = xsd;
        this.in = in;
        this.in = null;
    }

    @Override
    public String getNodeTypeName() {
        return "AttList";
    }

    @Override
    public int getNodeType() {
        return 55;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return this.name;
    }

    @Override
    public String getElementName() {
        return this.elementname;
    }

    @Override
    public boolean isEntityRef() {
        return this.isEntityRef;
    }

    public String getEntityName() {
        return this.name;
    }

    public void setEntityName(String name2) {
        if (this.isEntityRef) {
            this.name = name2;
        }
    }

    private void parseAttDef() throws XSDException {
        this.in.peekWhitespace();
        if (this.in.peekc('%')) {
            String entityName = this.in.peekXmlName();
            if (entityName == null) {
                XSDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
            }
            if (!this.in.peekc(';')) {
                XSDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
            }
            this.name = entityName;
            this.attType = null;
            this.attDefault = null;
            this.isEntityRef = true;
        } else {
            this.name = this.in.peekXmlName();
            if (this.name == null) {
                XSDDocument.fatal("NEED_ATTR_NAME", (Locator)this.in);
            }
            if (!this.in.peekWhitespace()) {
                XSDDocument.fatal("NEED_ATTR_NAME", (Locator)this.in);
            }
            this.in.peekWhitespace();
            this.attDefault = this.parseAttDefault(this.attType);
            this.isEntityRef = false;
        }
    }

    private XsdAttDefault parseAttDefault(XsdTypeRef attType) throws XSDException {
        int typecode = -1;
        int quote = 34;
        String attfixed = null;
        String attvalue = null;
        if (this.in.peek("required")) {
            typecode = 3;
        } else if (this.in.peek("optional")) {
            typecode = 4;
        } else if (this.in.peek("prohibited")) {
            typecode = 5;
        }
        return new XsdAttDefaultImpl(typecode, attvalue, attfixed);
    }

    private String parseAttValue() throws XSDException {
        char c;
        char quote = this.in.getc();
        if (quote != '\'' && quote != '\"') {
            XSDDocument.fatal("NEED_QUOTE", (Locator)this.in);
        }
        StringBuffer strTmp = new StringBuffer();
        while (!this.in.isEOF() && (c = this.in.getc()) != quote) {
            if (c == '&') {
                if (this.in.peekc('#')) {
                    int tmp = this.in.peekCharNumber();
                    if (tmp < 0) {
                        XSDDocument.fatal("NEED_NUM_AFTER", (Locator)this.in, "&#");
                    }
                    if (tmp > 65535) {
                        if (tmp <= 0x10FFFF) {
                            strTmp.append((char)(0xD800 | (tmp -= 65536) >> 10 & 0x3FF));
                            strTmp.append((char)(0xDC00 | tmp & 0x3FF));
                            continue;
                        }
                        String s = "&#x" + Integer.toHexString(tmp);
                        XSDDocument.fatal("INVALID_CHAR", (Locator)this.in, s);
                        continue;
                    }
                    strTmp.append((char)tmp);
                    continue;
                }
                String entityName = this.in.peekXmlName();
                if (entityName != null) {
                    if (!this.in.peekc(';')) {
                        XSDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
                    }
                    strTmp.append('&');
                    strTmp.append(entityName);
                    strTmp.append(';');
                    continue;
                }
                XSDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "&");
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                strTmp.append(' ');
                continue;
            }
            if (c == '<') {
                XSDDocument.fatal("INVALID_CHAR", (Locator)this.in, "<");
            }
            strTmp.append(c);
        }
        return strTmp.toString();
    }

    private XsdAttDefault parseAttDefault(XsdTypeRef attType, String attUse, String sDefault, String fixed) throws XSDException {
        int useType = 0;
        int quote = 34;
        Object attvalue = null;
        if (attUse == null && sDefault == null && fixed == null) {
            return null;
        }
        if (attUse != null) {
            if (attUse.equals("required")) {
                useType = 3;
            } else if (attUse.equals("optional")) {
                useType = 4;
            } else if (attUse.equals("prohibited")) {
                useType = 5;
            }
        }
        if (sDefault != null) {
            if (fixed != null) {
                fixed = null;
            } else if (attUse != null && !attUse.equals("optional")) {
                useType = 4;
            }
        }
        return new XsdAttDefaultImpl(useType, sDefault, fixed);
    }

    static void makeAttDefault(StringBuffer sb, XsdAttDefault defaultDecl) {
        int useType = defaultDecl.getUseType();
        if (useType == 3) {
            sb.append("use=\"required\"");
        } else if (useType == 4) {
            sb.append("use=\"optional\"");
        } else if (useType == 5) {
            sb.append("use=\"prohibited\"");
        }
        int type = defaultDecl.getType();
        if (defaultDecl.getValue() != null) {
            if (type == 1) {
                sb.append(' ');
                sb.append("default=\"" + defaultDecl.getValue() + "\"");
            } else if (type == 2) {
                sb.append(' ');
                sb.append("fixed=\"" + defaultDecl.getValue() + "\"");
            }
        }
    }

    public void repleaceEntity() throws XSDException {
    }

    @Override
    public XsdAttDefault getAttDefault() {
        return this.attDefault;
    }

    public void setAttDefault(XsdAttDefault attdef) {
        this.attDefault = attdef;
    }

    @Override
    public XsdTypeRef getAttType() {
        return this.attType;
    }

    @Override
    public XsdTypeRef getRef() {
        return this.ref;
    }

    public boolean isRef() {
        return this.ref != null;
    }

    @Override
    public boolean isLocal() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.getNodeType() != 71;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return this.dtDecl;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
        this.dtDecl = dtDecl;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getXML() {
        XSDDecl tmpxsd;
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        String typeRefName = "";
        StringBuffer sb = new StringBuffer();
        if (this.ref != null) {
            sb.append("<" + prefix + "attribute ref=\"");
            typeRefName = this.ref.toString();
            tmpxsd = this.ref.getXsdDecl();
            if (tmpxsd != null && this.xsd != null) {
                typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.ref.toString());
            }
            sb.append(typeRefName);
            sb.append("\"");
            if (this.attDefault != null) {
                sb.append(this.makeDeclContent());
            }
        } else {
            sb.append("<" + prefix + "attribute name=\"");
            sb.append(this.name);
            sb.append("\" ");
            if (this.attType != null) {
                sb.append(" type=\"");
                typeRefName = this.attType.toString();
                tmpxsd = this.attType.getXsdDecl();
                if (tmpxsd != null && this.xsd != null) {
                    typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.attType.toString());
                }
                sb.append(typeRefName);
                sb.append("\"");
            }
            if (this.attDefault != null) {
                sb.append(this.makeDeclContent());
            }
            if (this.form != null && this.form != "") {
                sb.append(" form=\"" + this.form + "\"");
            }
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "attribute>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }

    public String toString() {
        return this.getXML();
    }

    String makeDeclContent() {
        if (this.isEntityRef) {
            return "%" + this.name + ";";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(' ');
        XsdAttDefNode.makeAttDefault(sb, this.attDefault);
        return sb.toString();
    }

    @Override
    public XsdDeclNode getOwner() {
        return this.xsd;
    }

    @Override
    public String getRefName() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return null;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public XSDDecl getXsd() {
        return this.xsd;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    static String normalize(String s, boolean invalidIfNeeded) {
        String s2 = s.trim();
        boolean didStrip = false;
        if (s != s2) {
            s = s2;
            s2 = null;
            didStrip = true;
        }
        StringBuffer strTmp = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!XmlChars.isSpace(c)) {
                strTmp.append(c);
                continue;
            }
            strTmp.append(' ');
            while (++i < s.length() && XmlChars.isSpace(s.charAt(i))) {
                didStrip = true;
            }
            --i;
        }
        if (invalidIfNeeded && (s2 == null || didStrip)) {
            return null;
        }
        if (didStrip) {
            return strTmp.toString();
        }
        return s;
    }
}

