/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdDeclNodeList;

public class XsdDeclNodeListImpl
implements XsdDeclNodeList {
    protected XsdDeclNode[] elements = null;
    private int elementCount;

    private final synchronized void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (minCapacity > oldCapacity) {
            XsdDeclNode[] oldData = this.elements;
            int newCapacity = oldCapacity + 4;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = new XsdDeclNode[newCapacity];
            System.arraycopy(oldData, 0, this.elements, 0, this.elementCount);
        }
    }

    public XsdDeclNodeListImpl() {
        this.elements = new XsdDeclNode[4];
        this.elementCount = 0;
    }

    public XsdDeclNodeListImpl(int minCapacity) {
        this.elements = new XsdDeclNode[minCapacity];
        this.elementCount = 0;
    }

    public void addElement(XsdDeclNode node) {
        this.ensureCapacity(this.elementCount + 1);
        this.elements[this.elementCount++] = node;
    }

    public void addOnlyElement(XsdDeclNode node) {
        String name2 = node.getNodeName();
        for (int i = 0; i < this.elementCount; ++i) {
            if (this.elements[i] == null) continue;
            if (name2.equals(this.elements[i].getNodeName())) {
                this.elements[i] = node;
            }
            return;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.elements[this.elementCount++] = node;
    }

    @Override
    public int getLength() {
        return this.elementCount;
    }

    @Override
    public XsdDeclNode item(int index) {
        if (index >= 0 & index < this.elementCount) {
            return this.elements[index];
        }
        return null;
    }

    public final synchronized void insertElementAt(XsdDeclNode decl, int index) {
        int newcount = this.elementCount + 1;
        if (index >= newcount) {
            throw new ArrayIndexOutOfBoundsException(index + " > " + this.elementCount);
        }
        if (newcount > this.elements.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.elements, index, this.elements, index + 1, this.elementCount - index);
        this.elements[index] = decl;
        ++this.elementCount;
    }

    public final int indexOf(XsdDeclNode decl) {
        return this.indexOf(decl, 0);
    }

    public final synchronized int indexOf(XsdDeclNode decl, int index) {
        for (int i = index; i < this.elementCount; ++i) {
            if (!decl.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    @Override
    public final synchronized XsdDeclNode elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        try {
            return this.elements[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public final synchronized boolean removeElement(XsdDeclNode decl) {
        int i = this.indexOf(decl);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, j);
        }
        --this.elementCount;
        this.elements[this.elementCount] = null;
    }
}

