/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.ComplexTypeNode;
import com.argo21.jxp.xsd.ContentModelNode;
import com.argo21.jxp.xsd.DerivationNode;
import com.argo21.jxp.xsd.MgsDeclNode;
import com.argo21.jxp.xsd.ModelGroupNode;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XSDException;
import com.argo21.jxp.xsd.XsdAttDef;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdDeclNodeList;
import com.argo21.jxp.xsd.XsdDeclNodeListImpl;
import com.argo21.jxp.xsd.XsdElementDecl;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Locator;

public class XsdElementDeclNode
implements XsdElementDecl {
    Hashtable attributeDefs = null;
    Vector childNames = null;
    XsdChildren children = null;
    String name;
    int type;
    XsdTypeRef typeAttr;
    XsdTypeRef ref;
    String minOcc = null;
    String maxOcc = null;
    String sDefault = null;
    boolean bAbstract = false;
    String block = null;
    String fixed = null;
    String sFinal = null;
    boolean nillable = false;
    XsdTypeRef subtitutionGroup = null;
    String form = null;
    XSDDecl xsd = null;
    DataTypeDecl dtDecl = null;
    boolean isRef = false;
    XsdDeclNodeListImpl parents = null;
    XsdDeclNode parent = null;
    private XReader in = null;
    private int CurrentHigherMaxOcc = 0;

    public XsdElementDeclNode(XSDDecl xsd, String declName) {
        this.xsd = xsd;
        this.name = declName;
        this.type = 8;
        this.isRef = false;
    }

    public XsdElementDeclNode(XSDDecl xsd, String declName, XsdTypeRef typeModel) {
        this.xsd = xsd;
        this.name = declName;
        this.typeAttr = typeModel;
        this.type = 5;
        this.isRef = false;
    }

    public XsdElementDeclNode(XSDDecl xsd, XsdTypeRef refModel, int declType) {
        this.xsd = xsd;
        this.ref = refModel;
        this.type = 2;
        this.isRef = true;
    }

    XsdElementDeclNode(XSDDecl xsd, String declName, char[] contentspec) throws XSDException {
        this.xsd = xsd;
        this.name = declName;
        this.in = XReader.createReader(contentspec, null);
        if (xsd != null) {
            this.in.setPublicId(xsd.getPublicId());
            this.in.setSystemId(xsd.getSystemId());
            this.in.setEncoding(xsd.getEncoding());
        }
        this.parseDeclContent();
        this.in = null;
    }

    XsdElementDeclNode(XSDDecl xsd, String declPrefix, XReader in) throws XSDException {
        this.xsd = xsd;
        this.in = in;
        this.name = in.peekQuotedString();
        if (this.name != null) {
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("NEED_ELEM_NAME", (Locator)in, this.name);
            }
            this.parseDeclContent();
        } else {
            XSDDocument.fatal("NEED_ELEM_NAME", (Locator)in, this.name);
        }
        this.in = null;
    }

    public void setDefault(String sDefault) {
        this.sDefault = sDefault;
    }

    @Override
    public String getDefault() {
        return this.sDefault;
    }

    public void setFixed(String fixed) {
        this.fixed = fixed;
    }

    @Override
    public String getFixed() {
        return this.fixed;
    }

    public void setBlock(String block) {
        this.block = block;
    }

    @Override
    public String getBlock() {
        return this.block;
    }

    public void setFinal(String sFinal) {
        this.sFinal = sFinal;
    }

    @Override
    public String getFinal() {
        return this.sFinal;
    }

    public void setForm(String form) {
        this.form = form;
    }

    @Override
    public String getForm() {
        return this.form;
    }

    public void setSubtitutionGroup(XsdTypeRef subtitutionGroup) {
        this.subtitutionGroup = subtitutionGroup;
    }

    @Override
    public XsdTypeRef getSubtitutionGroup() {
        return this.subtitutionGroup;
    }

    public void setAbstract(String sAbstract) {
        this.bAbstract = sAbstract == null ? false : sAbstract.equals("true");
    }

    public void setAbstract(boolean bAbstract) {
        this.bAbstract = bAbstract;
    }

    @Override
    public String getAbstract() {
        if (this.bAbstract) {
            return "true";
        }
        return "false";
    }

    public boolean getAbstractBool() {
        return this.bAbstract;
    }

    public void setNillable(String nillable) {
        this.nillable = nillable == null ? false : nillable.equals("true");
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    @Override
    public String getNillable() {
        if (this.nillable) {
            return "true";
        }
        return "false";
    }

    public boolean getNillableBool() {
        return this.nillable;
    }

    @Override
    public void setMinOccurs(String minOcc) {
        this.minOcc = minOcc;
    }

    @Override
    public String getMinOccursString() {
        return this.minOcc;
    }

    @Override
    public int getMinOccurs() {
        if (this.minOcc == null || this.minOcc == "") {
            return 1;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.minOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @Override
    public void setMaxOccurs(String maxOcc) {
        this.maxOcc = maxOcc;
    }

    @Override
    public String getMaxOccursString() {
        return this.maxOcc;
    }

    @Override
    public int getMaxOccurs() {
        if (this.maxOcc == null || this.maxOcc == "") {
            return 1;
        }
        if (this.maxOcc.equals("unbounded")) {
            return 10000;
        }
        int num = 1;
        try {
            num = Integer.parseInt(this.maxOcc);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return num;
    }

    @Override
    public int getNodeType() {
        return 50;
    }

    @Override
    public XSDDecl getXsd() {
        return this.xsd;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    public XsdDeclNodeList getParentDecls() {
        if (this.parents == null) {
            return new XsdDeclNodeListImpl(0);
        }
        return this.parents;
    }

    void addParentDecl(XsdElementDecl node) {
        if (this.parents == null) {
            this.parents = new XsdDeclNodeListImpl(1);
        }
        this.parents.addElement(node);
    }

    public void addParentDecl(XsdDeclNode node) {
        if (this.parents == null) {
            this.parents = new XsdDeclNodeListImpl(1);
        }
        this.parents.addElement(node);
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public boolean isRef() {
        return this.ref != null;
    }

    public boolean isLocal() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.getNodeType() == 71) {
            return false;
        }
        return !this.isRef();
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        if (!this.hasChildren()) {
            if (this.typeAttr == null) {
                return 7;
            }
        } else {
            Vector vector = this.children.getChildrenList();
        }
        return this.type;
    }

    @Override
    public String getNodeTypeName() {
        return "Element";
    }

    @Override
    public String getName() {
        if (this.ref != null) {
            return this.ref.toString();
        }
        return this.name;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public XsdTypeRef getTypeAttr() {
        return this.typeAttr;
    }

    @Override
    public XsdTypeRef getRef() {
        return this.ref;
    }

    @Override
    public String getRefName() {
        return this.ref.toString();
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public XsdDeclNodeList getAttListDecls() {
        XsdDeclNodeListImpl list;
        Hashtable atts = this.getAttDefs();
        if (atts != null) {
            list = new XsdDeclNodeListImpl(atts.size());
            Enumeration enumattr = atts.elements();
            while (enumattr.hasMoreElements()) {
                list.addElement((XsdDeclNode)enumattr.nextElement());
            }
        } else {
            list = new XsdDeclNodeListImpl(0);
        }
        return list;
    }

    @Override
    public XsdAttDef getAttListDecl(String attribute) {
        Hashtable atts = this.getAttDefs();
        if (atts == null) {
            return null;
        }
        return (XsdAttDef)atts.get(attribute);
    }

    @Override
    public boolean hasSubElementDecls() {
        if (this.type == 5) {
            return this.childNames != null;
        }
        return this.type == 8;
    }

    @Override
    public XsdDeclNodeList getSubElementDecls() {
        int n;
        Vector nv;
        Vector child = null;
        XsdDeclNodeListImpl list = null;
        XsdTypeRef typeattr = this.getTypeAttr();
        if (typeattr != null) {
            XSDDecl tmpxsd = typeattr.getXsdDecl();
            XsdDeclNode tmpdeclnode = typeattr.getDeclNode();
            if (tmpdeclnode.getNodeType() != 73) {
                XsdChildren children = tmpdeclnode.getChildren();
                if (children == null) {
                    return new XsdDeclNodeListImpl(0);
                }
                nv = this.getChildNames();
                if (nv == null) {
                    return new XsdDeclNodeListImpl(0);
                }
                n = nv.size();
                list = new XsdDeclNodeListImpl(n);
                child = children.getChildrenList();
            }
        }
        if (child == null) {
            if (this.children == null) {
                return new XsdDeclNodeListImpl(0);
            }
            nv = this.getChildNames();
            if (nv == null) {
                return new XsdDeclNodeListImpl(0);
            }
            n = nv.size();
            list = new XsdDeclNodeListImpl(n);
            child = this.children.getChildrenList();
        }
        this.GetSubElementChild(child, list, null);
        return list;
    }

    private void GetSubElementChild(Vector child, XsdDeclNodeListImpl list, XsdDeclNode grp) {
        int n = child.size();
        for (int i = 0; i < n; ++i) {
            XsdChildren childnode;
            XsdDeclNode tmpdeclnode;
            XsdTypeRef typeref;
            XsdDeclNode node = (XsdDeclNode)child.elementAt(i);
            if (node.getNodeType() == 51) {
                this.GetSubElementChild(((XsdChildren)node).getChildrenList(), list, grp);
                continue;
            }
            if (node.getNodeType() == 50) {
                XsdElementDeclNode elenode = (XsdElementDeclNode)node;
                if (elenode.isRef) {
                    typeref = elenode.getRef();
                    tmpdeclnode = typeref.getDeclNode();
                    if (tmpdeclnode == null || tmpdeclnode.getNodeType() != 50) continue;
                    list.addElement(tmpdeclnode);
                    continue;
                }
                list.addElement(node);
                continue;
            }
            if (node.getNodeType() == 52) {
                childnode = ((ComplexTypeNode)node).getChildren();
                if (childnode == null) continue;
                this.GetSubElementChild(childnode.getChildrenList(), list, grp);
                continue;
            }
            if (node.getNodeType() == 58) {
                if (((ContentModelNode)node).getType() != 0 || (childnode = ((ContentModelNode)node).getChildren()) == null) continue;
                this.GetSubElementChild(childnode.getChildrenList(), list, grp);
                continue;
            }
            if (node.getNodeType() == 62) {
                XsdChildren childnode2;
                DerivationNode drnode = (DerivationNode)node;
                if (drnode.getBase() != null) {
                    XsdChildren childnode3;
                    XsdTypeRef baseref;
                    if (drnode.getDerivationMode() == 1 && (tmpdeclnode = (baseref = drnode.getBase()).getDeclNode()) != null && tmpdeclnode.getNodeType() == 52 && (childnode3 = ((ComplexTypeNode)tmpdeclnode).getChildren()) != null) {
                        this.GetSubElementChild(childnode3.getChildrenList(), list, grp);
                    }
                    if ((childnode2 = ((DerivationNode)node).getChildren()) == null) continue;
                    this.GetSubElementChild(childnode2.getChildrenList(), list, grp);
                    continue;
                }
                childnode2 = ((DerivationNode)node).getChildren();
                if (childnode2 == null) continue;
                this.GetSubElementChild(childnode2.getChildrenList(), list, grp);
                continue;
            }
            if (node.getNodeType() == 54) {
                childnode = ((MgsDeclNode)node).getChildren();
                if (childnode == null) continue;
                this.GetSubElementChild(childnode.getChildrenList(), list, grp);
                continue;
            }
            if (node.getNodeType() != 56) continue;
            ModelGroupNode groupnode = (ModelGroupNode)node;
            if (grp != null) {
                if (grp.getNodeName().equals(groupnode.getNodeName())) {
                    grp = null;
                    continue;
                }
            } else {
                grp = groupnode;
            }
            if (groupnode.isRef()) {
                XsdChildren childnode4;
                typeref = groupnode.getRef();
                XSDDecl tmpxsd = typeref.getXsdDecl();
                XsdDeclNode tmpdeclnode2 = typeref.getDeclNode();
                if (tmpdeclnode2 != null && tmpdeclnode2.getNodeType() == 56 && (childnode4 = ((ModelGroupNode)tmpdeclnode2).getChildren()) != null) {
                    this.GetSubElementChild(childnode4.getChildrenList(), list, grp);
                }
            }
            grp = null;
        }
    }

    public XsdDeclNode getSubMgsDecl() {
        Vector child = null;
        XsdDeclNode mgs = null;
        XsdTypeRef typeattr = this.getTypeAttr();
        if (typeattr != null) {
            XSDDecl tmpxsd = typeattr.getXsdDecl();
            XsdDeclNode tmpdeclnode = typeattr.getDeclNode();
            if (tmpdeclnode.getNodeType() == 52) {
                if (!((ComplexTypeNode)tmpdeclnode).hasChildren()) {
                    return null;
                }
                XsdChildren children = tmpdeclnode.getChildren();
                child = children.getChildrenList();
            } else {
                return null;
            }
        }
        if (child == null) {
            if (this.children == null) {
                return null;
            }
            child = this.children.getChildrenList();
        }
        mgs = this.GetSubMgs(child, false);
        return mgs;
    }

    private XsdDeclNode GetSubMgs(Vector child, boolean extension) {
        int n = child.size();
        XsdDeclNode mg = null;
        for (int i = 0; i < n; ++i) {
            XsdChildren childnode;
            XsdDeclNode node = (XsdDeclNode)child.elementAt(i);
            if (node.getNodeType() == 51) {
                mg = this.GetSubMgs(((XsdChildren)node).getChildrenList(), extension);
                continue;
            }
            if (node.getNodeType() == 52) {
                childnode = ((ComplexTypeNode)node).getChildren();
                if (childnode == null) continue;
                mg = this.GetSubMgs(childnode.getChildrenList(), extension);
                continue;
            }
            if (node.getNodeType() == 58) {
                childnode = ((ContentModelNode)node).getChildren();
                if (childnode == null) continue;
                mg = this.GetSubMgs(childnode.getChildrenList(), extension);
                continue;
            }
            if (node.getNodeType() == 62) {
                childnode = ((DerivationNode)node).getChildren();
                DerivationNode deri = (DerivationNode)node;
                if (deri.getDerivationMode() == 1 && extension) {
                    XsdChildren basechild;
                    XsdDeclNode basedecl;
                    XsdTypeRef base = deri.getBase();
                    if (base == null || (basedecl = base.getDeclNode()) == null || (basechild = ((ComplexTypeNode)basedecl).getChildren()) == null) continue;
                    mg = this.GetSubMgs(basechild.getChildrenList(), extension);
                    continue;
                }
                if (childnode == null) continue;
                mg = this.GetSubMgs(childnode.getChildrenList(), extension);
                continue;
            }
            if (node.getNodeType() == 54) {
                mg = (MgsDeclNode)node;
                break;
            }
            if (node.getNodeType() != 56) continue;
            mg = (ModelGroupNode)node;
            break;
        }
        return mg;
    }

    public XsdDeclNode getExtensionMgsDecl() {
        XsdDeclNode exMgs = null;
        boolean extension = false;
        XsdTypeRef typeattr = this.getTypeAttr();
        if (typeattr != null) {
            return null;
        }
        if (!this.hasChildren()) {
            return null;
        }
        Vector child = this.children.getChildrenList();
        block0: for (int i = 0; i < child.size(); ++i) {
            XsdDeclNode node1 = (XsdDeclNode)child.elementAt(i);
            if (node1.getNodeType() != 52 || node1.getChildren() == null) continue;
            Vector cChildlist = node1.getChildren().getChildrenList();
            for (int j = 0; j < cChildlist.size(); ++j) {
                XsdDeclNode node2 = (XsdDeclNode)cChildlist.elementAt(j);
                if (node2.getNodeType() != 58 || node2.getChildren() == null) continue;
                Vector cmChildlist = node2.getChildren().getChildrenList();
                for (int k = 0; k < cmChildlist.size(); ++k) {
                    XsdDeclNode node3 = (XsdDeclNode)cmChildlist.elementAt(k);
                    if (node3.getNodeType() != 62) continue;
                    if (((DerivationNode)node3).getDerivationMode() != 1) break block0;
                    extension = true;
                    break block0;
                }
                break block0;
            }
            break;
        }
        if (!extension) {
            return null;
        }
        exMgs = this.GetSubMgs(child, true);
        return exMgs;
    }

    public int getOccurrenceSubElement(String name2) {
        XsdChildren tmpchildren;
        XsdDeclNode tmpdeclnode;
        int max = 0;
        this.CurrentHigherMaxOcc = 0;
        Vector child = null;
        if (this.typeAttr != null && (tmpdeclnode = this.typeAttr.getDeclNode()).getNodeType() != 73 && (tmpchildren = tmpdeclnode.getChildren()) != null) {
            child = tmpchildren.getChildrenList();
        }
        if (child == null) {
            if (this.children == null) {
                return 0;
            }
            child = this.children.getChildrenList();
        }
        XsdElementDeclNode eledecl = null;
        eledecl = this.getOccurrenceSubElementChild(child, name2);
        if (eledecl != null && (max = eledecl.getMaxOccurs()) == 1 && this.CurrentHigherMaxOcc > 1) {
            return this.CurrentHigherMaxOcc;
        }
        return max;
    }

    public int getMinOccurrenceSubElement(String name2) {
        XsdChildren tmpchildren;
        XsdDeclNode tmpdeclnode;
        int min = 0;
        this.CurrentHigherMaxOcc = 0;
        Vector child = null;
        if (this.typeAttr != null && (tmpdeclnode = this.typeAttr.getDeclNode()).getNodeType() != 73 && (tmpchildren = tmpdeclnode.getChildren()) != null) {
            child = tmpchildren.getChildrenList();
        }
        if (child == null) {
            if (this.children == null) {
                return 0;
            }
            child = this.children.getChildrenList();
        }
        XsdElementDeclNode eledecl = null;
        eledecl = this.getOccurrenceSubElementChild(child, name2);
        if (eledecl != null) {
            min = eledecl.getMinOccurs();
        }
        return min;
    }

    private XsdElementDeclNode getOccurrenceSubElementChild(Vector child, String name2) {
        if (child == null) {
            return null;
        }
        int n = child.size();
        XsdElementDeclNode ele = null;
        for (int i = 0; i < n; ++i) {
            XsdChildren childnode;
            XsdTypeRef typeref;
            XsdDeclNode tmpdeclnode;
            XsdChildren childnode2;
            XsdDeclNode node = (XsdDeclNode)child.elementAt(i);
            if (node.getNodeType() == 51) {
                ele = this.getOccurrenceSubElementChild(((XsdChildren)node).getChildrenList(), name2);
                if (ele == null) continue;
                return ele;
            }
            if (node.getNodeType() == 50) {
                XsdTypeRef ref;
                XsdElementDeclNode elenode = (XsdElementDeclNode)node;
                if (name2.equals(elenode.getName())) {
                    return elenode;
                }
                if (!elenode.isRef || !name2.equals((ref = elenode.getRef()).getNodeString())) continue;
                return elenode;
            }
            if (node.getNodeType() == 52) {
                childnode2 = ((ComplexTypeNode)node).getChildren();
                if (childnode2 == null || (ele = this.getOccurrenceSubElementChild(childnode2.getChildrenList(), name2)) == null) continue;
                return ele;
            }
            if (node.getNodeType() == 58) {
                childnode2 = ((ContentModelNode)node).getChildren();
                if (childnode2 == null || (ele = this.getOccurrenceSubElementChild(childnode2.getChildrenList(), name2)) == null) continue;
                return ele;
            }
            if (node.getNodeType() == 54) {
                childnode2 = ((MgsDeclNode)node).getChildren();
                if (childnode2 == null) continue;
                int currentMaxOcc = 0;
                if (((MgsDeclNode)node).getMaxOccours() > 1) {
                    currentMaxOcc = ((MgsDeclNode)node).getMaxOccours();
                }
                if ((ele = this.getOccurrenceSubElementChild(childnode2.getChildrenList(), name2)) == null) continue;
                if (currentMaxOcc != 0) {
                    this.CurrentHigherMaxOcc = currentMaxOcc;
                }
                return ele;
            }
            if (node.getNodeType() == 56) {
                ModelGroupNode groupnode = (ModelGroupNode)node;
                if (!groupnode.isRef() || (tmpdeclnode = (typeref = groupnode.getRef()).getDeclNode()) == null || tmpdeclnode.getNodeType() != 56 || (childnode = ((ModelGroupNode)tmpdeclnode).getChildren()) == null) continue;
                int currentGrpMaxOcc = 0;
                if (this.CurrentHigherMaxOcc <= 1) {
                    currentGrpMaxOcc = groupnode.getMaxOccours();
                }
                if ((ele = this.getOccurrenceSubElementChild(childnode.getChildrenList(), name2)) == null) continue;
                if (currentGrpMaxOcc != 0) {
                    this.CurrentHigherMaxOcc = currentGrpMaxOcc;
                }
                return ele;
            }
            if (node.getNodeType() != 62) continue;
            DerivationNode derinode = (DerivationNode)node;
            if (derinode.getDerivationMode() == 1 && derinode.getBase() != null && (tmpdeclnode = (typeref = derinode.getBase()).getDeclNode()) != null && tmpdeclnode.getNodeType() == 52 && (childnode = ((ComplexTypeNode)tmpdeclnode).getChildren()) != null && (ele = this.getOccurrenceSubElementChild(childnode.getChildrenList(), name2)) != null) {
                return ele;
            }
            XsdChildren childnode3 = ((DerivationNode)node).getChildren();
            if (childnode3 == null || (ele = this.getOccurrenceSubElementChild(childnode3.getChildrenList(), name2)) == null) continue;
            return ele;
        }
        return null;
    }

    @Override
    public XsdDeclNode getSubElementDecl(String name2) {
        if (this.xsd == null || this.isRef) {
            return null;
        }
        XsdDeclNodeList nodelist = this.getSubElementDecls();
        int n1 = nodelist.size();
        for (int j = 0; j < n1; ++j) {
            XsdElementDeclNode elem = (XsdElementDeclNode)nodelist.item(j);
            if (!name2.equals(elem.getName())) continue;
            return elem;
        }
        return null;
    }

    @Override
    public Vector getChildNames() {
        XsdTypeRef typeattr;
        Object childName = null;
        Vector child = null;
        Vector nameList = new Vector();
        if (this.children != null) {
            child = this.children.getChildrenList();
        }
        if ((typeattr = this.getTypeAttr()) != null) {
            XSDDecl tmpxsd = typeattr.getXsdDecl();
            XsdDeclNode tmpdeclnode = typeattr.getDeclNode();
            if (tmpdeclnode.getNodeType() != 73) {
                XsdChildren children;
                if (child != null) {
                    child.clear();
                }
                if ((children = tmpdeclnode.getChildren()) != null) {
                    child = children.getChildrenList();
                }
            }
        }
        this.GetSubElementChildName(child, nameList, null);
        return nameList;
    }

    private void GetSubElementChildName(Vector child, Vector namelist, XsdDeclNode grp) {
        if (child == null) {
            return;
        }
        int n = child.size();
        for (int i = 0; i < n; ++i) {
            XsdChildren childnode;
            XsdDeclNode tmpdeclnode;
            XsdChildren childnode2;
            XsdTypeRef typeref;
            XsdDeclNode node = (XsdDeclNode)child.elementAt(i);
            if (node.getNodeType() == 51) {
                this.GetSubElementChildName(((XsdChildren)node).getChildrenList(), namelist, grp);
                continue;
            }
            if (node.getNodeType() == 50) {
                XsdElementDeclNode elenode = (XsdElementDeclNode)node;
                if (elenode.isRef) {
                    typeref = elenode.getRef();
                    XSDDecl tmpxsd = typeref.getXsdDecl();
                    namelist.addElement(typeref.getNodeString());
                    continue;
                }
                namelist.addElement(elenode.getName());
                continue;
            }
            if (node.getNodeType() == 52) {
                childnode2 = ((ComplexTypeNode)node).getChildren();
                if (childnode2 == null) continue;
                this.GetSubElementChildName(childnode2.getChildrenList(), namelist, grp);
                continue;
            }
            if (node.getNodeType() == 58) {
                if (((ContentModelNode)node).getType() != 0 || (childnode2 = ((ContentModelNode)node).getChildren()) == null) continue;
                this.GetSubElementChildName(childnode2.getChildrenList(), namelist, grp);
                continue;
            }
            if (node.getNodeType() == 62) {
                XsdChildren childnode3;
                DerivationNode drnode = (DerivationNode)node;
                if (drnode.getBase() != null) {
                    XsdTypeRef baseref;
                    if (drnode.getDerivationMode() == 1 && (tmpdeclnode = (baseref = drnode.getBase()).getDeclNode()) != null && tmpdeclnode.getNodeType() == 52 && (childnode = ((ComplexTypeNode)tmpdeclnode).getChildren()) != null) {
                        this.GetSubElementChildName(childnode.getChildrenList(), namelist, grp);
                    }
                    if ((childnode3 = ((DerivationNode)node).getChildren()) == null) continue;
                    this.GetSubElementChildName(childnode3.getChildrenList(), namelist, grp);
                    continue;
                }
                childnode3 = ((DerivationNode)node).getChildren();
                if (childnode3 == null) continue;
                this.GetSubElementChildName(childnode3.getChildrenList(), namelist, grp);
                continue;
            }
            if (node.getNodeType() == 54) {
                childnode2 = ((MgsDeclNode)node).getChildren();
                if (childnode2 == null) continue;
                this.GetSubElementChildName(childnode2.getChildrenList(), namelist, grp);
                continue;
            }
            if (node.getNodeType() != 56) continue;
            ModelGroupNode groupnode = (ModelGroupNode)node;
            if (grp != null) {
                if (grp.getNodeName().equals(groupnode.getNodeName())) {
                    grp = null;
                    continue;
                }
            } else {
                grp = groupnode;
            }
            if (groupnode.isRef() && (tmpdeclnode = (typeref = groupnode.getRef()).getDeclNode()) != null && (childnode = ((ModelGroupNode)tmpdeclnode).getChildren()) != null) {
                this.GetSubElementChildName(childnode.getChildrenList(), namelist, grp);
            }
            grp = null;
        }
    }

    public Hashtable getAttDefs() {
        return this.attributeDefs;
    }

    void addAttDefs(Vector attdefs) {
        int n = attdefs.size();
        for (int i = 0; i < n; ++i) {
            this.addAttDef((XsdAttDef)attdefs.elementAt(i));
        }
    }

    public void addAttDef(XsdAttDef attdef) {
        if (this.attributeDefs == null) {
            this.attributeDefs = new Hashtable(5);
        }
        this.attributeDefs.put(attdef.getAttributeName(), attdef);
    }

    void removeAttDef(XsdAttDef attdef) {
        if (this.attributeDefs == null) {
            return;
        }
        this.attributeDefs.remove(attdef.getAttributeName());
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return this.dtDecl;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
        this.dtDecl = dtDecl;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    public void setTypeAttr(XsdTypeRef typeModel) {
        this.typeAttr = typeModel;
    }

    public void setRefName(XsdTypeRef refModel) {
        this.ref = refModel;
        this.isRef = true;
    }

    private boolean parseDeclContent() throws XSDException {
        this.in.peekWhitespace();
        if (this.in.peek("type")) {
            this.in.peekWhitespace();
            this.in.peek("=");
            this.in.peekWhitespace();
        }
        if (this.in.peekc('%')) {
            this.isRef = true;
            String entityName = this.in.peekXmlName();
            if (entityName == null) {
                XSDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
            }
            if (!this.in.peekc(';')) {
                XSDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entityName, ";"});
            }
            this.childNames = new Vector();
            this.childNames.addElement(entityName);
        }
        this.in.peekWhitespace();
        return true;
    }

    private boolean parseElementMixed() throws XSDException {
        this.in.backup();
        if (!this.in.peekc('(')) {
            XSDDocument.fatal("NEED_CHAR", (Locator)this.in, "(");
        }
        this.in.peekWhitespace();
        if (!this.in.peek("#PCDATA")) {
            this.in.restore();
            return false;
        }
        this.in.peekWhitespace();
        if (this.in.peek(")")) {
            if (this.in.peek("*")) {
                // empty if block
            }
            this.childNames = null;
        } else {
            if (this.in.isEOF() || this.in.isChar('>')) {
                XSDDocument.fatal("NEED_CHAR", (Locator)this.in, ")");
            }
            this.childNames = new Vector();
            while (this.in.peek("|")) {
                this.in.peekWhitespace();
                if (this.in.peekc('%')) {
                    String entity = this.in.peekXmlName();
                    if (entity == null) {
                        XSDDocument.fatal("NEED_ENTITY_REF", (Locator)this.in, "%");
                    }
                    if (!this.in.peekc(';')) {
                        XSDDocument.fatal("INVALID_ENTITY_REF", (Locator)this.in, new Object[]{entity, ";"});
                    }
                    this.childNames.addElement("%" + entity + ";");
                } else {
                    String subtag = this.in.peekXmlName();
                    if (subtag == null) {
                        XSDDocument.fatal("INVALID_CHAR", (Locator)this.in, "|");
                    }
                    if (this.childNames.contains(subtag)) {
                        XSDDocument.fatal("DOUBLE_NAME", (Locator)this.in, subtag);
                    } else {
                        this.childNames.addElement(subtag);
                    }
                }
                this.in.peekWhitespace();
            }
            if (!this.in.peek(")*")) {
                XSDDocument.fatal("NEED_CHAR", (Locator)this.in, ")*");
            }
        }
        return true;
    }

    public String getXML() {
        XSDDecl tmpxsd;
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        String typeRefName = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        if (this.ref != null) {
            sb.append("<" + prefix + "element ref=\"");
            typeRefName = this.ref.toString();
            tmpxsd = this.ref.getXsdDecl();
            if (tmpxsd != null && this.xsd != null) {
                typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.ref.toString());
            }
            sb.append(typeRefName);
            sb.append("\"");
        } else {
            sb.append("<" + prefix + "element name=\"");
            sb.append(this.name);
            sb.append("\" ");
            if (this.typeAttr != null) {
                sb.append(" type=\"");
                typeRefName = this.typeAttr.toString();
                tmpxsd = this.typeAttr.getXsdDecl();
                if (tmpxsd != null && this.xsd != null) {
                    typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.typeAttr.toString());
                }
                sb.append(typeRefName);
                sb.append("\"");
            }
        }
        this.makeDeclContent(sb);
        if (this.minOcc != null && this.minOcc != "") {
            sb.append(" minOccurs=\"" + this.minOcc + "\" ");
        }
        if (this.maxOcc != null && this.maxOcc != "") {
            sb.append(" maxOccurs=\"" + this.maxOcc + "\" ");
        }
        if (this.sDefault != null) {
            sb.append(" default=\"" + this.sDefault + "\" ");
        }
        if (this.bAbstract) {
            sb.append(" abstract=\"" + this.getAbstract() + "\" ");
        }
        if (this.fixed != null) {
            sb.append(" fixed=\"" + this.fixed + "\" ");
        }
        if (this.block != null) {
            sb.append(" block=\"" + this.block + "\" ");
        }
        if (this.sFinal != null) {
            sb.append(" final=\"" + this.sFinal + "\" ");
        }
        if (this.nillable) {
            sb.append(" nillable=\"" + this.getNillable() + "\" ");
        }
        if (this.subtitutionGroup != null) {
            sb.append(" substitutionGroup=\"" + this.subtitutionGroup + "\" ");
        }
        if (this.form != null) {
            sb.append(" form=\"" + this.form + "\" ");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "element>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }

    public String getEntityName() {
        if (!this.isRef) {
            return null;
        }
        if (this.childNames == null) {
            return null;
        }
        if (this.childNames.size() < 1) {
            return null;
        }
        return this.childNames.elementAt(0).toString();
    }

    public String toString() {
        return this.getXML();
    }

    private void makeDeclContent(StringBuffer sb) {
        if (this.isRef) {
            if (this.childNames == null) {
                return;
            }
            if (this.childNames.size() < 1) {
                return;
            }
            String s = (String)this.childNames.elementAt(0);
            if (s != null) {
                if ((s = s.trim()).equals("")) {
                    return;
                }
                sb.append('%');
                sb.append(s);
                sb.append(';');
            }
            return;
        }
    }

    @Override
    public void repleaceEntity() throws XSDException {
        if (this.xsd == null) {
            return;
        }
        if (this.isRef) {
            // empty if block
        }
    }

    @Override
    public XsdDeclNode getOwner() {
        return this.xsd;
    }

    public static void main(String[] args) {
    }
}

