/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdFacet;
import java.util.Vector;

public class XsdFacetNode
implements XsdFacet {
    int type;
    String value = null;
    boolean fixed = false;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public XsdFacetNode(XSDDecl xsd, int type, String value, String fixed) {
        this.xsd = xsd;
        this.type = type;
        this.value = value;
        this.setFixed(fixed);
    }

    public XsdFacetNode(XSDDecl xsd, int type, String value) {
        this.xsd = xsd;
        this.type = type;
        this.value = value;
        this.fixed = false;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    public void setFixed(String fixed) {
        this.fixed = fixed == null ? false : fixed.equals("true");
    }

    @Override
    public boolean getFixedBool() {
        return this.fixed;
    }

    @Override
    public String getFixed() {
        if (this.fixed) {
            return "true";
        }
        return "false";
    }

    private String getTypeName() {
        if (this.type == 0) {
            return "length";
        }
        if (this.type == 1) {
            return "minLength";
        }
        if (this.type == 2) {
            return "maxLength";
        }
        if (this.type == 3) {
            return "pattern";
        }
        if (this.type == 4) {
            return "enumeration";
        }
        if (this.type == 5) {
            return "whiteSpace";
        }
        if (this.type == 6) {
            return "maxInclusive";
        }
        if (this.type == 7) {
            return "maxExclusive";
        }
        if (this.type == 8) {
            return "minInclusive";
        }
        if (this.type == 9) {
            return "minExclusive";
        }
        if (this.type == 11) {
            return "fractionDigits";
        }
        if (this.type == 10) {
            return "totalDigits";
        }
        return "";
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 65;
    }

    @Override
    public String getNodeName() {
        return this.getTypeName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "Facet";
    }

    @Override
    public String getName() {
        return this.getTypeName();
    }

    public String getXML() {
        String typeRefbaseName = "";
        String prefix = "";
        StringBuffer sb = new StringBuffer();
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + this.getTypeName());
        if (this.value != null) {
            sb.append(" value=\"");
            sb.append(this.value);
            sb.append("\"");
        }
        if (this.fixed) {
            sb.append(" fixed=\"true\"");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + this.getTypeName() + ">\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

