/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdImport;
import java.util.Vector;

public class XsdImportNode
implements XsdImport {
    String nameSpace = null;
    String schemaLocation = null;
    XSDDocument importXsd = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public XsdImportNode(XSDDecl xsd, String nameSpace, String schemaLocation) {
        this.xsd = xsd;
        this.nameSpace = nameSpace;
        this.schemaLocation = schemaLocation;
    }

    @Override
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    @Override
    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setImportXsd(XSDDocument XSDDoc) {
        this.importXsd = XSDDoc;
    }

    public XSDDocument getImportXsd() {
        return this.importXsd;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 68;
    }

    @Override
    public String getNodeName() {
        return this.schemaLocation;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "Import";
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + "import");
        if (this.nameSpace != null) {
            sb.append(" namespace=\"");
            sb.append(this.nameSpace);
            sb.append("\"");
        }
        if (this.schemaLocation != null) {
            sb.append(" schemaLocation=\"");
            sb.append(this.schemaLocation);
            sb.append("\"");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "import>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

