/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdList;
import com.argo21.jxp.xsd.XsdTypeRef;
import java.util.Vector;

public class XsdListNode
implements XsdList {
    XsdTypeRef itemType = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public XsdListNode(XSDDecl xsd, XsdTypeRef itemType) {
        this.xsd = xsd;
        this.itemType = itemType;
    }

    public XsdListNode(XSDDecl xsd) {
        this.xsd = xsd;
        this.itemType = null;
    }

    @Override
    public String getName() {
        return this.getNodeTypeName();
    }

    public String getItemTypeName() {
        if (this.itemType != null) {
            return this.itemType.toString();
        }
        return null;
    }

    @Override
    public XsdTypeRef getItemType() {
        return this.itemType;
    }

    public boolean isItemType() {
        return this.itemType != null;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 64;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "list";
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        String name2 = this.getNodeName();
        String typeRefName = "";
        if (this.itemType != null) {
            sb.append("<" + prefix + "list itemType=\"");
            typeRefName = this.itemType.toString();
            XSDDecl tmpxsd = this.itemType.getXsdDecl();
            if (tmpxsd != null && this.xsd != null) {
                typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), this.itemType.toString());
            }
            sb.append(typeRefName);
            sb.append("\"");
        } else {
            sb.append("<" + prefix + "list");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "list>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

