/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XSDException;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdNotationDecl;
import java.util.Vector;
import org.xml.sax.Locator;

public class XsdNotationDeclNode
implements XsdNotationDecl {
    String notationName;
    String publicId;
    String systemId;
    XSDDecl xsd = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XsdDeclNode owner;
    int type = 0;
    public static final int SYSTEM = 1;
    public static final int PUBLIC = 2;
    private XReader in;

    private XsdNotationDeclNode() {
    }

    XsdNotationDeclNode(XSDDecl xsd, String notationName, String notationContents) throws XSDException {
        this.xsd = xsd;
        this.notationName = notationName;
        this.in = XReader.createReader(notationContents.toCharArray(), null);
        this.parseNotationDecl();
        this.in = null;
    }

    XsdNotationDeclNode(XSDDecl xsd, XReader in) throws XSDException {
        this.xsd = xsd;
        this.in = in;
        this.notationName = in.peekXmlName();
        if (this.notationName != null) {
            if (!in.peekWhitespace()) {
                XSDDocument.fatal("NEED_NOTATION_NAME", (Locator)in);
            }
            this.parseNotationDecl();
        } else {
            XSDDocument.fatal("NEED_NOTATION_NAME", (Locator)in);
        }
        this.in = null;
    }

    public XsdNotationDeclNode(XSDDecl xsd, String notationName, String publicId, String systemId) {
        this.xsd = xsd;
        this.notationName = notationName;
        this.publicId = publicId;
        this.systemId = systemId;
        this.type = this.publicId == null ? 1 : (this.publicId.equals("") ? 1 : 2);
    }

    private boolean parseNotationDecl() throws XSDException {
        this.in.peekWhitespace();
        if (this.in.peek("SYSTEM")) {
            this.type = 1;
            if (!this.in.peekWhitespace()) {
                XSDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
            }
            return this.parseSystemLiteral();
        }
        if (this.in.peek("PUBLIC")) {
            this.type = 2;
            if (!this.in.peekWhitespace()) {
                XSDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (!this.parsePubidLiteral()) {
                XSDDocument.fatal("NEED_PUBLICID", (Locator)this.in);
            }
            if (this.in.peekWhitespace()) {
                this.parseSystemLiteral();
            }
            return true;
        }
        return false;
    }

    private boolean parseSystemLiteral() throws XSDException {
        this.systemId = this.in.peekQuotedString();
        if (this.systemId == null) {
            XSDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
        }
        return this.systemId != null;
    }

    private boolean parsePubidLiteral() throws XSDException {
        this.publicId = this.in.peekQuotedString();
        if (this.publicId == null) {
            XSDDocument.fatal("NEED_SYSTEMID", (Locator)this.in);
        }
        return this.publicId != null;
    }

    @Override
    public XsdNotationDecl cloneNode(boolean deep) {
        XsdNotationDeclNode edecl = new XsdNotationDeclNode();
        edecl.notationName = this.notationName;
        edecl.publicId = this.publicId;
        edecl.systemId = this.systemId;
        return edecl;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public String getNodeTypeName() {
        return "Notation";
    }

    @Override
    public String getNodeName() {
        return this.notationName;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getNodeType() {
        return 12;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return null;
    }

    public String getXML() {
        String typeRefbaseName = "";
        String prefix = "";
        StringBuffer sb = new StringBuffer();
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        sb.append("<" + prefix + "notation");
        if (this.notationName != null && this.notationName != "") {
            sb.append(" name=\"" + this.notationName + "\" ");
        }
        if (this.publicId != null && this.publicId != "") {
            sb.append(" public=\"" + this.publicId + "\" ");
        }
        if (this.systemId != null && this.systemId != "") {
            sb.append(" system=\"" + this.systemId + "\" ");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "notation>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }

    public String toString() {
        return this.getXML();
    }

    private String getContents() {
        if (this.type == 1) {
            return "system \"" + this.systemId + "\"";
        }
        if (this.type == 2) {
            String s = "public \"" + this.publicId + "\"";
            if (this.systemId != null) {
                return s + " \"" + this.systemId + "\"";
            }
            return s;
        }
        return null;
    }

    @Override
    public XsdDeclNode getOwner() {
        return this.xsd;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    public static void main(String[] argv) {
        try {
            XsdNotationDeclNode el = new XsdNotationDeclNode(null, "AAA", "PUBLIC \"SDF\"  \"http://woodland.co.jp/a.xml\"");
            System.out.println(el.getXML());
        }
        catch (XSDException e) {
            System.out.println(e.getMessage());
        }
    }
}

