/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;

public class XsdTypeRefNode
implements XsdTypeRef {
    XSDDecl xsd = null;
    XsdDeclNode declnode = null;
    int targetNodeType;
    int targetFindType;
    boolean isTypeNode = false;
    String nodePrefix = null;
    String nodeString = null;

    public XsdTypeRefNode(XSDDecl xsd, XsdDeclNode declnode, int nodeType, int findType) {
        this.targetNodeType = nodeType;
        this.targetFindType = findType;
        if (xsd == null || declnode == null) {
            this.xsd = xsd;
            this.declnode = declnode;
            this.isTypeNode = false;
        } else {
            this.xsd = xsd;
            this.declnode = declnode;
            this.isTypeNode = true;
        }
    }

    public XsdTypeRefNode(XSDDecl xsd, String nodeString, int nodeType, int findType) {
        this.targetNodeType = nodeType;
        this.targetFindType = findType;
        this.xsd = xsd;
        this.nodeString = nodeString;
        this.isTypeNode = true;
    }

    public XsdTypeRefNode(String prefix, String type, int nodeType, int findType) {
        this.targetNodeType = nodeType;
        this.targetFindType = findType;
        this.nodePrefix = prefix;
        this.nodeString = type;
        this.isTypeNode = false;
    }

    @Override
    public String toString() {
        if (this.isTypeNode) {
            return this.nodeString;
        }
        return this.nodeString;
    }

    @Override
    public String getNamespaceTargetNode() {
        if (!this.isTypeNode) {
            return null;
        }
        return this.xsd.getNameSpace();
    }

    public XsdDeclNode getXsdDeclNode() {
        if (this.xsd == null) {
            return null;
        }
        XsdDeclNode decl = this.xsd.getTypeXsdDeclNode(this.nodeString, this.targetNodeType, this.targetFindType);
        return decl;
    }

    @Override
    public XSDDecl getXsdDecl() {
        return this.xsd;
    }

    @Override
    public void setXsdDecl(XSDDecl xsd) {
        this.xsd = xsd;
        if (this.nodeString != null) {
            this.isTypeNode = true;
        }
    }

    @Override
    public XsdDeclNode getDeclNode() {
        if (this.xsd == null) {
            return null;
        }
        XsdDeclNode decl = this.xsd.getTypeXsdDeclNode(this.nodeString, this.targetNodeType, this.targetFindType);
        return decl;
    }

    @Override
    public void setXsdDeclNode(XsdDeclNode declnode) {
        this.declnode = declnode;
        if (this.xsd != null) {
            this.isTypeNode = true;
        }
    }

    @Override
    public boolean isTypeNode() {
        return this.isTypeNode;
    }

    @Override
    public String getNodePrefix() {
        return this.nodePrefix;
    }

    @Override
    public void setNodePrefix(String nodePrefix) {
        this.nodePrefix = nodePrefix;
    }

    @Override
    public String getNodeString() {
        return this.nodeString;
    }

    @Override
    public void setNodeString(String nodeString) {
        this.nodeString = nodeString;
    }

    @Override
    public int getTargetNodeType() {
        return this.targetNodeType;
    }

    @Override
    public int getTargetFindType() {
        return this.targetFindType;
    }
}

