/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.jxp.xsd;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XsdChildren;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdTypeRef;
import com.argo21.jxp.xsd.XsdUnion;
import java.util.Vector;

public class XsdUnionNode
implements XsdUnion {
    Vector memberType = null;
    XsdChildren children = null;
    XsdDeclNode parent = null;
    XSDDecl xsd = null;

    public XsdUnionNode(XSDDecl xsd, Vector memberType) {
        this.xsd = xsd;
        this.memberType = memberType;
    }

    public XsdUnionNode(XSDDecl xsd) {
        this.xsd = xsd;
        this.memberType = null;
    }

    @Override
    public String getName() {
        return this.getNodeTypeName();
    }

    @Override
    public Vector getMemberTypeVector() {
        return this.memberType;
    }

    @Override
    public int getMemberTypeSize() {
        return this.memberType.size();
    }

    @Override
    public XsdTypeRef getMemberType(int index) {
        if (this.memberType.size() == 0) {
            return null;
        }
        return (XsdTypeRef)this.memberType.elementAt(index);
    }

    @Override
    public XsdChildren getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(XsdChildren children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        if (this.children != null) {
            Vector childList = this.children.getChildrenList();
            return childList.size() > 0;
        }
        return false;
    }

    @Override
    public int getNodeType() {
        return 63;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public XsdDeclNode getParentDecl() {
        return this.parent;
    }

    @Override
    public void setParentDecl(XsdDeclNode node) {
        this.parent = node;
    }

    @Override
    public XsdDeclNode getOwner() {
        return null;
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public String getNodeTypeName() {
        return "union";
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        if (this.xsd != null) {
            prefix = this.xsd.getSchemaPrefix(true);
        }
        String name2 = this.getNodeName();
        String typeRefName = "";
        XsdTypeRef typeRef = null;
        XSDDecl tmpxsd = null;
        if (this.memberType != null && this.memberType.size() > 0) {
            sb.append("<" + prefix + "union memberTypes=\"");
            for (int i = 0; i < this.memberType.size(); ++i) {
                typeRef = (XsdTypeRef)this.memberType.elementAt(i);
                if (typeRef == null) continue;
                typeRefName = typeRef.toString();
                tmpxsd = typeRef.getXsdDecl();
                if (tmpxsd != null && this.xsd != null) {
                    typeRefName = this.xsd.getTyperefNameAdditionPrefix(tmpxsd.getNameSpace(), typeRef.toString());
                }
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(typeRefName);
            }
            sb.append("\"");
        } else {
            sb.append("<" + prefix + "union");
        }
        if (this.hasChildren()) {
            sb.append(">\n");
            Vector childList = this.children.getChildrenList();
            int n = childList.size();
            for (int i = 0; i < n; ++i) {
                XsdDeclNode node = (XsdDeclNode)childList.elementAt(i);
                sb.append(node.toString());
            }
            sb.append("</" + prefix + "union>\n");
        } else {
            sb.append("/>\n");
        }
        String s = sb.toString();
        return s;
    }
}

